/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.win32service;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.Log;
import com.zerog.interfaces.util.StringResolver;
import java.util.Vector;

public class NTServiceConfig
implements PropertyAccessible {
    public static final int SERVICE_FILE_SYSTEM_DRIVER = 2;
    public static final int SERVICE_KERNEL_DRIVER = 1;
    public static final int SERVICE_ADAPTER = 4;
    public static final int SERVICE_RECOGNIZER_DRIVER = 8;
    public static final int SERVICE_DRIVER = 15;
    public static final int SERVICE_WIN32_OWN_PROCESS = 16;
    public static final int SERVICE_WIN32_SHARE_PROCESS = 32;
    public static final int SERVICE_WIN32 = 48;
    public static final int SERVICE_TYPE_ALL = 63;
    public static final int SERVICE_AUTO_START = 2;
    public static final int SERVICE_BOOT_START = 0;
    public static final int SERVICE_DEMAND_START = 3;
    public static final int SERVICE_DISABLED = 4;
    public static final int SERVICE_SYSTEM_START = 1;
    public static final int SERVICE_ERROR_IGNORE = 0;
    public static final int SERVICE_ERROR_NORMAL = 1;
    public static final int SERVICE_ERROR_SEVERE = 2;
    public static final int SERVICE_ERROR_CRITICAL = 3;
    private String displayName = "";
    private int serviceType = 16;
    private boolean enableDesktopInteraction = false;
    private int startType = 2;
    private int errorControl = 1;
    private String command = "";
    private String loadOrderGroup = "";
    private Vector dependencies = new Vector();
    private String userName = "";
    private String password = "";

    public NTServiceConfig() {
    }

    public NTServiceConfig(NTServiceConfig copyFrom) {
        this.displayName = copyFrom.displayName;
        this.serviceType = copyFrom.serviceType;
        this.enableDesktopInteraction = copyFrom.enableDesktopInteraction;
        this.startType = copyFrom.startType;
        this.errorControl = copyFrom.errorControl;
        this.command = copyFrom.command;
        this.loadOrderGroup = copyFrom.loadOrderGroup;
        this.dependencies = copyFrom.dependencies;
        this.userName = copyFrom.userName;
        this.password = copyFrom.password;
    }

    public String toString() {
        return "Service Configuration";
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public void setEnableDesktopInteraction(boolean enableDesktopInteraction) {
        this.enableDesktopInteraction = enableDesktopInteraction;
    }

    public boolean getEnableDesktopInteraction() {
        return this.enableDesktopInteraction;
    }

    public void setStartType(int startType) {
        this.startType = startType;
    }

    public int getStartType() {
        return this.startType;
    }

    public void setErrorControl(int errorControl) {
        this.errorControl = errorControl;
    }

    public int getErrorControl() {
        return this.errorControl;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setLoadOrderGroup(String loadOrderGroup) {
        this.loadOrderGroup = loadOrderGroup;
    }

    public String getLoadOrderGroup() {
        return this.loadOrderGroup;
    }

    public void setDependencies(String[] dependencies) {
        if (dependencies == null) {
            if (this.dependencies != null) {
                this.dependencies.removeAllElements();
                this.dependencies = null;
            }
            return;
        }
        this.verifyDependencies();
        this.dependencies.removeAllElements();
        for (int ii = 0; ii < dependencies.length; ++ii) {
            this.addDependency(dependencies[ii]);
        }
    }

    public String[] getDependencies() {
        this.verifyDependencies();
        Object[] results = new String[this.dependencies.size()];
        this.dependencies.copyInto(results);
        return results;
    }

    public void addDependency(String dependency) {
        this.verifyDependencies();
        if (!this.dependencies.contains(dependency)) {
            this.dependencies.addElement(dependency);
        }
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void validateForBuild(Log log, Object logSource) {
        if ((this.startType == 1 || this.startType == 0) && (this.serviceType & 0xF) == 0) {
            log.logEvent(logSource, "err", "Use service start type 'System Start' or 'Boot Start' only if you are installing a driver service");
        }
        if (this.getEnableDesktopInteraction() && this.userName != null && this.userName.length() > 0) {
            log.logEvent(logSource, "err", "Desktop interaction can only be enabled if the local system account is used to start the service.");
        }
    }

    public NTServiceConfig resolve(StringResolver resolver) {
        NTServiceConfig resolvedConfig = new NTServiceConfig(this);
        resolvedConfig.setDisplayName(resolver.resolveString(this.getDisplayName()));
        resolvedConfig.setCommand(resolver.resolveString(this.getCommand()));
        resolvedConfig.setLoadOrderGroup(resolver.resolveString(this.getLoadOrderGroup()));
        String[] dependencies = this.getDependencies();
        if (dependencies != null) {
            for (int ii = 0; ii < dependencies.length; ++ii) {
                dependencies[ii] = resolver.resolveString(dependencies[ii]);
            }
            resolvedConfig.setDependencies(dependencies);
        }
        resolvedConfig.setUserName(resolver.resolveString(this.getUserName()));
        resolvedConfig.setPassword(resolver.resolveString(this.getPassword()));
        return resolvedConfig;
    }

    private void verifyDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new Vector();
        }
    }
}

