/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.win32service;

import com.installshield.util.Log;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.platform.win32.win32service.NTServiceConfig;
import com.installshield.wizard.platform.win32.win32service.NTServiceStatus;
import com.installshield.wizard.platform.win32.win32service.Win2kServiceFailureActions;
import com.installshield.wizard.service.ServiceException;

public class Win32ServiceUtils {
    public static void installService(Win32Service win32Service, String name, NTServiceConfig config, boolean enableFailureActions, Win2kServiceFailureActions failureActions, String description, boolean startAfterInstalling, String[] startArgs, Log log, Object logSource) throws ServiceException {
        boolean isWin2k = win32Service.isWin2k();
        win32Service.createNTService(name, config);
        if (isWin2k && enableFailureActions) {
            try {
                win32Service.changeWin2kServiceFailureActions(name, failureActions);
            }
            catch (ServiceException e) {
                log.logEvent(logSource, "wrn", "Unable to set failure actions for service " + name + ": " + e);
            }
        }
        if (isWin2k && description != null) {
            try {
                win32Service.changeWin2kServiceDescription(name, description);
            }
            catch (ServiceException e) {
                log.logEvent(logSource, "wrn", "Unable to set description for service " + name + ": " + e);
            }
        }
        if (startAfterInstalling) {
            try {
                win32Service.startNTService(name, startArgs);
            }
            catch (ServiceException e) {
                log.logEvent(logSource, "wrn", "Unable to start service " + name + ": " + e);
            }
        }
    }

    public static void deleteService(Win32Service win32Service, String name, Log log, Object logObject) throws ServiceException {
        if (win32Service.serviceExists(name)) {
            if (win32Service.queryNTServiceStatus(name).getCurrentState() != 1) {
                NTServiceStatus status = win32Service.controlNTService(name, 1);
                for (int count = 0; count < 5 && status.getCurrentState() != 1; ++count) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    status = win32Service.queryNTServiceStatus(name);
                }
            }
            win32Service.deleteNTService(name);
        } else {
            log.logEvent(logObject, "msg1", "Service was already removed: " + name);
        }
    }
}

