/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.Progress;
import com.installshield.wizard.service.AsynchronousOperation;
import com.installshield.wizard.service.GenericOperationManager;
import com.installshield.wizard.service.OperationException;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.OperationStateListener;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceImplementor;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesImpl;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public abstract class AbstractServiceImplementor
implements ServiceImplementor,
PropertyAccessible,
OperationStateListener {
    private Properties properties = new Properties();
    private WizardServices services = null;
    private GenericOperationManager opManager;

    public void initialize(Properties properties, WizardServices services) {
        this.properties = properties;
        this.services = services;
        this.opManager = new GenericOperationManager();
        this.initialized();
    }

    protected void initialized() {
    }

    public void cleanup() throws ServiceException {
    }

    public Properties getProperties() {
        return this.properties;
    }

    public WizardServices getServices() {
        return this.services;
    }

    public void log(Object origin, String event, Object msg) {
        if (this.services == null) {
            throw new IllegalStateException("service manager not initialized");
        }
        this.services.logEvent(origin, event, msg);
    }

    public Progress getOperationProgress(OperationKey key) throws ServiceException {
        try {
            return this.opManager.getOperationProgress(key);
        }
        catch (OperationException opErr) {
            throw new ServiceException(316, opErr.getMessage());
        }
    }

    public void suspendOperation(OperationKey key) throws ServiceException {
        try {
            this.opManager.suspendOperation(key);
        }
        catch (OperationException opErr) {
            throw new ServiceException(316, opErr.getMessage());
        }
    }

    public boolean isOperationSuspended(OperationKey key) throws ServiceException {
        try {
            return this.opManager.isOperationSuspended(key);
        }
        catch (OperationException opErr) {
            throw new ServiceException(316, opErr.getMessage());
        }
    }

    public void cancelOperation(OperationKey key) throws ServiceException {
        try {
            this.opManager.cancelOperation(key);
        }
        catch (OperationException opErr) {
            throw new ServiceException(316, opErr.getMessage());
        }
    }

    public boolean isOperationCanceled(OperationKey key) throws ServiceException {
        try {
            return this.opManager.isOperationCanceled(key);
        }
        catch (OperationException opErr) {
            throw new ServiceException(316, opErr.getMessage());
        }
    }

    public void resumeOperation(OperationKey key) throws ServiceException {
        try {
            this.opManager.resumeOperation(key);
        }
        catch (OperationException opErr) {
            throw new ServiceException(316, opErr.getMessage());
        }
    }

    protected AsynchronousOperation getOperation(OperationKey key) throws ServiceException {
        try {
            return this.opManager.getOperation(key);
        }
        catch (OperationException opErr) {
            throw new ServiceException(316, opErr.getMessage());
        }
    }

    public boolean isOperationEnded(OperationKey key) throws ServiceException {
        try {
            return this.opManager.isOperationEnded(key);
        }
        catch (OperationException opErr) {
            throw new ServiceException(316, opErr.getMessage());
        }
    }

    protected void startOperation(AsynchronousOperation operation) {
        this.opManager.startOperation(operation);
    }

    public void operationStateChanged(AsynchronousOperation operation) {
        this.opManager.operationStateChanged(operation);
    }

    protected void logEvent(Object origin, String event, Object msg) {
        this.getServices().logEvent(origin, event, msg);
    }

    public URL getServiceResource(String name) throws IOException {
        return ((WizardServicesImpl)this.getServices()).getServiceResource(name);
    }

    public abstract /* synthetic */ int getSystemCompatibility();
}

