/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.util.Progress;
import com.installshield.wizard.service.MutableOperationState;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.OperationStateListener;

public abstract class AsynchronousOperation
implements Runnable,
Progress,
MutableOperationState {
    private OperationKey key;
    private OperationStateListener opListener;
    private boolean suspended = false;
    private boolean canceled = false;
    private boolean ended = false;
    private String title = "";
    private float percentComplete = 0.0f;
    private String statusDescription = "";
    private String statusDetail = "";
    private boolean redisplayProgress = false;
    private int estimatedTimeToComplete = 0;
    private float timeCompleted = 0.0f;
    private long updateCounter = 0L;
    private String lastMessage = null;
    private boolean canCancelOperation = true;

    public AsynchronousOperation(String name) {
        this(name, null);
    }

    public AsynchronousOperation(String name, OperationStateListener opListener) {
        this.key = new OperationKey(name);
        this.opListener = opListener;
    }

    public OperationKey getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.execute();
        this.ended = true;
        AsynchronousOperation asynchronousOperation = this;
        synchronized (asynchronousOperation) {
            this.notifyAll();
        }
        if (this.opListener != null) {
            this.opListener.operationStateChanged(this);
        }
    }

    public boolean isEnded() {
        return this.ended;
    }

    protected abstract void execute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        this.suspended = true;
        AsynchronousOperation asynchronousOperation = this;
        synchronized (asynchronousOperation) {
            this.notifyAll();
        }
        if (this.opListener != null) {
            this.opListener.operationStateChanged(this);
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.suspended = false;
        AsynchronousOperation asynchronousOperation = this;
        synchronized (asynchronousOperation) {
            this.notifyAll();
        }
        if (this.opListener != null) {
            this.opListener.operationStateChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.suspended = false;
        this.canceled = true;
        AsynchronousOperation asynchronousOperation = this;
        synchronized (asynchronousOperation) {
            this.notifyAll();
        }
        if (this.opListener != null) {
            this.opListener.operationStateChanged(this);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Progress getProgress() {
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setStatusDescription(String description) {
        this.statusDescription = description;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDetail(String detail) {
        this.statusDetail = detail;
    }

    public String getStatusDetail() {
        return this.statusDetail;
    }

    public void updatePercentComplete(int timeToCompleteFactor, long increment, long total) {
        if (this.estimatedTimeToComplete > 0 && total > 0L) {
            this.timeCompleted += (float)timeToCompleteFactor * ((float)increment / (float)total);
            this.percentComplete = 100.0f * (this.timeCompleted / (float)this.estimatedTimeToComplete);
            this.updateCounter += increment;
        }
    }

    public void setPercentComplete(int percent) {
        this.percentComplete = percent;
        this.timeCompleted = this.estimatedTimeToComplete > 0 ? (float)percent / 100.0f * (float)this.estimatedTimeToComplete : 0.0f;
    }

    public int getPercentComplete() {
        return Math.round(this.percentComplete);
    }

    public void setEstimatedTimeToComplete(int tenthsOfSeconds) {
        if (tenthsOfSeconds < 0) {
            throw new IllegalArgumentException("tenthsOfSeconds cannot be negative");
        }
        this.estimatedTimeToComplete = tenthsOfSeconds;
    }

    public int getEstimatedTimeToComplete() {
        return this.estimatedTimeToComplete;
    }

    public void resetUpdateCounter() {
        this.updateCounter = 0L;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void setLastMessage(String message) {
        this.lastMessage = message;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void setRedisplayProgress(boolean redisplayProgress) {
        this.redisplayProgress = redisplayProgress;
    }

    public boolean getRedisplayProgress() {
        return this.redisplayProgress;
    }

    public void setCancelableOperation(boolean cancelable) {
        this.canCancelOperation = cancelable;
    }

    public boolean isCancelableOperation() {
        return this.canCancelOperation;
    }
}

