/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.Log;
import com.installshield.wizard.service.ServiceException;
import com.zerog.interfaces.util.DebugLog;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;

public class DebugLogWrapper
implements Log,
PropertyAccessible {
    private boolean logExceptionStackTraces = true;
    private DebugLog debugLog = null;
    private Hashtable logTypeMap;

    public static String subclassEvent(String superEvent, String subEvent) {
        return superEvent + "." + subEvent;
    }

    public DebugLogWrapper() {
        this.generateDebugLogTypeMap();
    }

    public void setDebugLog(DebugLog debugLog) {
        this.debugLog = debugLog;
    }

    public DebugLog getDebugLog() {
        return this.debugLog;
    }

    public void setLogExceptionStackTraces(boolean b) {
        this.logExceptionStackTraces = b;
    }

    public boolean getLogExceptionStackTraces() {
        return this.logExceptionStackTraces;
    }

    public String getLoggingContext() {
        return this.debugLog.getLoggingContext();
    }

    public void setLoggingContext(String context) {
        this.debugLog.setLoggingContext(context);
    }

    public void logEvent(Object origin, String eventType, Object message) {
        ServiceException se;
        if (message instanceof ServiceException && (se = (ServiceException)message).getData() instanceof Throwable) {
            message = se.getData();
        }
        String formattedMsg = this.formatEvent(origin, eventType, message);
        this.writeToOutput(eventType, formattedMsg);
        if (this.logExceptionStackTraces && message instanceof Throwable) {
            this.writeToOutput(eventType, this.formatStackTrace((Throwable)message));
        }
    }

    public void logStream(Object origin, String eventType, String header, InputStream text) {
        String logHeader = eventType + ": ---- BEGIN \"" + header + "\" output ---- (" + new Date() + ")";
        this.writeToOutput(eventType, logHeader);
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(text));
            String nextLine = null;
            while ((nextLine = in.readLine()) != null) {
                String line = new Date() + ": " + nextLine;
                this.writeToOutput(eventType, line);
            }
        }
        catch (IOException e) {
            this.writeToOutput(eventType, "An error occurred while reading the stream: " + e);
        }
        String footer = eventType + ": ---- END \"" + header + "\" output ---- (" + new Date() + ")";
        this.writeToOutput(eventType, footer);
    }

    private void generateDebugLogTypeMap() {
        this.logTypeMap = new Hashtable();
        this.logTypeMap.put("err.internal", new Integer(0));
        this.logTypeMap.put("err", new Integer(0));
        this.logTypeMap.put("wrn", new Integer(1));
        this.logTypeMap.put("msg1", new Integer(2));
        this.logTypeMap.put("msg2", new Integer(2));
        this.logTypeMap.put("dbg", new Integer(3));
    }

    private void writeToOutput(String eventType, String message) {
        if (this.debugLog != null) {
            int logType = this.obtainDebugLogType(eventType);
            switch (logType) {
                case 0: {
                    this.debugLog.error(message);
                    break;
                }
                case 1: {
                    this.debugLog.info(message);
                    break;
                }
                case 2: {
                    this.debugLog.trace(message);
                    break;
                }
                default: {
                    this.debugLog.debug(message);
                }
            }
        }
    }

    private String formatStackTrace(Throwable e) {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(bytesOut);
        e.printStackTrace(out);
        out.flush();
        String trace = new String(bytesOut.toByteArray());
        int lineCount = 1;
        int traceLength = trace.length() - 1;
        for (int currentPosition = 0; currentPosition < traceLength && (currentPosition = trace.indexOf("\n", currentPosition)) != -1; ++currentPosition) {
            ++lineCount;
        }
        bytesOut = new ByteArrayOutputStream();
        out = new PrintWriter(bytesOut);
        out.println("STACK_TRACE: " + new Integer(lineCount).toString());
        out.print(trace);
        out.flush();
        return new String(bytesOut.toByteArray());
    }

    private String formatEvent(Object origin, String eventType, Object message) {
        String formattedEvent = "";
        formattedEvent = origin != null ? "(" + DateFormat.getDateTimeInstance().format(new Date()) + ")" + ", " + this.getLoggingContext() + ", " + origin.getClass().getName() + ", " + eventType + ", " + message : "(" + DateFormat.getDateTimeInstance().format(new Date()) + ")" + ", " + this.getLoggingContext() + ", null" + ", " + eventType + ", " + message;
        return formattedEvent;
    }

    private int obtainDebugLogType(String eventType) {
        Integer logType = (Integer)this.logTypeMap.get("dbg");
        String curType = eventType;
        while (curType != null) {
            int pos;
            if (this.logTypeMap.containsKey(curType)) {
                logType = (Integer)this.logTypeMap.get(curType);
            }
            curType = (pos = curType.lastIndexOf(46)) != -1 ? curType.substring(0, pos) : null;
        }
        return logType;
    }
}

