/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.util.GenericProgress;
import com.installshield.util.Progress;
import com.installshield.wizard.service.AsynchronousOperation;
import com.installshield.wizard.service.OperationException;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.OperationManager;
import com.installshield.wizard.service.OperationStateListener;
import java.util.Hashtable;

public class GenericOperationManager
implements OperationManager,
OperationStateListener {
    private Hashtable operations = new Hashtable();
    private Hashtable finishedOperations = new Hashtable();

    public Progress getOperationProgress(OperationKey key) throws OperationException {
        return new GenericProgress(this.getOperation(key).getProgress());
    }

    public void suspendOperation(OperationKey key) throws OperationException {
        this.getOperation(key).suspend();
    }

    public boolean isOperationSuspended(OperationKey key) throws OperationException {
        return this.getOperation(key).isSuspended();
    }

    public void cancelOperation(OperationKey key) throws OperationException {
        this.getOperation(key).cancel();
    }

    public boolean isOperationCanceled(OperationKey key) throws OperationException {
        return this.getOperation(key).isCanceled();
    }

    public void resumeOperation(OperationKey key) throws OperationException {
        this.getOperation(key).resume();
    }

    protected AsynchronousOperation getOperation(OperationKey key) throws OperationException {
        AsynchronousOperation op = (AsynchronousOperation)this.operations.get(key);
        if (op == null) {
            op = (AsynchronousOperation)this.finishedOperations.get(key);
        }
        if (op == null) {
            throw new OperationException(key.getName());
        }
        return op;
    }

    public boolean isOperationEnded(OperationKey key) throws OperationException {
        return this.finishedOperations.containsKey(key);
    }

    public OperationKey startOperation(AsynchronousOperation operation) {
        Thread th = new Thread(operation);
        OperationKey key = operation.getKey();
        this.operations.put(key, operation);
        th.start();
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationStateChanged(AsynchronousOperation operation) {
        OperationKey key = operation.getKey();
        if (operation.isEnded()) {
            this.finishedOperations.put(key, operation);
            this.operations.remove(key);
        }
        OperationKey operationKey = key;
        synchronized (operationKey) {
            key.notifyAll();
        }
    }
}

