/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.wizard.service.ImplementorProxy;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceImplementor;
import com.installshield.wizard.service.ServiceUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class LocalImplementorProxy
implements ImplementorProxy {
    private Class implementorType;
    private ServiceImplementor impl;

    LocalImplementorProxy(Class implementorType, ServiceImplementor impl) {
        this.implementorType = implementorType;
        this.impl = impl;
        if (!implementorType.isInterface()) {
            throw new IllegalArgumentException("implementorType " + implementorType + " is not an interface");
        }
        if (!implementorType.isInstance(impl)) {
            throw new IllegalArgumentException("impl " + impl.getClass() + " does not implement " + implementorType);
        }
    }

    public String getImplementorType() {
        if (this.impl == null) {
            throw new IllegalStateException("proxy has been closed");
        }
        return this.impl.getClass().getName();
    }

    public void close() throws ServiceException {
        if (this.impl != null) {
            this.impl.cleanup();
            this.impl = null;
        }
    }

    public Object invoke(String methodName, Class[] argTypes, Object[] args) throws ServiceException {
        Method method;
        if (this.impl == null) {
            throw new IllegalStateException("proxy has been closed");
        }
        try {
            method = this.implementorType.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException(311, this.getImplementorType() + "." + ServiceUtils.methodSignature(methodName, argTypes));
        }
        try {
            return method.invoke((Object)this.impl, args);
        }
        catch (IllegalAccessException e) {
            throw new Error();
        }
        catch (InvocationTargetException e) {
            if (System.getProperty("is.debug.proxy") != null) {
                System.out.println("Exception in LocalImplementorProxy: " + e);
                e.printStackTrace(System.out);
                System.out.println("Exception from service: " + e.getTargetException());
                e.getTargetException().printStackTrace(System.out);
            }
            if (e.getTargetException() instanceof ServiceException) {
                throw (ServiceException)e.getTargetException();
            }
            throw new ServiceException(e.getTargetException());
        }
    }
}

