/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.wizard.service.AbstractWizardServices;
import com.installshield.wizard.service.LocalWizardServicesManager;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceDef;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceFactory;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.WizardServices;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LocalWizardServices
extends AbstractWizardServices {
    private LocalWizardServicesManager servicesManager;
    private boolean ownsManager = true;
    private Hashtable services = new Hashtable();

    public LocalWizardServices(String id2, String servicesHome, ServicesDefinition servicesDef) {
        super(id2, servicesHome, null, servicesDef);
        this.servicesManager = new LocalWizardServicesManager(servicesHome, this);
    }

    public void setLocalWizardServicesManager(LocalWizardServicesManager manager) {
        this.servicesManager = manager;
        this.ownsManager = false;
    }

    public void setWizardServices(String servicesHome, WizardServices services) throws ServiceException {
        this.servicesManager.setWizardServices(servicesHome, services);
    }

    public WizardServices getWizardServices(String servicesHome) throws ServiceException {
        return this.servicesManager.getWizardServices(servicesHome);
    }

    private Object loadService(String serviceName) {
        if (this.getServicesDefinition() == null) {
            return null;
        }
        try {
            Service service = ServiceFactory.createService(serviceName, this.getServicesDefinition(), this);
            this.services.put(serviceName, service);
            return service;
        }
        catch (ServiceException e) {
            return new Throwable("Could not load service:  " + serviceName);
        }
    }

    public Service getService(String serviceName) throws ServiceException {
        Object service = this.services.get(serviceName);
        if (service == null) {
            service = this.loadService(serviceName);
        }
        if (service instanceof Throwable) {
            throw new ServiceException(301, ((Throwable)service).getMessage());
        }
        return (Service)service;
    }

    public boolean isServiceAvailable(String serviceName) throws ServiceException {
        Object service = this.services.get(serviceName);
        if (service == null) {
            service = this.loadService(serviceName);
        }
        return service instanceof Service;
    }

    public void setService(String serviceName, Service service) {
        this.services.put(serviceName, service);
    }

    public Enumeration services() {
        Vector<String> serviceNames = new Vector<String>();
        Enumeration enumer = this.getServicesDefinition().services();
        while (enumer.hasMoreElements()) {
            serviceNames.addElement(((ServiceDef)enumer.nextElement()).getName());
        }
        return serviceNames.elements();
    }

    public void shutdown() {
        if (this.ownsManager) {
            this.servicesManager.shutdown();
        }
        Enumeration e = this.services.keys();
        while (e.hasMoreElements()) {
            Service service = (Service)this.services.get(e.nextElement());
            try {
                ServiceFactory.shutdownService(service);
            }
            catch (ServiceException ex) {
                System.err.println("ERROR shutting down " + service.getName() + ": " + ex);
            }
        }
        super.shutdown();
    }
}

