/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.boot.CoreFileUtils;
import com.installshield.wizard.service.LocalWizardServices;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceManagerImpl;
import com.installshield.wizard.service.ServiceManagerLoader;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesFactory;
import com.installshield.wizard.service.WizardServicesImpl;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class LocalWizardServicesManager {
    private Hashtable wizardServices = new Hashtable();
    private String home;
    private WizardServices parentServices;

    public static WizardServicesImpl loadWizardServices(String home) throws ServiceException {
        try {
            if (!new File(home).exists()) {
                throw new ServiceException(315, "Wizard home does not exist: " + home);
            }
            ServiceManagerImpl manager = (ServiceManagerImpl)ServiceManagerLoader.loadServiceManager(home);
            if (manager.getServicesInf().getResId() == null) {
                throw new ServiceException(320);
            }
            WizardServicesImpl services = null;
            services = WizardServicesFactory.createLocalWizardServices(manager.getServicesInf().getResId(), home, manager.getServicesDefinition(), manager.getDebugLog());
            return services;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public LocalWizardServicesManager(String home, WizardServices parentServices) {
        this.home = home;
        this.parentServices = parentServices;
    }

    public String getHome() {
        return this.home;
    }

    public void setWizardServices(String servicesHome, WizardServices services) throws ServiceException {
        servicesHome = this.normalizeServicesHome(servicesHome);
        if (services != null) {
            this.wizardServices.put(servicesHome, services);
        } else {
            this.wizardServices.remove(servicesHome);
        }
    }

    public WizardServices getWizardServices(String servicesHome) throws ServiceException {
        WizardServices services;
        if (CoreFileUtils.comparePaths(servicesHome, this.home)) {
            services = this.parentServices;
        } else {
            String baseHome = CoreFileUtils.getParent(this.getHome());
            String home = this.normalizeServicesHome(CoreFileUtils.createFileName(baseHome, servicesHome));
            services = (WizardServices)this.wizardServices.get(home);
            if (services == null) {
                try {
                    services = LocalWizardServicesManager.loadWizardServices(home);
                    if (services instanceof LocalWizardServices) {
                        ((LocalWizardServices)services).setLocalWizardServicesManager(this);
                    }
                    this.wizardServices.put(home, services);
                }
                catch (Exception e) {
                    if (System.getProperty("is.debug") != null) {
                        e.printStackTrace();
                    }
                    throw new ServiceException(e);
                }
            }
        }
        return services;
    }

    public void shutdown() {
        Enumeration otherServices = this.wizardServices.elements();
        while (otherServices.hasMoreElements()) {
            ((WizardServicesImpl)otherServices.nextElement()).shutdown();
        }
    }

    private String normalizeServicesHome(String servicesHome) {
        return CoreFileUtils.canonizePath(servicesHome);
    }
}

