/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.wizard.service.AbstractService;
import com.installshield.wizard.service.ImplementorProxy;
import com.installshield.wizard.service.LocalImplementorProxy;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceDef;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceImplementor;
import com.installshield.wizard.service.ServiceImplementorDef;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.WizardServices;

public class ServiceFactory {
    public static Service createService(String serviceName, ServicesDefinition servicesDef, WizardServices services) throws ServiceException {
        return ServiceFactory.createService(serviceName, servicesDef, null, services);
    }

    public static void shutdownService(Service service) throws ServiceException {
        ImplementorProxy proxy;
        if (service instanceof AbstractService && (proxy = ((AbstractService)service).getImplementorProxy()) != null) {
            proxy.close();
        }
    }

    public static Service createService(String serviceName, ServicesDefinition servicesDef, ImplementorProxy proxy, WizardServices services) throws ServiceException {
        Service service = ServiceFactory.createDefaultServiceImpl(serviceName, servicesDef);
        if (service instanceof AbstractService) {
            if (proxy == null) {
                Class implType = service.getServiceImplementorType();
                ServiceImplementor impl = ServiceFactory.createImpl(serviceName, implType, servicesDef, services);
                proxy = new LocalImplementorProxy(implType, impl);
            }
            ((AbstractService)service).setImplementorProxy(proxy);
        }
        return service;
    }

    public static Service createService(String serviceName, ServicesDefinition servicesDef, String[] targetHosts) throws ServiceException {
        throw new RuntimeException("not implemented");
    }

    private static Service createDefaultServiceImpl(String serviceName, ServicesDefinition servicesDef) throws ServiceException {
        Service service = null;
        for (int i = 0; service == null && i < servicesDef.getServiceCount(); ++i) {
            ServiceDef def = servicesDef.getService(i);
            if (!def.getName().equals(serviceName)) continue;
            try {
                Class<?> interfase = Class.forName(def.getInterface());
                Class<?> defaultImpl = Class.forName(def.getDefaultImpl());
                if (!interfase.isAssignableFrom(defaultImpl)) {
                    throw new ServiceException(304, defaultImpl.getName() + " does not extend " + interfase.getName());
                }
                service = (Service)defaultImpl.newInstance();
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException(309, e.getClass().toString());
            }
            catch (Throwable e) {
                throw new ServiceException(310, "could not instantiate " + e.getMessage());
            }
        }
        if (service == null) {
            throw new ServiceException(306, serviceName);
        }
        return service;
    }

    private static ServiceImplementor createImpl(String name, Class implType, ServicesDefinition servicesDef, WizardServices services) throws ServiceException {
        for (int i = 0; i < servicesDef.getImplementorCount(); ++i) {
            ServiceImplementorDef def = servicesDef.getImplementor(i);
            if (!def.getName().equals(name)) continue;
            if (!def.getInterface().equals(implType.getName())) {
                throw new ServiceException(318, "implementor " + def.getName() + " is required by service to be " + implType);
            }
            ServiceImplementor impl = ServiceFactory.createBestFitImpl(def);
            try {
                if (impl != null) {
                    impl.initialize(def.getProperties(), services);
                }
                return impl;
            }
            catch (Throwable th) {
                ServiceImplementor defaultImpl;
                System.err.println("WARNING: could not initialize impl " + impl.getClass());
                if (System.getProperty("is.debug") != null) {
                    th.printStackTrace();
                }
                if ((defaultImpl = ServiceFactory.createDefaultImpl(def)) == null || defaultImpl.getClass() == impl.getClass()) continue;
                try {
                    defaultImpl.initialize(def.getProperties(), services);
                    return defaultImpl;
                }
                catch (Throwable th2) {
                    System.err.println("WARNING: could not initialize default impl " + defaultImpl.getClass());
                    if (System.getProperty("is.debug") == null) continue;
                    th2.printStackTrace();
                }
            }
        }
        throw new ServiceException(312, implType.getName());
    }

    private static ServiceImplementor createBestFitImpl(ServiceImplementorDef def) throws ServiceException {
        int maxCompatibility = 0;
        ServiceImplementor best = null;
        for (int i = 0; i < def.getImplCount(); ++i) {
            String className = def.getImpl(i);
            try {
                ServiceImplementor impl = (ServiceImplementor)Class.forName(className).newInstance();
                if (impl.getSystemCompatibility() <= maxCompatibility) continue;
                best = impl;
                maxCompatibility = best.getSystemCompatibility();
                continue;
            }
            catch (Throwable e) {
                System.out.println("could not load service implementor " + className + " due to the following exception: " + e);
                if (System.getProperty("is.debug") == null) continue;
                e.printStackTrace();
            }
        }
        if (best == null) {
            best = ServiceFactory.createDefaultImpl(def);
        }
        if (best == null) {
            throw new ServiceException(313, def.getInterface());
        }
        return best;
    }

    private static ServiceImplementor createDefaultImpl(ServiceImplementorDef def) {
        try {
            return (ServiceImplementor)Class.forName(def.getDefaultImpl()).newInstance();
        }
        catch (Throwable e) {
            System.out.println("could not load default service implementor " + def.getDefaultImpl() + " due to the following exception: " + e);
            if (System.getProperty("is.debug") != null) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static String getCurrentImplementorType(Service service) {
        if (service instanceof AbstractService) {
            ImplementorProxy proxy = ((AbstractService)service).getImplementorProxy();
            return proxy != null ? proxy.getImplementorType() : null;
        }
        return null;
    }
}

