/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.boot.CoreFileUtils;
import com.installshield.boot.CoreURLUtils;
import com.installshield.boot.CoreZipUtils;
import com.installshield.qjml.QJML;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceManagerImpl;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.ServicesInf;
import com.zerog.interfaces.service.ServiceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ServiceManagerLoader {
    static /* synthetic */ Class class$com$installshield$wizard$service$ServicesDefinition;
    static /* synthetic */ Class class$com$installshield$wizard$service$ServiceManagerLoader;
    static /* synthetic */ Class class$com$installshield$wizard$service$ServiceManagerImpl;

    public static ServiceManager loadServiceManager(String servicesHome) throws ServiceException {
        ServicesDefinition services;
        ServiceManagerImpl manager;
        ServicesInf inf;
        block7: {
            try {
                inf = ServiceManagerLoader.loadServicesInf(servicesHome);
            }
            catch (Exception e) {
                if (System.getProperty("is.debug") != null) {
                    e.printStackTrace();
                }
                throw new ServiceException(102, "services inf could not be loaded: " + e.getMessage());
            }
            QJML.setParserClass("com.sun.xml.parser.Parser");
            manager = new ServiceManagerImpl();
            ServiceManagerLoader.initializeWizardHome(manager, servicesHome);
            services = null;
            URL servicesRes = ServiceManagerLoader.getResource("/" + inf.getResId() + inf.getServices(), servicesHome);
            if (servicesRes != null) {
                try {
                    if (!inf.getServicesDigest().equals(QJML.createDigest(servicesRes, class$com$installshield$wizard$service$ServicesDefinition == null ? (class$com$installshield$wizard$service$ServicesDefinition = ServiceManagerLoader.class$("com.installshield.wizard.service.ServicesDefinition")) : class$com$installshield$wizard$service$ServicesDefinition, (class$com$installshield$wizard$service$ServicesDefinition == null ? (class$com$installshield$wizard$service$ServicesDefinition = ServiceManagerLoader.class$("com.installshield.wizard.service.ServicesDefinition")) : class$com$installshield$wizard$service$ServicesDefinition).getName().getBytes()))) {
                        throw new ServiceException(103, "services file has changed since it was created");
                    }
                    services = (ServicesDefinition)QJML.read(servicesRes, class$com$installshield$wizard$service$ServicesDefinition == null ? (class$com$installshield$wizard$service$ServicesDefinition = ServiceManagerLoader.class$("com.installshield.wizard.service.ServicesDefinition")) : class$com$installshield$wizard$service$ServicesDefinition);
                }
                catch (IOException e) {
                    System.err.println(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "WizardLoader.couldNotLoadService", new String[]{"/services.inf"}));
                    if (System.getProperty("is.debug") == null) break block7;
                    e.printStackTrace();
                }
            }
        }
        manager.setServicesInf(inf);
        manager.setServicesDefinition(services);
        return manager;
    }

    public static ServicesInf loadServicesInf(String home) throws IOException {
        File infFile;
        ServicesInf inf = null;
        File f = new File(home);
        if (f.isFile()) {
            ZipFile zip = new ZipFile(f);
            ZipEntry entry = zip.getEntry(CoreZipUtils.cleanZipEntry("/services.inf"));
            if (entry != null) {
                inf = new ServicesInf(CoreZipUtils.createZipInputStream(zip.getInputStream(entry)), (class$com$installshield$wizard$service$ServiceManagerLoader == null ? (class$com$installshield$wizard$service$ServiceManagerLoader = ServiceManagerLoader.class$("com.installshield.wizard.service.ServiceManagerLoader")) : class$com$installshield$wizard$service$ServiceManagerLoader).getName().getBytes());
            }
            zip.close();
        } else if (f.isDirectory() && (infFile = new File(home, "/services.inf")).isFile()) {
            FileInputStream in = new FileInputStream(infFile);
            inf = new ServicesInf(in, (class$com$installshield$wizard$service$ServiceManagerLoader == null ? (class$com$installshield$wizard$service$ServiceManagerLoader = ServiceManagerLoader.class$("com.installshield.wizard.service.ServiceManagerLoader")) : class$com$installshield$wizard$service$ServiceManagerLoader).getName().getBytes());
            in.close();
        }
        if (inf == null) {
            throw new FileNotFoundException("cannot find /services.inf in " + home);
        }
        return inf;
    }

    private static void initializeWizardHome(ServiceManagerImpl wizard, String home) {
        home = new File(CoreFileUtils.normalizeFileName(home)).getAbsolutePath();
        wizard.setHome(home);
    }

    protected static URL getResource(String name, String home) {
        URL resourceURL = null;
        if (name != null) {
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            try {
                resourceURL = new URL("archive", "", -1, CoreURLUtils.encodeArchiveURLPath(home + "+" + name));
                InputStream in = resourceURL.openStream();
                in.close();
            }
            catch (IOException ioErr) {
                resourceURL = null;
            }
        }
        if (resourceURL == null) {
            resourceURL = (class$com$installshield$wizard$service$ServiceManagerImpl == null ? (class$com$installshield$wizard$service$ServiceManagerImpl = ServiceManagerLoader.class$("com.installshield.wizard.service.ServiceManagerImpl")) : class$com$installshield$wizard$service$ServiceManagerImpl).getResource(name);
        }
        return resourceURL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

