/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.util.CommandLineTokenizer;
import com.installshield.wizard.service.ServiceDef;
import com.installshield.wizard.service.ServiceImplementorDef;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ServicesDefinition {
    private Vector services = new Vector();
    private Vector implementors = new Vector();
    private Vector stringResolverMethods = new Vector();
    private Vector resourceLocations = new Vector();

    public ServicesDefinition() {
    }

    public ServicesDefinition(ServicesDefinition servicesDef) {
        Enumeration enumer = servicesDef.services.elements();
        while (enumer.hasMoreElements()) {
            this.services.addElement(enumer.nextElement());
        }
        enumer = servicesDef.implementors.elements();
        while (enumer.hasMoreElements()) {
            this.implementors.addElement(enumer.nextElement());
        }
        enumer = servicesDef.stringResolverMethods.elements();
        while (enumer.hasMoreElements()) {
            this.stringResolverMethods.addElement(enumer.nextElement());
        }
        enumer = servicesDef.resourceLocations.elements();
        while (enumer.hasMoreElements()) {
            this.resourceLocations.addElement(enumer.nextElement());
        }
    }

    public void addService(ServiceDef def) {
        this.services.addElement(def);
    }

    public void removeService(ServiceDef def) {
        this.services.removeElement(def);
    }

    public int getServiceCount() {
        return this.services.size();
    }

    public ServiceDef getService(int index) {
        return (ServiceDef)this.services.elementAt(index);
    }

    public void removeAllServices() {
        this.services.removeAllElements();
    }

    public Enumeration services() {
        return this.services.elements();
    }

    public void addImplementor(ServiceImplementorDef def) {
        this.implementors.addElement(def);
    }

    public void removeImplementor(ServiceImplementorDef def) {
        this.implementors.removeElement(def);
    }

    public int getImplementorCount() {
        return this.implementors.size();
    }

    public ServiceImplementorDef getImplementor(int index) {
        return (ServiceImplementorDef)this.implementors.elementAt(index);
    }

    public void removeAllImplementors() {
        this.implementors.removeAllElements();
    }

    public Enumeration implementors() {
        return this.implementors.elements();
    }

    public void setResourcePath(String resourcePath) {
        CommandLineTokenizer locations = new CommandLineTokenizer(resourcePath);
        while (locations.hasMoreElements()) {
            this.putResourceLocation((String)locations.nextElement());
        }
    }

    public String getResourcePath() {
        String[] locations = new String[this.resourceLocations.size()];
        for (int i = 0; i < this.resourceLocations.size(); ++i) {
            locations[i] = (String)this.resourceLocations.elementAt(i);
        }
        return CommandLineTokenizer.createSpaceDelimitedString(locations);
    }

    public void prependResourceLocation(String resourceLocation) {
        if (this.resourceLocations.contains(resourceLocation)) {
            this.resourceLocations.removeElement(resourceLocation);
        }
        this.resourceLocations.add(0, resourceLocation);
    }

    public void putResourceLocation(String resourceLocation) {
        if (!this.resourceLocations.contains(resourceLocation)) {
            this.resourceLocations.addElement(resourceLocation);
        }
    }

    public void removeResourceLocation(String resourceLocation) {
        this.resourceLocations.removeElement(resourceLocation);
    }

    public void removeAllResourceLocations() {
        this.resourceLocations.removeAllElements();
    }

    public void mergeServicesDefinition(ServicesDefinition newServicesDef) {
        String defName;
        ServiceImplementorDef svcImplDef;
        int i;
        String defName2;
        ServiceDef svcDef;
        int i2;
        Hashtable<String, String> svcDefs = new Hashtable<String, String>();
        for (i2 = 0; i2 < this.getServiceCount(); ++i2) {
            svcDef = this.getService(i2);
            defName2 = svcDef.getName();
            svcDefs.put(defName2, "");
        }
        for (i2 = 0; i2 < newServicesDef.getServiceCount(); ++i2) {
            svcDef = newServicesDef.getService(i2);
            defName2 = svcDef.getName();
            if (svcDefs.containsKey(defName2)) continue;
            this.addService(svcDef);
            svcDefs.put(defName2, "");
        }
        Hashtable<String, ServiceImplementorDef> svcImplDefs = new Hashtable<String, ServiceImplementorDef>();
        for (i = 0; i < this.getImplementorCount(); ++i) {
            svcImplDef = this.getImplementor(i);
            defName = svcImplDef.getName();
            svcImplDefs.put(defName, svcImplDef);
        }
        for (i = 0; i < newServicesDef.getImplementorCount(); ++i) {
            svcImplDef = newServicesDef.getImplementor(i);
            defName = svcImplDef.getName();
            if (svcImplDefs.containsKey(defName)) {
                ServiceImplementorDef originalDef = (ServiceImplementorDef)svcImplDefs.get(defName);
                originalDef.mergeServiceImplementorDef(svcImplDef);
                continue;
            }
            this.addImplementor(svcImplDef);
            svcImplDefs.put(defName, svcImplDef);
        }
        for (i = 0; i < newServicesDef.resourceLocations.size(); ++i) {
            this.putResourceLocation((String)newServicesDef.resourceLocations.elementAt(i));
        }
    }
}

