/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.util.SecureMetaInf;
import com.installshield.wizard.service.SecureServicesHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Dictionary;

public class ServicesInf
extends SecureMetaInf
implements SecureServicesHandler {
    public static final String RESOURCE_NAME = "/services.inf";
    public static final String RES_ID = "RES_ID";
    public static final String SERVICES = "SERVICES";
    public static final String SERVICES_DIGEST = "S_DG";
    public static final String DEFAULT_SERVICES_NAME = "/services.xml";
    public static final String DEFAULT_SERVICES_DIGEST = "invalid";
    private String resId;
    private String services;
    private String servicesDigest;

    public ServicesInf(byte[] key, String resId, String services, String servicesDigest) {
        super(key);
        this.resId = resId;
        this.services = services;
        this.servicesDigest = servicesDigest;
    }

    public ServicesInf(byte[] key) {
        super(key);
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.resId = "";
        this.services = DEFAULT_SERVICES_NAME;
        this.servicesDigest = DEFAULT_SERVICES_DIGEST;
    }

    public ServicesInf(URL source, byte[] key) throws IOException {
        super(source, key);
    }

    public ServicesInf(InputStream in, byte[] key) throws IOException {
        super(in, key);
    }

    protected void readObject(Dictionary data) throws IOException {
        this.initializeDefaults();
        if (data.get(RES_ID) != null) {
            this.resId = (String)data.get(RES_ID);
        }
        if (data.get(SERVICES) != null) {
            this.services = (String)data.get(SERVICES);
        }
        if (data.get(SERVICES_DIGEST) != null) {
            this.servicesDigest = (String)data.get(SERVICES_DIGEST);
        }
    }

    public String getFileName() {
        return "WIZARD.INF";
    }

    protected void writeObject(PrintWriter writer) throws IOException {
        writer.println("RES_ID: " + this.resId);
        writer.println("SERVICES: " + this.services);
        writer.println("S_DG: " + this.servicesDigest);
    }

    protected void writeObjectDigest(PrintWriter writer) throws IOException {
        writer.write("RES_ID: " + this.resId);
        writer.write("SERVICES: " + this.services);
        writer.write("S_DG: " + this.servicesDigest);
    }

    public void setResId(String resId) {
        this.resId = resId;
    }

    public String getResId() {
        return this.resId;
    }

    public void setServices(String services) {
        this.services = services;
    }

    public String getServices() {
        return this.services;
    }

    public void setServicesDigest(String servicesDigest) {
        this.servicesDigest = servicesDigest;
    }

    public String getServicesDigest() {
        return this.servicesDigest;
    }
}

