/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service.file;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.FileAttributes;
import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileServiceImplementor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;

public class PureJavaFileServiceImpl
extends AbstractServiceImplementor
implements FileServiceImplementor {
    private boolean copyWithAttributes = true;

    public int getSystemCompatibility() {
        return 1;
    }

    public int deleteFile(String fileName) throws ServiceException {
        if (new File(fileName).delete()) {
            return 0;
        }
        throw new ServiceException(315, "could not delete file " + fileName);
    }

    public int deleteDirectory(String directory) throws ServiceException {
        return this.deleteDirectory(directory, true, false);
    }

    public int deleteDirectory(String directory, boolean ifEmpty, boolean includeSubDirs) throws ServiceException {
        String dirName = this.createFileName(this.getCurrentDirectory(), directory);
        if (this.fileExists(dirName) && this.isDirectory(dirName) && this.getParent(dirName) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(dirName)) {
            String[] list = this.getDirectoryList(dirName, 2);
            if (list == null) {
                throw new ServiceException(315, "directory " + dirName + " contents could not be read");
            }
            if (ifEmpty && list.length > 0) {
                throw new ServiceException(315, "directory " + dirName + " is not empty");
            }
            for (int i = 0; i < list.length; ++i) {
                String fileName = this.createFileName(dirName, list[i]);
                if (this.isFile(fileName)) {
                    this.deleteFile(fileName);
                    continue;
                }
                if (!this.isDirectory(fileName) || !includeSubDirs) continue;
                this.deleteDirectory(fileName, ifEmpty, includeSubDirs);
            }
            if (!this.deleteDirectoryImpl(dirName)) {
                throw new ServiceException(315, "could not delete directory " + dirName);
            }
        }
        return 0;
    }

    protected boolean deleteDirectoryImpl(String directoryName) throws ServiceException {
        return new File(directoryName).delete();
    }

    public void createDirectory(String directoryName) throws ServiceException {
        this.createDirectoryReturnNew(directoryName);
    }

    public String[] createDirectoryReturnNew(String directoryName) throws ServiceException {
        String newDirName = this.removeTrailingSlash(this.createFileName(this.getCurrentDirectory(), directoryName));
        Stack<String> parents = new Stack<String>();
        String parent = newDirName;
        while (parent != null && !this.fileExists(newDirName)) {
            parents.push(parent);
            String parentName = this.getParent(parent);
            parent = parentName != null ? parentName : null;
        }
        Vector<String> created = new Vector<String>();
        while (!parents.isEmpty()) {
            parent = (String)parents.pop();
            if (this.fileExists(parent)) continue;
            File newDirectory = new File(parent);
            if (!newDirectory.mkdir()) {
                throw new ServiceException(315, "could not create directory " + parent);
            }
            created.addElement(parent);
        }
        Object[] ret = new String[created.size()];
        created.copyInto(ret);
        return ret;
    }

    public void setFileTimes(String fileName, long creationDate, long accessDate, long writeDate) throws ServiceException {
        throw new ServiceException(305, "setFileTimes requires native support. ");
    }

    public void setFileCreated(String fileName, long date) throws ServiceException {
        throw new ServiceException(305, "setFileCreated requires native support. ");
    }

    public void setFileModified(String fileName, long date) throws ServiceException {
        throw new ServiceException(305, "setFileModified requires native support. ");
    }

    public boolean fileExists(String fileName) throws ServiceException {
        return new File(fileName).exists();
    }

    public String formatSizeAsBytes(long bytes) throws ServiceException {
        double sizeDouble = bytes;
        double MB = 1048576.0;
        double base = 0.0;
        String unitString = null;
        if ((double)bytes > MB) {
            base = sizeDouble / MB;
            unitString = "MB";
        } else {
            base = sizeDouble / 1024.0;
            if (base < 1.0 && base > 0.0) {
                base = 1.0;
            }
            unitString = "KB";
        }
        String baseString = Double.toString(base);
        int index = baseString.indexOf(".");
        if (index >= 0) {
            int max = baseString.length();
            int extend = 0;
            if (unitString.equals("MB")) {
                extend = 2;
            }
            if (max > index + extend) {
                max = index + extend;
            }
            baseString = baseString.substring(0, max);
        }
        return baseString + unitString;
    }

    public int copyFile(String sourceFileName, String destinationFileName, boolean overwrite) throws ServiceException {
        FileInputStream fileIn = null;
        FileOutputStream fileOut = null;
        if (sourceFileName.equals(destinationFileName)) {
            throw new ServiceException(399, "source and destination cannot be the same");
        }
        try {
            if (!overwrite && new File(destinationFileName).exists()) {
                throw new IOException(destinationFileName + " exists");
            }
            fileIn = new FileInputStream(sourceFileName);
            fileOut = new FileOutputStream(destinationFileName);
            byte[] buffer = new byte[1024];
            int bytesRead = fileIn.read(buffer);
            while (bytesRead != -1) {
                fileOut.write(buffer, 0, bytesRead);
                bytesRead = fileIn.read(buffer);
            }
            this.copyAttributes(sourceFileName, destinationFileName);
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException ioe) {
                    throw new ServiceException(ioe);
                }
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException ioe) {
                    throw new ServiceException(ioe);
                }
            }
        }
        return 0;
    }

    private void copyAttributes(String sourceFileName, String destinationFileName) throws ServiceException {
        if (this.copyWithAttributes) {
            try {
                this.setFileAttributes(destinationFileName, this.getFileAttributes(sourceFileName));
            }
            catch (ServiceException e) {
                this.copyWithAttributes = false;
                if (e.getErrorCode() != 305) {
                    throw e;
                }
                this.logEvent(this, "wrn", "Unable to duplicate file attributes when copying file(s): " + e.toString());
            }
        }
    }

    public int moveFile(String sourceFileName, String destFileName, boolean overwrite) throws ServiceException {
        int result = 0;
        File destFile = new File(destFileName);
        if (overwrite && destFile.exists() && !destFile.delete()) {
            throw new ServiceException(315, "could not move file from " + sourceFileName + " to " + destFileName + " because " + destFileName + " could not be deleted");
        }
        if (!new File(sourceFileName).renameTo(destFile)) {
            try {
                int copyResult = this.copyFile(sourceFileName, destFileName, overwrite);
                int delResult = this.deleteFile(sourceFileName);
                if (copyResult == 1 || delResult == 1) {
                    result = 1;
                }
            }
            catch (ServiceException ex) {
                throw new ServiceException(315, "could not move file from " + sourceFileName + " to " + destFileName + ": " + ex.getMessage());
            }
        }
        return result;
    }

    public String getNamedDirectory(String directoryName) throws ServiceException {
        String result = "";
        if (directoryName.equals("home")) {
            result = this.getHomeDirectory();
        } else if (directoryName.equals("install")) {
            result = this.getStandardInstallDirectory();
        } else if (directoryName.equals("lib")) {
            result = this.getLibraryDirectory();
        } else if (directoryName.equals("log")) {
            result = this.getLogFileDirectory();
        } else if (directoryName.equals("temp")) {
            result = this.getTempDirectory();
        } else if (directoryName.equals("timestamp")) {
            result = this.createTimeStamp();
        } else {
            throw new ServiceException(399, "unknown named directory (" + directoryName + ")");
        }
        if (this.getParent(result) != null && (result.endsWith("/") || result.endsWith("\\") || result.endsWith(File.separator))) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }

    private String createTimeStamp() {
        return "" + new Date().getTime();
    }

    protected String getLibraryDirectory() throws ServiceException {
        throw new ServiceException(305, "getLibraryDirectory requires native support. ");
    }

    protected String getLogFileDirectory() {
        return System.getProperty("user.home");
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        throw new ServiceException(305, "getStandardInstallDirectory requires native support. ");
    }

    protected String getCurrentDirectory() {
        return System.getProperty("user.dir");
    }

    protected String getTempDirectory() throws ServiceException {
        throw new ServiceException(305, "getTempDirectory requires native support. ");
    }

    protected String getHomeDirectory() {
        String userDir = System.getProperty("user.home");
        if (userDir == null) {
            userDir = new File(".").getAbsolutePath();
        }
        return userDir;
    }

    public String[] getDirectoryList(String dir, int type) throws ServiceException {
        String dirName = this.createFileName(this.getCurrentDirectory(), dir);
        Vector<String> entries = new Vector<String>();
        if (this.fileExists(dirName) && this.canRead(dirName) && this.isDirectory(dirName)) {
            File dirFile = new File(dir);
            String[] possibleEntries = dirFile.list();
            for (int index = 0; index < possibleEntries.length; ++index) {
                if (!this.acceptDirectoryListEntry(dirName, possibleEntries[index], type)) continue;
                entries.addElement(possibleEntries[index]);
            }
            int size = entries.size();
            String[] result = new String[size];
            for (int index = 0; index < size; ++index) {
                result[index] = (String)entries.elementAt(index);
            }
            return result;
        }
        return null;
    }

    protected boolean acceptDirectoryListEntry(String dirName, String fileName, int acceptedType) throws ServiceException {
        String possibleEntry = this.createFileName(dirName, fileName);
        boolean isPossibleEntry = false;
        if (this.fileExists(possibleEntry) && this.canRead(possibleEntry)) {
            switch (acceptedType) {
                case 1: {
                    if (!this.isDirectory(possibleEntry)) break;
                    isPossibleEntry = true;
                    break;
                }
                case 0: {
                    if (!this.isFile(possibleEntry)) break;
                    isPossibleEntry = true;
                    break;
                }
                case 2: {
                    if (!this.fileExists(possibleEntry)) break;
                    isPossibleEntry = true;
                }
            }
        }
        return isPossibleEntry;
    }

    public boolean isDirectory(String file) {
        return new File(file).isDirectory();
    }

    public boolean isFile(String file) throws ServiceException {
        return new File(file).isFile();
    }

    public boolean canRead(String file) {
        return new File(file).canRead();
    }

    public String getSeparator() throws ServiceException {
        return File.separator;
    }

    public char getSeparatorChar() throws ServiceException {
        return File.separatorChar;
    }

    public String getPathSeparator() throws ServiceException {
        return File.pathSeparator;
    }

    public char getPathSeparatorChar() throws ServiceException {
        return File.pathSeparatorChar;
    }

    public String getParent(String child) {
        return CoreFileUtils.getParent(child);
    }

    public String getName(String pathName) throws ServiceException {
        String fullPathName = this.createFileName(this.getCurrentDirectory(), pathName);
        return new File(this.normalizeFileName(fullPathName)).getName();
    }

    public String[] getPartitionNames() throws ServiceException {
        throw new ServiceException(305, "getPartitionNames requires native support. ");
    }

    public String getPartitionName(String absolutePath, String[] partitionNames) throws ServiceException {
        return this.getPartitionName(absolutePath, partitionNames, "");
    }

    public String getPartitionName(String absolutePath, String[] partitionNames, String defaultPartition) throws ServiceException {
        String mapped;
        String convertedPath;
        try {
            convertedPath = new File(absolutePath).getCanonicalPath();
        }
        catch (Exception genErr) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("FileService.getPartitionName(): Problem converting path (" + absolutePath + ") to canonical form: " + genErr.getMessage());
            }
            convertedPath = absolutePath;
        }
        String[] partitions = (String[])partitionNames.clone();
        for (int j = 0; j < partitions.length; ++j) {
            partitions[j] = CoreFileUtils.appendSeparator(partitions[j]).replace(File.separatorChar, '/');
        }
        String path = convertedPath.replace(File.separatorChar, '/');
        Vector matches = new Vector();
        this.getPartitionMatches(path, partitions, matches);
        path = CoreFileUtils.appendSeparator(path).replace(File.separatorChar, '/');
        this.getPartitionMatches(path, partitions, matches);
        if (matches.size() != 0 || defaultPartition.equals("")) {
            mapped = convertedPath;
            int maxLength = 0;
            for (int i = 0; i < matches.size(); ++i) {
                String vol = partitionNames[(Integer)matches.elementAt(i)];
                if (vol.length() <= maxLength) continue;
                mapped = vol;
                maxLength = vol.length();
            }
        } else {
            mapped = defaultPartition;
        }
        return mapped;
    }

    private void getPartitionMatches(String path, String[] partitions, Vector matches) {
        boolean evaluateCase = CoreFileUtils.isFileSystemCaseSensitive();
        for (int i = 0; i < partitions.length; ++i) {
            if ((!evaluateCase || !path.startsWith(partitions[i])) && (evaluateCase || !path.toUpperCase().startsWith(partitions[i].toUpperCase()))) continue;
            matches.addElement(new Integer(i));
        }
    }

    public long getPartitionFreeSpace(String partitionName) throws ServiceException {
        throw new ServiceException(305, "getPartitionFreeSpace requires native support. ");
    }

    public long getPartitionFreeSpace(String partitionName, long requiredBytes) throws ServiceException {
        return this.getPartitionFreeSpace(partitionName);
    }

    public FileAttributes getFileAttributes(String file) throws ServiceException {
        throw new ServiceException(305, "getFileAttributes requires native support. ");
    }

    public void setFileAttributes(String file, FileAttributes attributes) throws ServiceException {
        throw new ServiceException(305, "setFileAttributes requires native support. ");
    }

    public void setFileExecutable(String file) throws ServiceException {
    }

    public String getFileOwner(String file) throws ServiceException {
        throw new ServiceException(305, "getFileOwner requires native support. ");
    }

    public void setFileOwner(String file, String userid) throws ServiceException {
        throw new ServiceException(305, "setFileOwner requires native support. ");
    }

    public String getFileOwnerGroup(String file) throws ServiceException {
        throw new ServiceException(305, "getFileOwnerGroup requires native support. ");
    }

    public void setFileOwnerGroup(String file, String groupid) throws ServiceException {
        throw new ServiceException(305, "setFileOwnerGroup requires native support. ");
    }

    public boolean supportsLongFileNames(String partitionName) throws ServiceException {
        throw new ServiceException(305, "supportsLongFileNames requires native support. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectoryWritable(String directory) throws ServiceException {
        boolean canWrite;
        if (!this.fileExists(directory)) {
            throw new ServiceException(315, directory + " does not exist");
        }
        String tempFile = CoreFileUtils.createFileName(directory, CoreFileUtils.createTempFileName());
        while (this.fileExists(tempFile)) {
            tempFile = CoreFileUtils.createFileName(directory, CoreFileUtils.createTempFileName());
        }
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            out.close();
            canWrite = true;
        }
        catch (IOException e) {
            canWrite = false;
        }
        finally {
            if (this.fileExists(tempFile)) {
                try {
                    this.deleteFile(tempFile);
                }
                catch (ServiceException e) {
                    this.logEvent(this, "err", e);
                }
            }
        }
        return canWrite;
    }

    public int getPartitionType(String directory) throws ServiceException {
        throw new ServiceException(305, "getPartitionType requires native support. ");
    }

    public String getPartitionFormat(String partition) throws ServiceException {
        throw new ServiceException(305, "getPartitionFormat requires native support. ");
    }

    public void createAsciiFile(String fileName, String[] content) throws ServiceException {
        this.writeAsciiFile(fileName, content, false);
    }

    public void createAsciiFile(String fileName, String[] content, String fileEncoding) throws ServiceException {
        this.writeAsciiFile(fileName, content, false, fileEncoding);
    }

    public void createBinaryFile(String fileName, byte[] content) throws ServiceException {
        this.writeBinaryFile(fileName, content, false);
    }

    public void appendToAsciiFile(String fileName, String[] content) throws ServiceException {
        this.writeAsciiFile(fileName, content, true);
    }

    public void appendBinaryFile(String fileName, byte[] content) throws ServiceException {
        this.writeBinaryFile(fileName, content, true);
    }

    private void writeAsciiFile(String fileName, String[] content, boolean append) throws ServiceException {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(fileName, append));
            for (int i = 0; i < content.length; ++i) {
                pw.println(content[i]);
            }
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    private void writeAsciiFile(String fileName, String[] content, boolean append, String fileEncoding) throws ServiceException {
        try {
            FileOutputStream fs = new FileOutputStream(fileName, append);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)fs, fileEncoding));
            for (int i = 0; i < content.length; ++i) {
                pw.println(content[i]);
            }
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceException(e);
        }
    }

    private void writeBinaryFile(String fileName, byte[] content, boolean append) throws ServiceException {
        try {
            int chunk;
            FileOutputStream fileOut = new FileOutputStream(fileName, append);
            int size = content.length;
            for (int start = 0; start < size; start += chunk) {
                chunk = Math.min(1024, size - start);
                fileOut.write(content, start, chunk);
            }
            fileOut.close();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    public String[] readAsciiFile(String fileName) throws ServiceException {
        Vector<String> v = new Vector<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while ((line = br.readLine()) != null) {
                v.addElement(line);
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        Object[] lines = new String[v.size()];
        v.copyInto(lines);
        return lines;
    }

    public String[] readAsciiFile(String fileName, String fileEncoding) throws ServiceException {
        Vector<String> v = new Vector<String>();
        try {
            String line;
            InputStreamReader inr = new InputStreamReader((InputStream)new FileInputStream(fileName), fileEncoding);
            BufferedReader br = new BufferedReader(inr);
            while ((line = br.readLine()) != null) {
                v.addElement(line);
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        Object[] lines = new String[v.size()];
        v.copyInto(lines);
        return lines;
    }

    public int readAsciiFile(String fileName, String[] linesRead, int start, int number) throws ServiceException {
        Vector<String> v = new Vector<String>();
        int numLinesRead = 0;
        if (linesRead == null) {
            throw new ServiceException(315, "Buffer cannot be null");
        }
        if (linesRead.length < number) {
            throw new ServiceException(315, "Buffer is smaller than size indicated.");
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            for (int lineNum = 0; start > lineNum && (line = br.readLine()) != null; ++lineNum) {
            }
            while (numLinesRead < number && (line = br.readLine()) != null) {
                v.addElement(line);
                ++numLinesRead;
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        v.copyInto(linesRead);
        return numLinesRead;
    }

    public int readBinaryFile(String fileName, byte[] bytesRead, int start, int number) throws ServiceException {
        int numBytesRead = 0;
        if (bytesRead == null) {
            throw new ServiceException(315, "Buffer cannot be null");
        }
        if (bytesRead.length < number) {
            throw new ServiceException(315, "Buffer is smaller than size indicated.");
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "r");
            int skipped = raf.skipBytes(start);
            if (skipped >= start) {
                byte[] myBytesRead = new byte[number];
                numBytesRead = raf.read(myBytesRead);
                for (int i = 0; i < numBytesRead; ++i) {
                    bytesRead[i] = myBytesRead[i];
                }
            }
            raf.close();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        return numBytesRead;
    }

    public void updateAsciiFile(String fileName, String[] lines, int start) throws ServiceException {
        Vector<String> v = new Vector<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while ((line = br.readLine()) != null) {
                v.addElement(line);
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        int lineNum = start;
        for (int i = 0; i < lines.length; ++i) {
            if (lineNum < v.size()) {
                v.setElementAt(lines[i], lineNum);
            } else {
                v.addElement(lines[i]);
            }
            ++lineNum;
        }
        Object[] newLines = new String[v.size()];
        v.copyInto(newLines);
        this.createAsciiFile(fileName, (String[])newLines);
    }

    public void updateBinaryFile(String fileName, byte[] bytes, int start) throws ServiceException {
        try {
            RandomAccessFile rwFile = new RandomAccessFile(fileName, "rw");
            rwFile.seek(start);
            rwFile.write(bytes);
            rwFile.close();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    private String removeTrailingSlash(String path) {
        String newPath = CoreFileUtils.normalizeFileName(path);
        if (newPath.endsWith(File.separator)) {
            newPath = newPath.substring(0, newPath.length() - 1);
        }
        return newPath;
    }

    public int getFileSize(String fileName) throws ServiceException {
        int numBytes = 0;
        try {
            FileInputStream fileIn = new FileInputStream(fileName);
            numBytes = fileIn.available();
            fileIn.close();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        return numBytes;
    }

    public long calculateDirectorySize(String dirName) throws ServiceException {
        if (this.isDirectory(dirName)) {
            long totalSize = this.calculateDirectorySizeImpl(dirName);
            String[] fileList = this.getDirectoryList(dirName, 2);
            for (int ii = 0; ii < fileList.length; ++ii) {
                String currPath = CoreFileUtils.appendSeparator(dirName);
                if (this.isDirectory(currPath = currPath + fileList[ii])) {
                    totalSize += this.calculateDirectorySize(currPath);
                    continue;
                }
                totalSize += (long)this.getFileSize(currPath);
            }
            return totalSize;
        }
        throw new ServiceException(315, "Indicated source is not a directory: " + dirName);
    }

    protected long calculateDirectorySizeImpl(String directoryName) throws ServiceException {
        return 0L;
    }

    public int getAsciiFileLineCount(String fileName) throws ServiceException {
        int numLines = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while (br.readLine() != null) {
                ++numLines;
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        return numLines;
    }

    public void copyDirectory(String source, String target, boolean copySubDirectories, boolean overwrite) throws ServiceException {
        String[] fileList = this.getDirectoryList(source, 2);
        File targetFile = new File(target);
        if (!targetFile.exists()) {
            this.createDirectory(target);
            this.copyAttributes(source, target);
        }
        for (int ii = 0; ii < fileList.length; ++ii) {
            String currPath = CoreFileUtils.appendSeparator(source);
            currPath = currPath + fileList[ii];
            String copyToPath = CoreFileUtils.appendSeparator(target);
            copyToPath = copyToPath + fileList[ii];
            if (new File(currPath).isDirectory()) {
                if (!copySubDirectories) continue;
                this.copyDirectory(currPath, copyToPath, copySubDirectories, overwrite);
                continue;
            }
            this.copyFile(currPath, copyToPath, overwrite);
        }
    }

    public boolean comparePaths(String path1, String path2) throws ServiceException {
        return CoreFileUtils.comparePaths(path1, path2);
    }

    public void setSystemUMask(int mode) throws ServiceException {
        throw new ServiceException(305, "setSystemUMask requires native support. ");
    }

    public int getSystemUMask() throws ServiceException {
        throw new ServiceException(305, "getSystemUMask requires native support. ");
    }

    public void validateFileName(String fileName) throws ServiceException {
        File f = new File(fileName);
        if (f.exists()) {
            return;
        }
        try {
            if (f.createNewFile()) {
                f.delete();
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (f.mkdirs()) {
            f.delete();
            return;
        }
        throw new ServiceException(2);
    }

    public final String getPlatformId() throws ServiceException {
        return this.getPlatformIdImpl();
    }

    public String createFileName(String context, String fileName) throws ServiceException {
        if (context == null) {
            context = "";
        }
        context = context.trim();
        if (fileName == null) {
            return this.normalizeFileName(context);
        }
        fileName = fileName.trim();
        if (this.isAbsolute(fileName = this.normalizeFileName(fileName))) {
            return fileName;
        }
        if ((context = this.normalizeFileName(context)).endsWith(this.getSeparator())) {
            return context + fileName;
        }
        return context + this.getSeparator() + fileName;
    }

    public boolean isAbsolute(String fileName) throws ServiceException {
        fileName = this.normalizeFileName(fileName);
        File f = new File(fileName);
        return fileName.startsWith(File.separator) || f.isAbsolute();
    }

    public String normalizeFileName(String fileName, char normalSeparator) throws ServiceException {
        if (fileName == null) {
            throw new NullPointerException("fileName cannot be null");
        }
        return fileName.replace('/', normalSeparator).replace('\\', normalSeparator);
    }

    public String normalizeFileName(String fileName) throws ServiceException {
        return this.normalizeFileName(fileName, this.getSeparatorChar());
    }

    protected String getPlatformIdImpl() {
        return "";
    }

    public void createSymbolicLink(String target, String linkName, boolean forceLink) throws ServiceException {
        throw new ServiceException(305, "createSymbolicLink requires native support. ");
    }

    public void removeSymbolicLink(String linkName) throws ServiceException {
        throw new ServiceException(305, "removeSymbolicLink requires native support. ");
    }
}

