/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service.system;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.FileUtils;
import com.installshield.util.LockedFilesHandler;
import com.installshield.util.ProcessExec;
import com.installshield.util.ProcessExecException;
import com.installshield.util.process.ExecuteProcessSupport;
import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.SystemUtilServiceImplementor;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class PureJavaSystemUtilServiceImpl
extends AbstractServiceImplementor
implements SystemUtilServiceImplementor,
LockedFilesHandler {
    private static boolean rebootRequired = false;
    private static boolean logoutRequired = false;
    private static boolean rebootOnExit = false;
    private static Hashtable filesToDeleteOnExit = new Hashtable();
    private static Hashtable directoriesToRecursivelyDeleteOnExit = new Hashtable();

    public int getSystemCompatibility() {
        return 1;
    }

    public void setEnvironmentVariable(String variableName, String variableValue) throws ServiceException {
        throw new ServiceException(305);
    }

    public void setEnvironmentVariable(String variableName, String variableValue, int level) throws ServiceException {
        throw new ServiceException(305);
    }

    public String getEnvironmentVariable(String variableName) throws ServiceException {
        throw new ServiceException(305);
    }

    public String getRawEnvironmentVariable(String variableName, int level) throws ServiceException {
        throw new ServiceException(305);
    }

    public void deleteEnvironmentVariable(String variableName) throws ServiceException {
        throw new ServiceException(305);
    }

    public void deleteEnvironmentVariable(String variableName, int level) throws ServiceException {
        throw new ServiceException(305);
    }

    public void appendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        throw new ServiceException(305);
    }

    public void prependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        throw new ServiceException(305);
    }

    public void unAppendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        throw new ServiceException(305);
    }

    public void unPrependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        throw new ServiceException(305);
    }

    public String getOSServiceLevel() throws ServiceException {
        throw new ServiceException(305);
    }

    public void addSystemStartupCommand(String command) throws ServiceException {
        throw new ServiceException(305);
    }

    public void removeSystemStartupCommand(String command) throws ServiceException {
        throw new ServiceException(305);
    }

    public Enumeration systemStartupCommands() throws ServiceException {
        throw new ServiceException(305);
    }

    public boolean isRebootRequired() throws ServiceException {
        return rebootRequired;
    }

    public void setRebootRequired(boolean rebootRequired) throws ServiceException {
        PureJavaSystemUtilServiceImpl.rebootRequired = rebootRequired;
    }

    public boolean isLogoutRequired() throws ServiceException {
        return logoutRequired;
    }

    public void setLogoutRequired(boolean logoutRequired) throws ServiceException {
        PureJavaSystemUtilServiceImpl.logoutRequired = logoutRequired;
    }

    public boolean getRebootOnExit() throws ServiceException {
        return rebootOnExit;
    }

    public void setRebootOnExit(boolean rebootOnExit) throws ServiceException {
        PureJavaSystemUtilServiceImpl.rebootOnExit = rebootOnExit;
    }

    public void deleteFileOnExit(String fileName) throws ServiceException {
        filesToDeleteOnExit.put(fileName, "");
    }

    public void deleteDirectoryOnExit(String dirName, boolean recurse) throws ServiceException {
        if (recurse) {
            directoriesToRecursivelyDeleteOnExit.put(dirName, "");
        } else {
            filesToDeleteOnExit.put(dirName, "");
        }
    }

    public void deleteLockedFiles(String[] files) {
        for (int i = 0; i < files.length; ++i) {
            filesToDeleteOnExit.put(files[i], "");
        }
        this.deleteFilesAfterExit();
        Enumeration enumeration = this.filesToDeleteOnExit();
        while (enumeration.hasMoreElements()) {
            String fileName = (String)enumeration.nextElement();
            if (!new File(fileName).exists()) continue;
            System.err.println("WARNING: could not delete locked file " + fileName);
        }
    }

    public void cleanup() throws ServiceException {
    }

    protected final Enumeration filesToDeleteOnExit() {
        if (filesToDeleteOnExit != null) {
            return filesToDeleteOnExit.keys();
        }
        return new Vector().elements();
    }

    protected final Enumeration directoriesToRecursivelyDeleteOnExit() {
        if (directoriesToRecursivelyDeleteOnExit != null) {
            return directoriesToRecursivelyDeleteOnExit.keys();
        }
        return new Vector().elements();
    }

    protected final void removeFileToDeleteOnExit(String fileName) {
        if (filesToDeleteOnExit != null) {
            filesToDeleteOnExit.remove(fileName);
        }
    }

    protected final void removeDirectoryToRecursivelyDeleteOnExit(String dirName) {
        if (directoriesToRecursivelyDeleteOnExit != null) {
            directoriesToRecursivelyDeleteOnExit.remove(dirName);
        }
    }

    protected void deleteFilesAfterExit() {
        boolean deletedOne;
        Vector<String> directories = new Vector<String>();
        Enumeration enumeration = this.filesToDeleteOnExit();
        while (enumeration.hasMoreElements()) {
            String fileName = (String)enumeration.nextElement();
            String normalizedFileName = CoreFileUtils.normalizeFileName(fileName);
            File file = new File(normalizedFileName);
            if (file.exists()) {
                if (file.isFile()) {
                    if (!file.delete()) continue;
                    this.removeFileToDeleteOnExit(fileName);
                    continue;
                }
                if (!file.isDirectory()) continue;
                directories.addElement(fileName);
                continue;
            }
            this.removeFileToDeleteOnExit(fileName);
        }
        do {
            deletedOne = false;
            enum = this.directoriesToRecursivelyDeleteOnExit();
            while (enum.hasMoreElements()) {
                String dirName = (String)enum.nextElement();
                String parent = CoreFileUtils.getParent(dirName);
                if (parent != null && parent.trim().length() > 0) {
                    if (!this.deleteDirectory(dirName, true)) continue;
                    this.removeDirectoryToRecursivelyDeleteOnExit(dirName);
                    deletedOne = true;
                    continue;
                }
                this.removeDirectoryToRecursivelyDeleteOnExit(dirName);
            }
        } while (deletedOne);
        do {
            deletedOne = false;
            for (int i = 0; !deletedOne && i < directories.size(); ++i) {
                String fileName = (String)directories.elementAt(i);
                if (!this.deleteDirectory(fileName, false)) continue;
                directories.removeElementAt(i);
                this.removeFileToDeleteOnExit(fileName);
                deletedOne = true;
            }
        } while (deletedOne);
        try {
            this.deleteDirectoryOnExit(FileUtils.getUniversalTempDir(), true);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    private boolean deleteFile(String fileName) {
        File fileToDelete = new File(fileName);
        if (fileToDelete.exists()) {
            return new File(fileName).delete();
        }
        return true;
    }

    private boolean deleteDirectory(String directoryName, boolean recurse) {
        String normalizedFileName = CoreFileUtils.normalizeFileName(directoryName);
        File dir = new File(normalizedFileName);
        if (dir.exists()) {
            if (dir.getParent() != null) {
                if (recurse) {
                    String[] list = dir.list();
                    for (int i = 0; i < list.length; ++i) {
                        File f = new File(dir, list[i]);
                        if (f.isFile()) {
                            this.deleteFile(f.getAbsolutePath());
                            continue;
                        }
                        if (!f.isDirectory()) continue;
                        this.deleteDirectory(f.getAbsolutePath(), true);
                    }
                }
                return dir.delete();
            }
            return false;
        }
        return true;
    }

    public Properties getOSProperties() throws ServiceException {
        Properties p = new Properties();
        String value = System.getProperty("os.name");
        if (value != null) {
            ((Hashtable)p).put("os.name", value);
        }
        if ((value = System.getProperty("os.vendor")) != null) {
            ((Hashtable)p).put("os.vendor", value);
        }
        if ((value = System.getProperty("os.version")) != null) {
            ((Hashtable)p).put("os.version", value);
        }
        if ((value = System.getProperty("os.arch")) != null) {
            ((Hashtable)p).put("os.arch", value);
        }
        return p;
    }

    public void registerLockedFilesHandler() throws ServiceException {
        FileUtils.setLockedFilesHandler(this);
    }

    public void executeProcess(ExecuteProcessSupport execProcSupport, Properties extendedProperties) throws ServiceException {
        try {
            ProcessExec procExec = this.createProcessExec(execProcSupport);
            execProcSupport.setProcessStarted();
            procExec.executeProcess();
            execProcSupport.setProcessFinished();
            execProcSupport.setProcessReturnCode(procExec.getExitCode());
            execProcSupport.addCreatedFilesOrDirectories(procExec.getCreatedDirectories());
        }
        catch (ProcessExecException e) {
            execProcSupport.setProcessError();
            throw new ServiceException(e);
        }
    }

    private ProcessExec createProcessExec(ExecuteProcessSupport execProcSupport) {
        ProcessExec ret = new ProcessExec(execProcSupport.getCommand(), execProcSupport.getArguments(), execProcSupport.getStdOutDestination(), execProcSupport.getStdErrDestination());
        ret.setProcessOutputHandler(execProcSupport.getProcessOutputHandler());
        return ret;
    }
}

