/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.SearchResult;
import com.installshield.wizardx.ascii.Update;

public class AddLine
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private int addOption = 0;
    private String[] textLines = new String[0];
    private int location = 1;
    public static final int LINE = 0;
    public static final int TEXT = 1;
    public static final int COMMENT = 2;
    public static final int COMMENT_LINE = 3;
    public static final int START_FILE = 0;
    public static final int END_FILE = 1;
    public static final int CURRENT = 2;
    public static final String TYPE_DESCRIPTION = "Add Line/Text/Comment";

    public void setAddOption(int addOption) {
        this.addOption = addOption;
    }

    public int getAddOption() {
        return this.addOption;
    }

    public void setTextLines(String[] textLines) {
        this.textLines = textLines;
    }

    public String[] getTextLines() {
        return this.textLines;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public int getLocation() {
        return this.location;
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public String getShortDescription() {
        String optionText = this.getAddOption() == 0 ? "Line(s): " : (this.getAddOption() == 1 ? "Text: " : (this.getAddOption() == 2 ? "Comment Chars" : "Comment Line(s): "));
        String shortDescription = "Add " + optionText;
        if (this.getAddOption() == 2) {
            return shortDescription;
        }
        return shortDescription + this.formatTextLines();
    }

    private String formatTextLines() {
        String s;
        String[] value = this.getTextLines();
        if (value == null || value.length <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int charsLeft = 30;
        for (int i = 0; charsLeft > 0 && i < value.length; charsLeft -= s.length(), ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if ((s = value[i]).length() > charsLeft) {
                buf.append(s.substring(0, charsLeft) + "...");
                continue;
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public void verify(AsciiFileUpdateSupport support) {
        if (this.getAddOption() != 2 && (this.getTextLines() == null || this.getTextLines().length == 0 || this.getTextLines().length == 1 && this.getTextLines()[0].length() == 0)) {
            support.logEvent(this, "wrn", "Add Line/Text/Comment requires Text Lines unless adding a comment.");
        }
    }

    public boolean execute(ModifyFile modify) {
        boolean modified = false;
        if (this.getAddOption() != 2 && (this.getTextLines() == null || this.getTextLines().length == 0 || this.getTextLines().length == 1 && this.getTextLines()[0].length() == 0)) {
            modify.getLogAdd().addElement("Add Line/Text/Comment requires Text Lines unless adding a comment.");
        } else {
            if (this.getLocation() == 0) {
                modify.setASCIISearchResults(new SearchResult[]{modify.startOfFile()});
            } else if (this.getLocation() == 1) {
                modify.setASCIISearchResults(new SearchResult[]{modify.endOfFile()});
            }
            if (modify.getASCIISearchResults() != null && modify.getASCIISearchResults().length > 0) {
                if (this.getAddOption() == 2) {
                    modify.addComment();
                } else {
                    String[] resolvedTextLines = new String[this.getTextLines().length];
                    for (int i = 0; i < this.getTextLines().length; ++i) {
                        resolvedTextLines[i] = modify.resolveString(this.getTextLines()[i]);
                    }
                    if (this.getAddOption() == 1) {
                        modify.addText(resolvedTextLines);
                    } else if (this.getAddOption() == 0) {
                        modify.addLine(resolvedTextLines);
                    } else {
                        modify.addCommentLine(resolvedTextLines);
                    }
                }
                modified = true;
                modify.setASCIISearchResults(null);
            }
        }
        return modified;
    }

    public Object clone() {
        AddLine ret = (AddLine)super.clone();
        ret.addOption = this.addOption;
        ret.textLines = this.textLines;
        ret.location = this.location;
        return ret;
    }
}

