/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;

public class DeleteLine
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private int deleteOption = 0;
    private String deleteText = new String();
    public static final int LINE = 0;
    public static final int TEXT = 1;
    public static final String TYPE_DESCRIPTION = "Delete Line/Text";

    public void setDeleteOption(int deleteOption) {
        this.deleteOption = deleteOption;
    }

    public int getDeleteOption() {
        return this.deleteOption;
    }

    public void setDeleteText(String deleteText) {
        this.deleteText = deleteText;
    }

    public String getDeleteText() {
        return this.deleteText;
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public String getShortDescription() {
        if (this.getDeleteOption() == 0) {
            return "Delete Line";
        }
        return "Delete Text: " + this.getDeleteText();
    }

    public void verify(AsciiFileUpdateSupport support) {
        if (this.getDeleteOption() == 1 && (this.getDeleteText() == null || this.getDeleteText().length() == 0)) {
            support.logEvent(this, "wrn", "Delete Line/Text requires Delete Text if Delete Option is Text.");
        }
    }

    public boolean execute(ModifyFile modify) {
        boolean modified = false;
        if (this.getDeleteOption() == 1 && (this.getDeleteText() == null || this.getDeleteText().length() == 0)) {
            modify.getLogAdd().addElement("Delete Line/Text requires Delete Text if Delete Option is Text.");
        } else if (modify.getASCIISearchResults() != null && modify.getASCIISearchResults().length > 0) {
            if (this.getDeleteOption() == 1) {
                modified = modify.deleteText(modify.resolveString(this.getDeleteText()));
            } else {
                modify.deleteLine();
                modified = true;
            }
            modify.setASCIISearchResults(null);
        }
        return modified;
    }

    public Object clone() {
        DeleteLine ret = (DeleteLine)super.clone();
        ret.deleteOption = this.deleteOption;
        ret.deleteText = this.deleteText;
        return ret;
    }
}

