/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;
import java.util.Vector;

public class DeleteLinesBetween
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private String[] tokens = new String[0];
    private boolean includeSearchLines = true;
    public static final String TYPE_DESCRIPTION = "Delete Lines Between";

    public void setTokens(String[] tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException("tokens cannot be null");
        }
        this.tokens = tokens;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public void setIncludeSearchLines(boolean includeSearchLines) {
        this.includeSearchLines = includeSearchLines;
    }

    public boolean getIncludeSearchLines() {
        return this.includeSearchLines;
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    private String formatTokens() {
        String s;
        String[] value = this.getTokens();
        if (value == null || value.length <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int charsLeft = 30;
        for (int i = 0; charsLeft > 0 && i < value.length; charsLeft -= s.length(), ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if ((s = value[i]).length() > charsLeft) {
                buf.append(s.substring(0, charsLeft) + "...");
                continue;
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public String getShortDescription() {
        return "Delete Lines Between Search Result and: " + this.formatTokens();
    }

    private boolean validTokens() {
        for (int i = 0; i < this.getTokens().length; ++i) {
            if (this.getTokens()[i] == null || this.getTokens()[i].length() <= 0) continue;
            return true;
        }
        return false;
    }

    private Vector getResolvedTokens(ModifyFile modify) {
        Vector<String> resolvedTokens = new Vector<String>();
        for (int i = 0; i < this.getTokens().length; ++i) {
            if (this.getTokens()[i] == null || this.getTokens()[i].length() <= 0) continue;
            resolvedTokens.addElement(modify.resolveString(this.getTokens()[i]));
        }
        return resolvedTokens;
    }

    public void verify(AsciiFileUpdateSupport support) {
        if (this.getTokens() == null || !this.validTokens()) {
            support.logEvent(this, "wrn", "Delete Lines Between requires Tokens have at least one valid token.");
        }
    }

    public boolean execute(ModifyFile modify) {
        boolean modified = false;
        if (this.getTokens() == null || !this.validTokens()) {
            modify.getLogAdd().addElement("Delete Lines Between requires Tokens have at least one valid token.");
        } else if (modify.getASCIISearchResults() != null && modify.getASCIISearchResults().length > 0) {
            int firstLineNum = modify.getASCIISearchResults()[0].getLineNum();
            modify.setMatch(this.getResolvedTokens(modify));
            modify.setOccurrenceFrequency(1);
            modify.setReturnPosition(0);
            modify.setTokensNotFound(2);
            modify.searchMultipleStrings();
            if (modify.getASCIISearchResults() != null && modify.getASCIISearchResults().length == 1) {
                int lastLineNum = modify.getASCIISearchResults()[0].getLineNum();
                modify.setIncludeSearchLines(this.getIncludeSearchLines());
                modify.deleteLinesBetween(firstLineNum, lastLineNum);
                modified = true;
                modify.setASCIISearchResults(null);
            }
        }
        return modified;
    }

    public Object clone() {
        DeleteLinesBetween ret = (DeleteLinesBetween)super.clone();
        ret.tokens = this.tokens;
        return ret;
    }
}

