/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.SearchResult;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ModifyFile {
    static final int NONE = -1;
    static final int BEGINNING = 0;
    static final int END = 1;
    static final int BEFOREFIRST = 2;
    static final int BEFORELAST = 3;
    static final int BEFOREEVERY = 4;
    static final int AFTERFIRST = 5;
    static final int AFTERLAST = 6;
    static final int AFTEREVERY = 7;
    static final int DONOTHING = 8;
    static final int ALWAYS = 0;
    static final int NEVER = 1;
    static final int IFGREATER = 2;
    public static final int FIRST = 0;
    public static final int LAST = 1;
    public static final int EVERY = 2;
    public static final int BEG_LINE = 0;
    public static final int END_LINE = 1;
    public static final int BEG_TOKEN = 2;
    public static final int END_TOKEN = 3;
    public static final int LAST_TOKEN = 4;
    public static final int BEG_FILE = 0;
    public static final int END_FILE = 1;
    public static final int NO_ACTION = 2;
    public static final int APPEND = 0;
    public static final int PREPEND = 1;
    public static final int REPLACE = 2;
    public static final int DELETE = 3;
    private AsciiFileUpdateSupport support;
    private String fieldFile = new String();
    private boolean caseSensitive = false;
    private int occurrenceFrequency = 0;
    private int returnPosition = 2;
    private int tokensNotFound = 2;
    private Vector match = new Vector();
    private Vector logAdd = new Vector();
    private SearchResult[] results = null;
    private Vector allLines = new Vector();
    private String backUpFile = null;
    private String commentChar = null;
    private FileService fileService = null;
    private int location = 0;
    private boolean includeSearchLines = true;
    private boolean ignoreCommentLines = true;
    private boolean overwriteExisting = false;
    private String fileEncoding = "";

    public ModifyFile(AsciiFileUpdateSupport support) {
        this.support = support;
    }

    public String getFile() {
        return this.fieldFile;
    }

    public Vector getAllLines() {
        return this.allLines;
    }

    public Vector getLogAdd() {
        return this.logAdd;
    }

    public Vector getMatch() {
        return this.match;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public int getOccurrenceFrequency() {
        return this.occurrenceFrequency;
    }

    public int getReturnPosition() {
        return this.returnPosition;
    }

    public int getTokensNotFound() {
        return this.tokensNotFound;
    }

    public String getBackUpFile() {
        return this.backUpFile;
    }

    public String getCommentChar() {
        return this.commentChar;
    }

    public SearchResult[] getASCIISearchResults() {
        return this.results;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public int getLocation() {
        return this.location;
    }

    public boolean getIncludeSearchLines() {
        return this.includeSearchLines;
    }

    public boolean getIgnoreCommentLines() {
        return this.ignoreCommentLines;
    }

    public boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    public String getFileEncoding(String fileEncoding) {
        return fileEncoding;
    }

    public String resolveString(String s) {
        return this.support.resolveString(s);
    }

    public void setMatch(Vector temp) {
        this.match = temp;
    }

    public void setLogAdd(Vector add) {
        this.logAdd = add;
    }

    public void setCommentChar(String newChar) {
        this.commentChar = newChar;
    }

    public void setCaseSensitive(boolean caseSens) {
        this.caseSensitive = caseSens;
    }

    public void setOccurrenceFrequency(int occFreq) {
        this.occurrenceFrequency = occFreq;
    }

    public void setReturnPosition(int retPos) {
        this.returnPosition = retPos;
    }

    public void setTokensNotFound(int notFound) {
        this.tokensNotFound = notFound;
    }

    public void setFile(String newFile) {
        this.fieldFile = newFile;
    }

    public void setBackUpFile(String newFile) {
        this.backUpFile = newFile;
    }

    public void setASCIISearchResults(SearchResult[] newResults) {
        this.results = newResults;
    }

    public void setFileService(FileService newFileService) {
        this.fileService = newFileService;
    }

    public void setLocation(int newLocation) {
        this.location = newLocation;
    }

    public void setIncludeSearchLines(boolean newIncludeSearchLines) {
        this.includeSearchLines = newIncludeSearchLines;
    }

    public void setIgnoreCommentLines(boolean newIgnoreCommentLines) {
        this.ignoreCommentLines = newIgnoreCommentLines;
    }

    public void setOverwriteExisting(boolean newOverwriteExisting) {
        this.overwriteExisting = newOverwriteExisting;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public boolean loadFile() throws ServiceException {
        boolean fileExists = false;
        this.getAllLines().removeAllElements();
        fileExists = this.fileService.fileExists(this.getFile());
        String[] lines = new String[]{};
        if (fileExists && !this.overwriteExisting) {
            lines = this.fileEncoding == null || this.fileEncoding.trim().length() <= 0 ? this.fileService.readAsciiFile(this.getFile()) : this.fileService.readAsciiFile(this.getFile(), this.fileEncoding);
            this.getLogAdd().addElement("Reading in ASCII file " + this.getFile() + ".");
        } else if (!fileExists) {
            this.getLogAdd().addElement("ASCII file " + this.getFile() + " does not exist and will be created.");
        } else {
            this.getLogAdd().addElement("ASCII file " + this.getFile() + " will be overwritten.");
        }
        for (int i = 0; i < lines.length; ++i) {
            this.getAllLines().addElement(lines[i]);
        }
        return fileExists;
    }

    public void writeFile() throws ServiceException {
        Object[] lines = new String[this.getAllLines().size()];
        this.getAllLines().copyInto(lines);
        try {
            if (this.fileEncoding == null || this.fileEncoding.trim().length() <= 0) {
                this.fileService.createAsciiFile(this.getFile(), (String[])lines);
            } else {
                this.fileService.createAsciiFile(this.getFile(), (String[])lines, this.fileEncoding);
            }
        }
        catch (ServiceException se) {
            this.support.logEvent(this, "err", "Could not write ASCII file " + this.getFile() + ".");
            throw se;
        }
    }

    public void backupFile() throws ServiceException {
        try {
            if (this.backUpFile == null) {
                this.backUpFile = this.getFile();
                String name = this.fileService.getName(this.getFile());
                int i = name.lastIndexOf(".");
                if (i > -1) {
                    name = name.substring(0, i);
                }
                this.backUpFile = this.fileService.createFileName(this.fileService.getParent(this.getFile()), name);
                boolean validBackup = false;
                for (int j = 0; j < 999 && !validBackup; ++j) {
                    if (this.fileService.fileExists(this.backUpFile + "." + this.threeDigitExtension(j))) continue;
                    validBackup = true;
                    this.backUpFile = this.backUpFile + "." + this.threeDigitExtension(j);
                }
                if (!validBackup) {
                    this.backUpFile = this.backUpFile + ".000";
                }
                this.fileService.copyFile(this.getFile(), this.backUpFile, true);
                this.getLogAdd().addElement("ASCII file backed up to " + this.backUpFile + ".");
            }
        }
        catch (ServiceException se) {
            this.support.logEvent(this, "wrn", "Could not backup the ASCII file " + this.getFile() + ".");
            throw se;
        }
    }

    private String threeDigitExtension(int number) {
        String extension = Integer.toString(number);
        if (extension.length() == 1) {
            extension = "00" + extension;
        } else if (extension.length() == 2) {
            extension = "0" + extension;
        }
        return extension;
    }

    public boolean areMatches() {
        return this.getASCIISearchResults() != null && this.getASCIISearchResults().length > 0;
    }

    public void searchMultipleStrings() {
        Object[] searchResult;
        Vector<SearchResult> matchList = new Vector<SearchResult>();
        String currentLine = new String();
        String currentMatch = new String();
        int currentPosition = 0;
        int firstPosition = -1;
        boolean order = true;
        for (int lineNum = 0; lineNum < this.getAllLines().size(); ++lineNum) {
            currentLine = this.getAllLines().elementAt(lineNum).toString();
            if (this.getIgnoreCommentLines() && this.getCommentChar().length() > 0 && currentLine.trim().startsWith(this.getCommentChar())) continue;
            order = true;
            firstPosition = -1;
            currentPosition = 0;
            int position = 0;
            for (int k = 0; k < this.getMatch().size() && order; ++k) {
                if (this.getCaseSensitive()) {
                    currentMatch = this.getMatch().elementAt(k).toString();
                } else {
                    currentMatch = this.getMatch().elementAt(k).toString().toUpperCase();
                    currentLine = currentLine.toUpperCase();
                }
                int endofLine = 0;
                while (endofLine != -1) {
                    currentPosition = currentLine.indexOf(currentMatch, position);
                    position = currentPosition + currentMatch.length();
                    endofLine = currentPosition;
                    if (currentPosition != -1) {
                        if (firstPosition == -1) {
                            firstPosition = currentPosition;
                        }
                        if (k == this.getMatch().size() - 1) {
                            if (this.getReturnPosition() == 0) {
                                currentPosition = 0;
                            } else if (this.getReturnPosition() == 1) {
                                currentPosition = currentLine.length();
                            } else if (this.getReturnPosition() == 3) {
                                currentPosition += currentMatch.length();
                            } else if (this.getReturnPosition() == 2) {
                                currentPosition = firstPosition;
                            }
                            matchList.addElement(new SearchResult(lineNum, currentPosition));
                            continue;
                        }
                        currentPosition += currentMatch.length();
                        continue;
                    }
                    if (firstPosition != -1) continue;
                    order = false;
                }
            }
        }
        if (matchList.isEmpty()) {
            if (this.getTokensNotFound() == 0) {
                matchList.addElement(this.startOfFile());
            } else if (this.getTokensNotFound() == 1) {
                matchList.addElement(this.endOfFile());
            }
        }
        if (matchList.isEmpty()) {
            searchResult = null;
        } else if (this.getOccurrenceFrequency() == 0) {
            searchResult = new SearchResult[]{(SearchResult)matchList.firstElement()};
        } else if (this.getOccurrenceFrequency() == 1) {
            searchResult = new SearchResult[]{(SearchResult)matchList.lastElement()};
        } else {
            searchResult = new SearchResult[matchList.size()];
            matchList.copyInto(searchResult);
        }
        this.setASCIISearchResults((SearchResult[])searchResult);
    }

    public void searchStringsOnlyWhtSpc() {
        Object[] searchResult;
        Vector<SearchResult> matchList = new Vector<SearchResult>();
        String currentMatch = new String();
        String currentLine = new String();
        int currentPosition = 0;
        int firstPosition = -1;
        int currentEnd = 0;
        boolean order = true;
        for (int lineNum = 0; lineNum < this.getAllLines().size(); ++lineNum) {
            currentLine = this.getAllLines().elementAt(lineNum).toString();
            if (this.getIgnoreCommentLines() && this.getCommentChar().length() > 0 && currentLine.trim().startsWith(this.getCommentChar())) continue;
            order = true;
            firstPosition = -1;
            currentEnd = 0;
            currentPosition = 0;
            for (int k = 0; k < this.getMatch().size() && order; ++k) {
                if (this.getCaseSensitive()) {
                    currentMatch = this.getMatch().elementAt(k).toString();
                } else {
                    currentMatch = this.getMatch().elementAt(k).toString().toUpperCase();
                    currentLine = currentLine.toUpperCase();
                }
                currentPosition = currentLine.indexOf(currentMatch, currentEnd);
                if (currentPosition != -1) {
                    if (firstPosition == -1) {
                        firstPosition = currentPosition;
                    }
                    if (currentPosition > currentEnd && currentLine.substring(currentEnd, currentPosition).trim().length() != 0) {
                        order = false;
                    }
                    currentEnd = currentPosition + currentMatch.length();
                    if (!order || k != this.getMatch().size() - 1) continue;
                    if (this.getReturnPosition() == 0) {
                        currentPosition = 0;
                    } else if (this.getReturnPosition() == 1) {
                        currentPosition = currentLine.length();
                    } else if (this.getReturnPosition() == 3) {
                        currentPosition = currentEnd;
                    } else if (this.getReturnPosition() == 2) {
                        currentPosition = firstPosition;
                    }
                    matchList.addElement(new SearchResult(lineNum, currentPosition));
                    continue;
                }
                order = false;
            }
        }
        if (matchList.isEmpty()) {
            if (this.getTokensNotFound() == 0) {
                matchList.addElement(this.startOfFile());
            } else if (this.getTokensNotFound() == 1) {
                matchList.addElement(this.endOfFile());
            }
        }
        if (matchList.isEmpty()) {
            searchResult = null;
        } else if (this.getOccurrenceFrequency() == 0) {
            searchResult = new SearchResult[]{(SearchResult)matchList.firstElement()};
        } else if (this.getOccurrenceFrequency() == 1) {
            searchResult = new SearchResult[]{(SearchResult)matchList.lastElement()};
        } else {
            searchResult = new SearchResult[matchList.size()];
            matchList.copyInto(searchResult);
        }
        this.setASCIISearchResults((SearchResult[])searchResult);
    }

    public SearchResult startOfFile() {
        return new SearchResult(0, 0);
    }

    public SearchResult endOfFile() {
        if (this.getAllLines().isEmpty()) {
            return this.startOfFile();
        }
        return new SearchResult(this.getAllLines().size() - 1, this.getAllLines().lastElement().toString().length());
    }

    public void addComment() {
        SearchResult[] searchResults = this.getASCIISearchResults();
        if (searchResults != null) {
            for (int i = 0; i < searchResults.length; ++i) {
                int lineNum = searchResults[i].getLineNum();
                int position = searchResults[i].getPosition();
                String origLine = (String)this.getAllLines().elementAt(lineNum);
                String newLine = position == 0 ? this.getCommentChar().concat(origLine) : (position >= origLine.length() ? origLine.concat(this.getCommentChar()) : origLine.substring(0, position) + this.getCommentChar() + origLine.substring(position));
                this.getAllLines().setElementAt(newLine, lineNum);
                this.getLogAdd().addElement("/ADD COMMENT/");
            }
        }
    }

    public void addLine(String[] newLines) {
        SearchResult[] searchResults = this.getASCIISearchResults();
        if (searchResults != null) {
            for (int i = searchResults.length - 1; i >= 0; --i) {
                int lineNum = searchResults[i].getLineNum();
                int position = searchResults[i].getPosition();
                String origLine = !this.getAllLines().isEmpty() ? (String)this.getAllLines().elementAt(lineNum) : new String();
                if (position == 0) {
                    this.addLineAt(newLines, lineNum);
                    continue;
                }
                if (position >= origLine.length()) {
                    this.addLineAt(newLines, lineNum + 1);
                    continue;
                }
                String splitLine1 = origLine.substring(0, position);
                String splitLine2 = origLine.substring(position);
                this.getAllLines().setElementAt(splitLine1, lineNum);
                this.getAllLines().insertElementAt(splitLine2, lineNum + 1);
                this.addLineAt(newLines, lineNum + 1);
            }
        }
    }

    public void addLineAt(String[] newLines, int lineNum) {
        if (newLines.length > 1) {
            this.getLogAdd().addElement("/ADD LINES AT LINE " + lineNum + "/");
            for (int i = 0; i < newLines.length; ++i) {
                this.getLogAdd().addElement(newLines[i]);
                this.getAllLines().insertElementAt(newLines[i], lineNum++);
            }
        } else if (newLines.length == 1) {
            this.getLogAdd().addElement("/ADD LINE AT LINE " + lineNum + "/");
            this.getLogAdd().addElement(newLines[0]);
            this.getAllLines().insertElementAt(newLines[0], lineNum);
        }
    }

    public void addCommentLine(String[] newLines) {
        SearchResult[] searchResults = this.getASCIISearchResults();
        if (searchResults != null) {
            for (int i = searchResults.length - 1; i >= 0; --i) {
                int lineNum = searchResults[i].getLineNum();
                int position = searchResults[i].getPosition();
                String origLine = !this.getAllLines().isEmpty() ? (String)this.getAllLines().elementAt(lineNum) : new String();
                if (position == 0) {
                    this.addCommentLineAt(newLines, lineNum);
                    continue;
                }
                if (position >= origLine.length()) {
                    this.addCommentLineAt(newLines, lineNum + 1);
                    continue;
                }
                String splitLine1 = origLine.substring(0, position);
                String splitLine2 = origLine.substring(position);
                this.getAllLines().setElementAt(splitLine1, lineNum);
                this.getAllLines().insertElementAt(splitLine2, lineNum + 1);
                this.addCommentLineAt(newLines, lineNum + 1);
            }
        }
    }

    public void addCommentLineAt(String[] newLines, int lineNum) {
        String commentChars = this.getCommentChar();
        if (commentChars == null) {
            commentChars = "";
        }
        if (commentChars.length() > 0 && !commentChars.endsWith(" ")) {
            commentChars = commentChars + " ";
        }
        if (newLines.length > 1) {
            this.getLogAdd().addElement("/ADD COMMENT LINE AT LINE " + lineNum + "/");
            for (int i = 0; i < newLines.length; ++i) {
                this.getLogAdd().addElement(commentChars + newLines[i]);
                this.getAllLines().insertElementAt(commentChars + newLines[i], lineNum++);
            }
        } else if (newLines.length == 1) {
            this.getLogAdd().addElement("/ADD COMMENT LINE AT LINE " + lineNum + "/");
            this.getLogAdd().addElement(commentChars + newLines[0]);
            this.getAllLines().insertElementAt(commentChars + newLines[0], lineNum);
        }
    }

    public void addText(String[] newText) {
        SearchResult[] searchResults = this.getASCIISearchResults();
        if (searchResults != null) {
            for (int i = searchResults.length - 1; i >= 0; --i) {
                int lineNum = searchResults[i].getLineNum();
                int position = searchResults[i].getPosition();
                this.addTextAt(newText, lineNum, position);
            }
        }
    }

    public void addTextAt(String[] newText, int lineNum, int position) {
        if (newText.length > 0) {
            String newLine;
            boolean moreTokens;
            String firstText = newText[0];
            String extraText = new String();
            this.getLogAdd().addElement("/ADD TEXT AT LINE: " + lineNum + " POSITION: " + position + "/");
            this.getLogAdd().addElement(firstText);
            String origLine = !this.getAllLines().isEmpty() ? (String)this.getAllLines().elementAt(lineNum) : new String();
            boolean bl = moreTokens = newText.length > 1;
            if (position == 0) {
                if (moreTokens) {
                    newLine = firstText;
                    extraText = origLine;
                } else {
                    newLine = firstText.concat(origLine);
                }
            } else if (position >= origLine.length()) {
                newLine = origLine.concat(firstText);
            } else if (moreTokens) {
                newLine = origLine.substring(0, position) + firstText;
                extraText = origLine.substring(position);
            } else {
                newLine = origLine.substring(0, position) + firstText + origLine.substring(position);
            }
            this.getLogAdd().addElement(newLine);
            if (!this.getAllLines().isEmpty()) {
                this.getAllLines().setElementAt(newLine, lineNum);
            } else {
                this.getAllLines().addElement(newLine);
            }
            for (int i = 1; i < newText.length; ++i) {
                String tok = newText[i];
                if (i + 1 == newText.length) {
                    tok = tok.concat(extraText);
                }
                this.getLogAdd().addElement(tok);
                this.getAllLines().insertElementAt(tok, ++lineNum);
            }
        }
    }

    public void deleteLine() {
        SearchResult[] searchResults = this.getASCIISearchResults();
        if (searchResults != null) {
            for (int i = searchResults.length - 1; i >= 0; --i) {
                int lineNum = searchResults[i].getLineNum();
                if (lineNum >= this.getAllLines().size()) continue;
                this.getLogAdd().addElement("/DELETE LINE: " + lineNum + "/");
                this.getLogAdd().addElement(this.getAllLines().elementAt(lineNum));
                this.getAllLines().removeElementAt(lineNum);
            }
        }
    }

    public boolean deleteText(String delText) {
        SearchResult[] searchResults = this.getASCIISearchResults();
        boolean modified = false;
        if (searchResults != null) {
            for (int i = 0; i < searchResults.length; ++i) {
                this.getLogAdd().addElement("/DELETE TEXT/");
                int lineNum = searchResults[i].getLineNum();
                int position = searchResults[i].getPosition();
                String origLine = (String)this.getAllLines().elementAt(lineNum);
                int delPosition = origLine.indexOf(delText, position);
                if (delPosition == -1) {
                    this.getLogAdd().addElement("Could not find text: " + delText + " on line: " + lineNum + " after position: " + position);
                    continue;
                }
                String newLine = delPosition > 0 ? origLine.substring(0, delPosition) : new String();
                if (delPosition + delText.length() < origLine.length()) {
                    newLine = newLine.concat(origLine.substring(delPosition + delText.length()));
                }
                this.getLogAdd().addElement("Deleted text: " + delText + " on line: " + lineNum + " at position: " + delPosition);
                this.getAllLines().setElementAt(newLine, lineNum);
                modified = true;
            }
        }
        return modified;
    }

    public void deleteLinesBetween(int firstLineNum, int lastLineNum) {
        int realLastLineNum;
        int realFirstLineNum;
        if (this.getIncludeSearchLines()) {
            realFirstLineNum = firstLineNum;
            realLastLineNum = lastLineNum;
        } else {
            realFirstLineNum = firstLineNum + 1;
            realLastLineNum = lastLineNum - 1;
        }
        if (realLastLineNum >= realFirstLineNum) {
            this.getLogAdd().addElement("/DELETE LINES BETWEEN LINE: " + realFirstLineNum + " AND LINE: " + realLastLineNum + "/");
            for (int i = realFirstLineNum; i <= realLastLineNum; ++i) {
                this.getLogAdd().addElement(this.getAllLines().elementAt(realFirstLineNum));
                this.getAllLines().removeElementAt(realFirstLineNum);
            }
        }
    }

    public void replaceLine(String[] newLines) {
        SearchResult[] searchResults = this.getASCIISearchResults();
        if (searchResults != null) {
            for (int i = searchResults.length - 1; i >= 0; --i) {
                int lineNum = searchResults[i].getLineNum();
                this.replaceLineAt(newLines, lineNum);
            }
        }
    }

    public void replaceLineAt(String[] newLines, int lineNum) {
        if (newLines.length > 0) {
            this.getLogAdd().addElement("/REPLACE LINE: " + lineNum + "/");
            if (this.getAllLines().size() > 0) {
                this.getAllLines().removeElementAt(lineNum);
            }
            for (int i = 0; i < newLines.length; ++i) {
                this.getLogAdd().addElement(newLines[i]);
                this.getAllLines().insertElementAt(newLines[i], lineNum++);
            }
        }
    }

    public boolean replaceText(String oldLine, String[] newLines) {
        boolean modified = false;
        if (newLines.length > 0) {
            SearchResult[] searchResults = this.getASCIISearchResults();
            String firstToken = newLines[0];
            if (searchResults != null) {
                for (int i = searchResults.length - 1; i >= 0; --i) {
                    int lineNum = searchResults[i].getLineNum();
                    int position = searchResults[i].getPosition();
                    String origLine = this.getAllLines().size() > 0 ? (String)this.getAllLines().elementAt(lineNum) : "";
                    this.getLogAdd().addElement("/REPLACE TEXT: " + oldLine + " ON LINE: " + lineNum + "/");
                    int replacePosition = origLine.indexOf(oldLine, position);
                    if (replacePosition != -1) {
                        String newLine;
                        if (newLines.length == 1) {
                            newLine = replacePosition == 0 ? firstToken.concat(origLine.substring(oldLine.length())) : (replacePosition + oldLine.length() >= origLine.length() ? origLine.substring(0, replacePosition).concat(firstToken) : origLine.substring(0, replacePosition) + firstToken + origLine.substring(replacePosition + oldLine.length()));
                            this.getLogAdd().addElement(newLine);
                            this.getAllLines().setElementAt(newLine, lineNum);
                        } else {
                            String lastLine = null;
                            String lastTok = newLines[newLines.length - 1];
                            if (replacePosition == 0) {
                                newLine = firstToken;
                                lastLine = origLine.substring(oldLine.length()).concat(lastTok);
                            } else if (replacePosition + oldLine.length() >= origLine.length()) {
                                newLine = origLine.substring(0, replacePosition).concat(firstToken);
                                lastLine = lastTok;
                            } else {
                                newLine = origLine.substring(0, replacePosition) + firstToken;
                                lastLine = origLine.substring(replacePosition + oldLine.length()).concat(lastTok);
                            }
                            this.getLogAdd().addElement(newLine);
                            this.getAllLines().setElementAt(newLine, lineNum++);
                            for (int j = 1; j < newLines.length - 1; ++j) {
                                this.getLogAdd().addElement(newLines[j]);
                                this.getAllLines().insertElementAt(newLines[j], lineNum++);
                            }
                            if (lastLine != null) {
                                this.getLogAdd().addElement(lastLine);
                                this.getAllLines().insertElementAt(lastLine, lineNum);
                            }
                        }
                        modified = true;
                        continue;
                    }
                    this.getLogAdd().addElement("Could not find text: " + oldLine + " after position: " + position + ".");
                }
            }
        }
        return modified;
    }

    public boolean setVariable(String varName, String varValue, String separator) {
        boolean modified = false;
        if (separator == null || separator.length() == 0) {
            try {
                separator = this.fileService.getPathSeparator();
            }
            catch (ServiceException se) {
                this.support.logEvent(this, "err", se);
            }
        }
        Vector<String> myMatch = new Vector<String>();
        StringTokenizer varNameTokens = new StringTokenizer(varName);
        while (varNameTokens.hasMoreTokens()) {
            myMatch.addElement(varNameTokens.nextToken());
        }
        myMatch.addElement("=");
        this.setMatch(myMatch);
        this.setOccurrenceFrequency(1);
        this.setReturnPosition(3);
        this.setTokensNotFound(2);
        this.setIgnoreCommentLines(true);
        this.searchStringsOnlyWhtSpc();
        SearchResult[] searchResults = this.getASCIISearchResults();
        if (searchResults != null && searchResults.length > 0) {
            StringTokenizer newTokens;
            String locationString;
            int lineNum = searchResults[0].getLineNum();
            int position = searchResults[0].getPosition();
            String origLine = (String)this.getAllLines().elementAt(lineNum);
            String newLine = null;
            String newVarValue = varValue.trim();
            boolean moreSemis = true;
            if (this.getLocation() != 2) {
                while (moreSemis) {
                    moreSemis = false;
                    if (newVarValue.startsWith(separator)) {
                        newVarValue = newVarValue.substring(1);
                        moreSemis = true;
                    }
                    if (!newVarValue.endsWith(separator)) continue;
                    newVarValue = newVarValue.substring(0, newVarValue.length() - 1);
                    moreSemis = true;
                }
            }
            String actionString = " TO: ";
            if (this.getLocation() == 1) {
                locationString = "Prepend ";
            } else if (this.getLocation() == 0) {
                locationString = "Append ";
            } else if (this.getLocation() == 2) {
                locationString = "Replace ";
            } else {
                actionString = " FROM: ";
                locationString = "Delete ";
            }
            this.getLogAdd().addElement("/SET VARIABLE: " + locationString + newVarValue + actionString + varName + "/");
            boolean alreadySet = false;
            if (this.getLocation() == 2) {
                if (newVarValue.equals(origLine.substring(position))) {
                    alreadySet = true;
                }
            } else if (this.getLocation() == 3) {
                newTokens = new StringTokenizer(origLine.substring(position), separator);
                boolean found = false;
                while (newTokens.hasMoreTokens() && !found) {
                    String tok = newTokens.nextToken();
                    if ((!this.getCaseSensitive() || !tok.trim().equals(newVarValue)) && (this.getCaseSensitive() || !tok.trim().equalsIgnoreCase(newVarValue))) continue;
                    found = true;
                }
                alreadySet = !found;
            } else {
                newTokens = new StringTokenizer(origLine.substring(position), separator);
                while (newTokens.hasMoreTokens() && !alreadySet) {
                    String tok = newTokens.nextToken();
                    if ((!this.getCaseSensitive() || !tok.trim().equals(newVarValue)) && (this.getCaseSensitive() || !tok.trim().equalsIgnoreCase(newVarValue))) continue;
                    alreadySet = true;
                }
            }
            if (alreadySet) {
                this.getLogAdd().addElement("Variable is already set.");
            } else {
                if (this.getLocation() == 1) {
                    newLine = origLine.substring(position).trim().length() == 0 || origLine.substring(position).trim().startsWith(separator) ? origLine.substring(0, position) + newVarValue + origLine.substring(position).trim() : origLine.substring(0, position) + newVarValue + separator + origLine.substring(position).trim();
                } else if (this.getLocation() == 0) {
                    newLine = origLine.substring(position).trim().length() == 0 || origLine.trim().endsWith(separator) ? origLine.trim() + newVarValue : origLine.trim() + separator + newVarValue;
                } else if (this.getLocation() == 2) {
                    newLine = origLine.substring(0, position) + newVarValue;
                } else {
                    newLine = origLine.substring(0, position);
                    newTokens = new StringTokenizer(origLine.substring(position), separator);
                    while (newTokens.hasMoreTokens()) {
                        String tok = newTokens.nextToken();
                        if (this.getCaseSensitive() && tok.trim().equals(newVarValue) || !this.getCaseSensitive() && tok.trim().equalsIgnoreCase(newVarValue)) continue;
                        newLine = newLine.concat(tok + separator);
                    }
                }
                modified = true;
                this.getAllLines().setElementAt(newLine, lineNum);
            }
        } else {
            this.getLogAdd().addElement("/SET VARIABLE: " + varName + "=" + varValue.trim() + "/");
            this.getAllLines().addElement(varName + "=" + varValue.trim());
            modified = true;
        }
        return modified;
    }

    public void logChanges() {
        Enumeration logAddEnum = this.getLogAdd().elements();
        while (logAddEnum.hasMoreElements()) {
            this.support.logEvent(this, "msg2", logAddEnum.nextElement());
        }
    }
}

