/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;

public class ReplaceLine
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private int replaceOption = 1;
    private String oldLine = new String();
    private String[] newLines = new String[0];
    public static final String TYPE_DESCRIPTION = "Replace Line/Text";
    public static final int LINE = 0;
    public static final int TEXT = 1;

    public void setReplaceOption(int replaceOption) {
        this.replaceOption = replaceOption;
    }

    public int getReplaceOption() {
        return this.replaceOption;
    }

    public void setOldLine(String oldLine) {
        this.oldLine = oldLine;
    }

    public String getOldLine() {
        return this.oldLine;
    }

    public void setNewLines(String[] newLines) {
        this.newLines = newLines;
    }

    public String[] getNewLines() {
        return this.newLines;
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public String getShortDescription() {
        String optionText = new String();
        optionText = this.getReplaceOption() == 1 ? "Replace Old Text: " + this.getOldLine() + " with New Text: " : "Replace Old Line with New Line(s): ";
        return optionText.concat(this.formatNewLines());
    }

    private String formatNewLines() {
        String s;
        String[] value = this.getNewLines();
        if (value == null || value.length <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int charsLeft = 30;
        for (int i = 0; charsLeft > 0 && i < value.length; charsLeft -= s.length(), ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if ((s = value[i]).length() > charsLeft) {
                buf.append(s.substring(0, charsLeft) + "...");
                continue;
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public void verify(AsciiFileUpdateSupport support) {
        if (this.getNewLines() == null || this.getNewLines().length == 0 || this.getNewLines().length == 1 && this.getNewLines()[0].length() == 0) {
            support.logEvent(this, "wrn", "Replace Line/Text requires New Line(s).");
        }
        if (this.getReplaceOption() == 1 && (this.getOldLine() == null || this.getOldLine().length() == 0)) {
            support.logEvent(this, "wrn", "Replace Line/Text requires Old Line if replacing Text.");
        }
    }

    public boolean execute(ModifyFile modify) {
        boolean modified = false;
        if (this.getNewLines() == null || this.getNewLines().length == 0 || this.getNewLines().length == 1 && this.getNewLines()[0].length() == 0) {
            modify.getLogAdd().addElement("Replace Line/Text requires New Line(s).");
        } else if (this.getReplaceOption() == 1 && (this.getOldLine() == null || this.getOldLine().length() == 0)) {
            modify.getLogAdd().addElement("Replace Line/Text requires Old Lines if replacing Text.");
        } else if (modify.getASCIISearchResults() != null && modify.getASCIISearchResults().length > 0) {
            String[] resolvedNewLines = new String[this.getNewLines().length];
            for (int i = 0; i < this.getNewLines().length; ++i) {
                resolvedNewLines[i] = modify.resolveString(this.getNewLines()[i]);
            }
            if (this.getReplaceOption() == 1) {
                modified = modify.replaceText(modify.resolveString(this.getOldLine()), resolvedNewLines);
            } else {
                modify.replaceLine(resolvedNewLines);
                modified = true;
            }
            modify.setASCIISearchResults(null);
        }
        return modified;
    }

    public Object clone() {
        ReplaceLine ret = (ReplaceLine)super.clone();
        ret.replaceOption = this.replaceOption;
        ret.oldLine = this.oldLine;
        ret.newLines = this.newLines;
        return ret;
    }
}

