/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;
import java.util.Vector;

public class SearchLine
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private String[] tokens = new String[0];
    private boolean respectCase = false;
    private int occurrenceFrequency = 0;
    private int returnPosition = 0;
    private int tokensNotFound = 2;
    private boolean ignoreCommentLines = true;
    public static final String TYPE_DESCRIPTION = "Search Line/Text";

    public void setTokens(String[] tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException("tokens cannot be null");
        }
        this.tokens = tokens;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public void setRespectCase(boolean respectCase) {
        this.respectCase = respectCase;
    }

    public boolean getRespectCase() {
        return this.respectCase;
    }

    public void setOccurrenceFrequency(int occurrenceFrequency) {
        this.occurrenceFrequency = occurrenceFrequency;
    }

    public int getOccurrenceFrequency() {
        return this.occurrenceFrequency;
    }

    public void setReturnPosition(int returnPosition) {
        this.returnPosition = returnPosition;
    }

    public int getReturnPosition() {
        return this.returnPosition;
    }

    public void setTokensNotFound(int tokensNotFound) {
        this.tokensNotFound = tokensNotFound;
    }

    public int getTokensNotFound() {
        return this.tokensNotFound;
    }

    public void setIgnoreCommentLines(boolean ignoreCommentLines) {
        this.ignoreCommentLines = ignoreCommentLines;
    }

    public boolean getIgnoreCommentLines() {
        return this.ignoreCommentLines;
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    private String formatTokens() {
        String s;
        String[] value = this.getTokens();
        if (value == null || value.length <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int charsLeft = 30;
        for (int i = 0; charsLeft > 0 && i < value.length; charsLeft -= s.length(), ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if ((s = value[i]).length() > charsLeft) {
                buf.append(s.substring(0, charsLeft) + "...");
                continue;
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public String getShortDescription() {
        return "Search for: " + this.formatTokens();
    }

    private boolean validTokens() {
        for (int i = 0; i < this.getTokens().length; ++i) {
            if (this.getTokens()[i] == null || this.getTokens()[i].length() <= 0) continue;
            return true;
        }
        return false;
    }

    private Vector getResolvedTokens(ModifyFile modify) {
        Vector<String> resolvedTokens = new Vector<String>();
        for (int i = 0; i < this.getTokens().length; ++i) {
            if (this.getTokens()[i] == null || this.getTokens()[i].length() <= 0) continue;
            resolvedTokens.addElement(modify.resolveString(this.getTokens()[i]));
        }
        return resolvedTokens;
    }

    public void verify(AsciiFileUpdateSupport support) {
        if (this.getTokens() == null || !this.validTokens()) {
            support.logEvent(this, "wrn", "Search Line/Text requires Tokens contain at least one valid token.");
        }
    }

    public boolean execute(ModifyFile modify) {
        if (this.getTokens() == null || !this.validTokens()) {
            modify.getLogAdd().addElement("Search Line/Text requires Tokens contain at least one valid token.");
        } else {
            modify.setMatch(this.getResolvedTokens(modify));
            modify.setCaseSensitive(this.getRespectCase());
            modify.setOccurrenceFrequency(this.getOccurrenceFrequency());
            modify.setReturnPosition(this.getReturnPosition());
            modify.setTokensNotFound(this.getTokensNotFound());
            modify.setIgnoreCommentLines(this.getIgnoreCommentLines());
            modify.searchMultipleStrings();
        }
        return false;
    }

    public Object clone() {
        SearchLine ret = (SearchLine)super.clone();
        ret.tokens = this.tokens;
        ret.respectCase = this.respectCase;
        ret.occurrenceFrequency = this.occurrenceFrequency;
        ret.returnPosition = this.returnPosition;
        ret.tokensNotFound = this.tokensNotFound;
        ret.ignoreCommentLines = this.ignoreCommentLines;
        return ret;
    }
}

