/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;

public class SetVariable
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private String variableName = new String();
    private String variableValue = new String();
    private int location = 0;
    private String separator = new String();
    private boolean respectCase = false;
    public static final String TYPE_DESCRIPTION = "Set Variable";

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    public void setVariableValue(String variableValue) {
        this.variableValue = variableValue;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public void setRespectCase(boolean respectCase) {
        this.respectCase = respectCase;
    }

    public boolean getRespectCase() {
        return this.respectCase;
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public String getShortDescription() {
        String locationText = new String();
        String actionText = "\" to variable: ";
        if (this.getLocation() == 0) {
            locationText = "Append \"";
        } else if (this.getLocation() == 1) {
            locationText = "Prepend \"";
        } else if (this.getLocation() == 2) {
            locationText = "Replace \"";
        } else {
            locationText = "Delete \"";
            actionText = "\" from variable: ";
        }
        return locationText + this.getVariableValue() + actionText + this.getVariableName();
    }

    public void verify(AsciiFileUpdateSupport support) {
        if (this.getVariableName() == null || this.getVariableName().length() == 0) {
            support.logEvent(this, "wrn", "Set Variable requires Variable Name.");
        }
        if (this.getVariableValue() == null || this.getVariableValue().length() == 0) {
            support.logEvent(this, "wrn", "Set Variable requires Variable Value.");
        }
    }

    public boolean execute(ModifyFile modify) {
        boolean modified = false;
        if (this.getVariableName() == null || this.getVariableName().length() == 0) {
            modify.getLogAdd().addElement("Set Variable requires Variable Name.");
        } else if (this.getVariableValue() == null || this.getVariableValue().length() == 0) {
            modify.getLogAdd().addElement("Set Variable requires Variable Value.");
        } else {
            modify.setLocation(this.getLocation());
            modify.setCaseSensitive(this.getRespectCase());
            modified = modify.setVariable(modify.resolveString(this.getVariableName()), modify.resolveString(this.getVariableValue()), modify.resolveString(this.getSeparator()));
            modify.setASCIISearchResults(null);
        }
        return modified;
    }

    public Object clone() {
        SetVariable ret = (SetVariable)super.clone();
        ret.variableName = this.variableName;
        ret.variableValue = this.variableValue;
        ret.location = this.location;
        return ret;
    }
}

