/*
 * Decompiled with CFR 0.152.
 */
package com.jxml.protocol.classpath;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class ClassPathURLConnection
extends URLConnection {
    protected static boolean doOutputDefault;

    public ClassPathURLConnection(URL url) {
        super(url);
        this.doInput = true;
        this.doOutput = doOutputDefault;
    }

    public void connect() {
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        String name = this.url.getFile().substring(1);
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResourceAsStream(name);
    }

    public OutputStream getOutputStream() throws IOException {
        String dirName;
        File dir;
        String name = this.url.getFile().substring(1);
        File file = new File(name);
        int i = name.lastIndexOf("/");
        if (i > -1 && !(dir = new File(dirName = name.substring(0, i))).exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create new directory in current working directory: " + dirName);
        }
        return new FileOutputStream(file);
    }

    static {
        String classpath = System.getProperty("java.class.path");
        if (".".equals(classpath)) {
            doOutputDefault = true;
        } else {
            String desired = "." + System.getProperty("path.separator");
            String prefix = classpath.substring(0, desired.length());
            doOutputDefault = desired.equals(prefix);
        }
    }
}

