/*
 * Decompiled with CFR 0.152.
 */
package com.jxml.quick;

import com.jxml.quick.QContext;
import com.jxml.quick.engine.QContextImpl;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class QConvert
implements DocumentHandler {
    public static final String ATTRIBUTES = "_attributes";
    public QContext context;
    private Vector atts = new Vector();
    private StringBuffer text = new StringBuffer();
    private boolean ignoreText = false;

    public QConvert() {
        this.context = new QContextImpl();
    }

    public QConvert(QContext context) {
        this.context = context;
    }

    public void setDocumentLocator(Locator locator) {
        this.context.locator = locator;
    }

    public void startDocument() throws SAXException {
        try {
            this.context.startDocument();
        }
        catch (RuntimeException re) {
            this.context.throwPE(re);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.context.endDocument();
        }
        catch (RuntimeException re) {
            this.context.throwPE(re);
        }
    }

    public void startElement(String name, AttributeList attList) throws SAXException {
        try {
            Att att;
            int i;
            this.context.startElement(name);
            int len = attList.getLength();
            this.context.startElement(ATTRIBUTES);
            for (i = 0; i < len; ++i) {
                if (this.atts.size() == i) {
                    this.atts.addElement(new Att());
                }
                att = (Att)this.atts.elementAt(i);
                att.name = attList.getName(i);
                att.value = attList.getValue(i);
            }
            for (i = 0; i < len; ++i) {
                att = (Att)this.atts.elementAt(i);
                for (int k = i + 1; k < len; ++k) {
                    Att a = (Att)this.atts.elementAt(k);
                    if (att.name.compareTo(a.name) <= 0) continue;
                    this.atts.setElementAt(att, k);
                    att = a;
                }
                this.atts.setElementAt(att, i);
                this.context.startElement(att.name);
                this.context.endElement(att.name, att.value);
            }
            this.context.endElement(ATTRIBUTES, "");
            this.text.setLength(0);
            this.ignoreText = false;
        }
        catch (RuntimeException re) {
            this.context.throwPE(re);
        }
    }

    public void endElement(String name) throws SAXException {
        try {
            if (this.ignoreText) {
                this.context.endElement(name, "");
            } else {
                this.context.endElement(name, this.text.toString());
            }
            this.ignoreText = true;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.context.throwPE(re);
        }
    }

    public void ignorableWhitespace(char[] chars, int offset, int len) throws SAXException {
        this.characters(chars, offset, len);
    }

    public void characters(char[] chars, int offset, int len) throws SAXException {
        if (this.ignoreText) {
            return;
        }
        this.text.append(chars, offset, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public class Att {
        public String name;
        public String value;
    }
}

