/*
 * Decompiled with CFR 0.152.
 */
package com.jxml.quick;

import com.jxml.quick.QContext;
import com.jxml.quick.QConvert;
import com.jxml.quick.QConverter;
import com.jxml.quick.QDoc;
import com.jxml.quick.QExpressFactory;
import com.jxml.quick.QTraceFactory;
import com.jxml.quick.engine.QCMLBindings;
import java.io.IOException;
import java.io.StringReader;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class Quick {
    public static Object getRoot(QDoc doc) {
        return doc.getRoot();
    }

    public static QDoc createDoc(Object root) {
        return QCMLBindings.createDoc(root);
    }

    public static String getId(QDoc doc, Object value) throws SAXException {
        return doc.getId(value);
    }

    public static void setId(QDoc doc, String id2, Object value) throws SAXException {
        doc.setId(id2, value);
    }

    public static QContext createContext(QDoc doc) throws SAXException {
        return QCMLBindings.createContext(doc);
    }

    public static String express(QDoc doc, QContext context) throws SAXException {
        QContext expressContext = new QExpressFactory().createContext();
        QDoc expressDoc = Quick.transcribe(doc, context, expressContext);
        return (String)Quick.getRoot(expressDoc);
    }

    public static QContext createTraceContext(QDoc doc) throws SAXException {
        return QTraceFactory.debug(doc);
    }

    public static QDoc transcribe(QDoc doc, QContext source, QContext destination) throws SAXException {
        source.walk(doc, destination);
        return destination.doc;
    }

    public static QDoc convert(QDoc doc, QContext destination) throws SAXException {
        QConvert convert = new QConvert(destination);
        ((QConverter)Quick.getRoot(doc)).eval(convert);
        return destination.doc;
    }

    public static QDoc parse(Parser parser, QContext context, String url) throws IOException, SAXException {
        QConvert convert = new QConvert(context);
        parser.setDocumentHandler(convert);
        parser.parse(url);
        return context.doc;
    }

    public static QDoc parse(Parser parser, QContext context, InputSource is) throws IOException, SAXException {
        QConvert convert = new QConvert(context);
        parser.setDocumentHandler(convert);
        parser.parse(is);
        return context.doc;
    }

    public static QDoc parseString(Parser parser, QContext context, String document) throws IOException, SAXException {
        StringReader sr = new StringReader(document);
        InputSource is = new InputSource(sr);
        return Quick.parse(parser, context, is);
    }

    public static QDoc parseSchema(Parser parser, String url) throws IOException, SAXException {
        return Quick.parseSchema(parser, false, url);
    }

    public static QDoc parseSchema(Parser parser, boolean debug, String url) throws IOException, SAXException {
        return QCMLBindings.parseSchema(parser, debug, url);
    }

    public static QDoc parseSchema(Parser parser, InputSource is) throws IOException, SAXException {
        return Quick.parseSchema(parser, is);
    }

    public static QDoc parseSchema(Parser parser, boolean debug, InputSource is) throws IOException, SAXException {
        return QCMLBindings.parseSchema(parser, debug, is);
    }

    public static QDoc parseSchemaString(Parser parser, boolean debug, String schema) throws IOException, SAXException {
        return QCMLBindings.parseSchemaString(parser, debug, schema);
    }
}

