/*
 * Decompiled with CFR 0.152.
 */
package com.jxml.quick.access;

import com.jxml.quick.QContext;
import com.jxml.quick.QPE;
import com.jxml.quick.access.QAccess;
import com.jxml.quick.access.QIterator;
import com.jxml.quick.access.QListPropertyAccess;
import com.jxml.quick.access.QSimpleIterator;
import com.jxml.quick.tf.QTargetFactory;
import java.lang.reflect.Field;

public class QFieldAccess
extends QAccess {
    public String field;
    protected Field pd = null;

    protected void setPD(QTargetFactory tf, QContext context) throws QPE {
        if (this.pd != null) {
            return;
        }
        Field[] pds = tf.getFields(context);
        if (pds == null) {
            context.throwPE(this.field + ": No Fields Available: " + tf.getClass().getName());
        }
        int s = pds.length;
        for (int i = 0; i < s; ++i) {
            if (!this.field.equals(pds[i].getName())) continue;
            this.pd = pds[i];
            this.validateField(this.pd, context);
            return;
        }
        context.throwPE("Invalid field: " + this.field);
    }

    protected void validateField(Field pd, QContext context) throws QPE {
        if (QListPropertyAccess.listClass.isAssignableFrom(pd.getType())) {
            context.throwPE("Must not be a list: " + pd.getName());
        }
    }

    public boolean readable(QTargetFactory parentFactory, QContext context) throws QPE {
        return true;
    }

    public QIterator createIterator() {
        return new QSimpleIterator();
    }

    protected Object get(Object parent, QContext context) throws QPE {
        try {
            return this.pd.get(parent);
        }
        catch (Exception e) {
            context.throwPE(e.toString());
            return null;
        }
    }

    public void setIteratorParent(QIterator it, Object parent, QTargetFactory parentFactory, QContext context) throws QPE {
        this.setPD(parentFactory, context);
        ((QSimpleIterator)it).setCurrent(this.get(parent, context));
    }

    public boolean writeable(QTargetFactory parentFactory, QContext context) throws QPE {
        return true;
    }

    public void add(Object parent, QTargetFactory parentFactory, Object child, QContext context) throws QPE {
        this.setPD(parentFactory, context);
        try {
            this.pd.set(parent, child);
        }
        catch (Exception e) {
            context.throwPE(e.toString());
        }
    }
}

