/*
 * Decompiled with CFR 0.152.
 */
package com.jxml.quick.access;

import com.jxml.quick.QContext;
import com.jxml.quick.QPE;
import com.jxml.quick.access.QAccess;
import com.jxml.quick.access.QIterator;
import com.jxml.quick.access.QSimpleIterator;
import com.jxml.quick.tf.QTargetFactory;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;

public class QPropertyAccess
extends QAccess {
    public String property;
    protected PropertyDescriptor pd = null;

    protected void setPD(QTargetFactory tf, QContext context) throws QPE {
        if (this.pd != null) {
            return;
        }
        PropertyDescriptor[] pds = tf.getPropertyDescriptors(context);
        if (pds == null) {
            context.throwPE("No PropertyDescriptors Available: " + tf.getClass().getName());
        }
        int s = pds.length;
        for (int i = 0; i < s; ++i) {
            if (!this.property.equals(pds[i].getName()) || pds[i] instanceof IndexedPropertyDescriptor || !this.validProperty(pds[i])) continue;
            this.pd = pds[i];
            return;
        }
        context.throwPE("Invalid property: " + this.property);
    }

    protected boolean validProperty(PropertyDescriptor pd) {
        Class<?> propertyType = pd.getPropertyType();
        return propertyType != null;
    }

    public boolean readable(QTargetFactory parentFactory, QContext context) throws QPE {
        this.setPD(parentFactory, context);
        return this.pd.getReadMethod() != null;
    }

    public QIterator createIterator() {
        return new QSimpleIterator();
    }

    protected Object get(Object parent, QContext context) throws QPE {
        Object[] sargs = new Object[]{};
        try {
            return this.pd.getReadMethod().invoke(parent, sargs);
        }
        catch (Exception e) {
            context.throwPE(e.toString());
            return null;
        }
    }

    public void setIteratorParent(QIterator it, Object parent, QTargetFactory parentFactory, QContext context) throws QPE {
        this.setPD(parentFactory, context);
        ((QSimpleIterator)it).setCurrent(this.get(parent, context));
    }

    public boolean writeable(QTargetFactory parentFactory, QContext context) throws QPE {
        this.setPD(parentFactory, context);
        return this.pd.getWriteMethod() != null;
    }

    public void add(Object parent, QTargetFactory parentFactory, Object child, QContext context) throws QPE {
        this.setPD(parentFactory, context);
        Object[] sargs = new Object[]{child};
        try {
            if (this.pd.getWriteMethod() != null) {
                this.pd.getWriteMethod().invoke(parent, sargs);
            }
        }
        catch (Exception e) {
            context.throwPE(e.toString());
        }
    }
}

