/*
 * Decompiled with CFR 0.152.
 */
package com.jxml.quick.cvt;

import com.jxml.quick.QPE;
import com.jxml.quick.cvt.CAccess;
import com.jxml.quick.cvt.CAccessClass;
import com.jxml.quick.cvt.CAware;
import com.jxml.quick.cvt.CTarget;
import com.jxml.quick.cvt.CTargetEditor;
import com.jxml.quick.cvt.CTargetFactory;
import java.util.Vector;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class CAttribute
extends CAware {
    public String name = "";
    public CTarget target = null;
    public CAccess access = null;
    public String value = "";
    public String status = "";
    public String type = "";
    public Vector values = new Vector();

    public void validate() throws QPE {
        if ("FIXED".equals(this.status) && "".equals(this.value)) {
            this.throwPE("value required when status is FIXED");
        }
        if (this.access != null) {
            if ("id".equals(this.type)) {
                this.throwPE("no access allowed when type is id");
            }
        } else if (!"id".equals(this.type)) {
            this.throwPE("When type is not id, some form of access is required");
        }
        if (this.access != null) {
            this.access.validate();
        }
        if (this.target != null) {
            if (!("EMPTY".equals(this.type) || "PCDATA".equals(this.type) || "".equals(this.type))) {
                this.throwPE("type and target are in conflict");
            }
            if (this.values.size() == 0) {
                this.target.val();
            } else {
                this.target.val(this.values);
            }
        }
    }

    public void cvt(DocumentHandler destination) throws SAXException {
        AttributeListImpl al5 = new AttributeListImpl();
        if ("FIXED".equals(this.status)) {
            al5.addAttribute("fixed", "CDATA", "True");
        } else if (!"REQUIRED".equals(this.status)) {
            al5.addAttribute("optional", "CDATA", "True");
        }
        if ("#ANY".equals(this.name)) {
            al5.addAttribute("repeating", "CDATA", "True");
        }
        if (!"".equals(this.value)) {
            al5.addAttribute("default", "CDATA", this.value);
        }
        destination.startElement("childElement", al5);
        if (this.access != null) {
            this.access.cvt(destination);
        } else {
            new CAccessClass("com.jxml.quick.engine.QIdAccess").cvt(destination);
        }
        AttributeListImpl al1 = new AttributeListImpl();
        al1.addAttribute("tagName", "CDATA", this.name);
        if ("#ANY".equals(this.name)) {
            al1.addAttribute("wild", "CDATA", "True");
        }
        if ("idref".equals(this.type)) {
            al1.addAttribute("isIdRef", "CDATA", "True");
        }
        destination.startElement("elementDefinition", al1);
        if (this.target != null) {
            if (this.values.size() == 0) {
                this.target.cvt(destination);
            } else {
                this.target.cvt(destination, this.values);
            }
        } else if ("boolean".equals(this.type)) {
            CTargetEditor te = new CTargetEditor();
            te.target = "java.lang.Boolean";
            te.editor = "sun.beans.editors.BoolEditor";
            if (this.values.size() == 0) {
                te.cvt(destination);
            } else {
                te.cvt(destination, this.values);
            }
        } else if ("int".equals(this.type)) {
            CTargetEditor te = new CTargetEditor();
            te.target = "java.lang.Integer";
            te.editor = "sun.beans.editors.IntEditor";
            if (this.values.size() == 0) {
                te.cvt(destination);
            } else {
                te.cvt(destination, this.values);
            }
        } else if ("long".equals(this.type)) {
            CTargetEditor te = new CTargetEditor();
            te.target = "java.lang.Long";
            te.editor = "sun.beans.editors.LongEditor";
            if (this.values.size() == 0) {
                te.cvt(destination);
            } else {
                te.cvt(destination, this.values);
            }
        } else if ("short".equals(this.type)) {
            CTargetEditor te = new CTargetEditor();
            te.target = "java.lang.Short";
            te.editor = "sun.beans.editors.ShortEditor";
            if (this.values.size() == 0) {
                te.cvt(destination);
            } else {
                te.cvt(destination, this.values);
            }
        } else if ("float".equals(this.type)) {
            CTargetEditor te = new CTargetEditor();
            te.target = "java.lang.Float";
            te.editor = "sun.beans.editors.FloatEditor";
            if (this.values.size() == 0) {
                te.cvt(destination);
            } else {
                te.cvt(destination, this.values);
            }
        } else if ("byte".equals(this.type)) {
            CTargetEditor te = new CTargetEditor();
            te.target = "java.lang.Byte";
            te.editor = "sun.beans.editors.ByteEditor";
            if (this.values.size() == 0) {
                te.cvt(destination);
            } else {
                te.cvt(destination, this.values);
            }
        } else if ("double".equals(this.type)) {
            CTargetEditor te = new CTargetEditor();
            te.target = "java.lang.Double";
            te.editor = "sun.beans.editors.DoubleEditor";
            if (this.values.size() == 0) {
                te.cvt(destination);
            } else {
                te.cvt(destination, this.values);
            }
        } else if (this.values.size() == 0) {
            CTargetFactory tf = new CTargetFactory("com.jxml.quick.tf.QStringTF");
            tf.cvt(destination);
        } else {
            CTargetEditor te = new CTargetEditor();
            te.target = "java.lang.String";
            te.editor = "sun.beans.editors.StringEditor";
            te.cvt(destination, this.values);
        }
        destination.endElement("elementDefinition");
        destination.endElement("childElement");
    }
}

