/*
 * Decompiled with CFR 0.152.
 */
package com.jxml.quick.cvt;

import com.jxml.quick.QPE;
import com.jxml.quick.cvt.CAttribute;
import com.jxml.quick.cvt.CAware;
import com.jxml.quick.cvt.CContent;
import com.jxml.quick.cvt.CTarget;
import com.jxml.quick.cvt.CTargetEditor;
import com.jxml.quick.cvt.CTargetFactory;
import java.util.Vector;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class CElement
extends CAware {
    public Vector attributes = new Vector();
    public Vector items = new Vector();
    public String content = "";
    public String name = "";
    public boolean wild = false;
    public CTarget target = null;
    public boolean beenHere = false;

    public void val(Vector elements) throws QPE {
        int i;
        if (this.target == null && ("EMPTY".equals(this.content) || "".equals(this.content))) {
            this.throwPE("target is required when \"content\" is EMPTY or unspecified");
        }
        int s = this.items.size();
        int as = this.attributes.size();
        if (s > 0 && !"".equals(this.content) && !"BIMODAL".equals(this.content)) {
            this.throwPE("element content is not compatible with " + this.content);
        }
        if (!(as <= 0 || "".equals(this.content) || "EMPTY".equals(this.content) || "BIMODAL".equals(this.content))) {
            this.throwPE("no attributes permited with " + this.content);
        }
        if ("EMPTY".equals(this.content)) {
            if (s > 0) {
                this.throwPE("element may have no content when \"content\" is EMPTY");
            }
        } else if (s == 0 && "".equals(this.content)) {
            this.throwPE("content attribute is required when there is no element content");
        }
        if (this.target != null) {
            if ("".equals(this.content) || "BIMODAL".equals(this.content) || "EMPTY".equals(this.content)) {
                this.target.valNoData();
            } else if ("PCDATA".equals(this.content)) {
                this.target.val();
            } else {
                this.throwPE("target and content are in conflict");
            }
        }
        Vector sorted = this.sortAttributes(this.attributes);
        for (i = 0; i < sorted.size(); ++i) {
            ((CAttribute)sorted.elementAt(i)).validate();
        }
        s = this.items.size();
        for (i = 0; i < s; ++i) {
            ((CContent)this.items.elementAt(i)).val(elements, false);
        }
    }

    public void cvt(DocumentHandler destination, Vector elements) throws SAXException {
        int i;
        CTargetEditor te;
        this.beenHere = true;
        AttributeListImpl al1 = new AttributeListImpl();
        al1.addAttribute("ID", "CDATA", this.name);
        if (this.wild) {
            al1.addAttribute("wild", "CDATA", "True");
        }
        al1.addAttribute("tagName", "CDATA", this.name);
        destination.startElement("elementDefinition", al1);
        if (this.target != null) {
            if ("PCDATA".equals(this.content)) {
                this.target.cvt(destination);
            } else {
                this.target.cvtNoData(destination);
            }
        } else if ("boolean".equals(this.content)) {
            te = new CTargetEditor();
            te.target = "java.lang.Boolean";
            te.editor = "sun.beans.editors.BoolEditor";
            te.cvt(destination);
        } else if ("int".equals(this.content)) {
            te = new CTargetEditor();
            te.target = "java.lang.Integer";
            te.editor = "sun.beans.editors.IntEditor";
            te.cvt(destination);
        } else if ("long".equals(this.content)) {
            te = new CTargetEditor();
            te.target = "java.lang.Long";
            te.editor = "sun.beans.editors.LongEditor";
            te.cvt(destination);
        } else if ("short".equals(this.content)) {
            te = new CTargetEditor();
            te.target = "java.lang.Short";
            te.editor = "sun.beans.editors.ShortEditor";
            te.cvt(destination);
        } else if ("float".equals(this.content)) {
            te = new CTargetEditor();
            te.target = "java.lang.Float";
            te.editor = "sun.beans.editors.FloatEditor";
            te.cvt(destination);
        } else if ("byte".equals(this.content)) {
            te = new CTargetEditor();
            te.target = "java.lang.Byte";
            te.editor = "sun.beans.editors.ByteEditor";
            te.cvt(destination);
        } else if ("double".equals(this.content)) {
            te = new CTargetEditor();
            te.target = "java.lang.Double";
            te.editor = "sun.beans.editors.DoubleEditor";
            te.cvt(destination);
        } else {
            CTargetFactory tf = new CTargetFactory("com.jxml.quick.tf.QStringTF");
            tf.cvt(destination);
        }
        AttributeListImpl al2 = new AttributeListImpl();
        destination.startElement("childElement", al2);
        AttributeListImpl al3 = new AttributeListImpl();
        destination.startElement("accessClass", al3);
        String alac = "com.jxml.quick.access.QMALAccess";
        int l = alac.length();
        char[] c = new char[l];
        alac.getChars(0, l, c, 0);
        destination.characters(c, 0, l);
        destination.endElement("accessClass");
        AttributeListImpl al4 = new AttributeListImpl();
        al4.addAttribute("tagName", "CDATA", "_attributes");
        destination.startElement("elementDefinition", al4);
        new CTargetFactory("com.jxml.quick.tf.QMALTF").cvt(destination);
        Vector sorted = this.sortAttributes(this.attributes);
        for (i = 0; i < sorted.size(); ++i) {
            ((CAttribute)sorted.elementAt(i)).cvt(destination);
        }
        destination.endElement("elementDefinition");
        destination.endElement("childElement");
        int s = this.items.size();
        for (i = 0; i < s; ++i) {
            ((CContent)this.items.elementAt(i)).cvt(destination, elements, false);
        }
        destination.endElement("elementDefinition");
    }

    private Vector sortAttributes(Vector atts) {
        Vector list = new Vector(atts.size());
        for (int i = 0; i < atts.size(); ++i) {
            list.addElement(atts.elementAt(i));
        }
        CElement.qsort(list, 0, atts.size() - 1);
        return list;
    }

    private static void qsort(Vector atts, int low, int high) {
        if (high <= low) {
            return;
        }
        CAttribute pivot = (CAttribute)atts.elementAt(low);
        int i = low;
        int j = high + 1;
        while (j - i > 1) {
            while (i < j - 1 && pivot.name.compareTo(((CAttribute)atts.elementAt((int)(i + 1))).name) >= 0) {
                ++i;
            }
            while (j > i + 1 && pivot.name.compareTo(((CAttribute)atts.elementAt((int)(j - 1))).name) < 0) {
                --j;
            }
            if (j - i <= 1) continue;
            Object temp = atts.elementAt(j - 1);
            atts.setElementAt(atts.elementAt(i + 1), j - 1);
            atts.setElementAt(temp, i + 1);
            ++i;
            --j;
        }
        atts.setElementAt(atts.elementAt(i), low);
        atts.setElementAt(pivot, i);
        CElement.qsort(atts, low, i - 1);
        CElement.qsort(atts, j, high);
    }
}

