/*
 * Decompiled with CFR 0.152.
 */
package com.jxml.quick.engine;

import com.jxml.quick.QContext;
import com.jxml.quick.QDoc;
import com.jxml.quick.QPE;
import com.jxml.quick.access.QAccess;
import com.jxml.quick.engine.QElementFactory;
import com.jxml.quick.tf.QTargetFactory;
import java.util.Hashtable;
import java.util.Vector;

public final class QDocImpl
implements QDoc {
    QContext context = null;
    Object root = null;
    long walkCounter = 0L;
    Hashtable idMap = new Hashtable();
    Hashtable valueMap = new Hashtable();
    Mark lastMark = null;
    Object lastValue = null;
    Hashtable unresolved = new Hashtable();
    long gen;

    public QDocImpl() {
    }

    public QDocImpl(QContext context) {
        this.context = context;
    }

    void beginWalk() {
        ++this.walkCounter;
        this.gen = System.currentTimeMillis();
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object object) {
        this.root = object;
    }

    public void setId(String id2, Object value) throws QPE {
        Object dup;
        if ("".equals(id2)) {
            this.context.throwPE("ID may not be empty");
        }
        if ((dup = this.idMap.put(id2, value)) != null) {
            this.context.throwPE("duplicate ID: " + id2);
        }
        this.lastValue = value;
        this.lastMark = new Mark(id2);
        this.valueMap.put(value, this.lastMark);
        if (this.unresolved == null) {
            return;
        }
        Vector puts = (Vector)this.unresolved.remove(id2);
        if (puts == null) {
            return;
        }
        int s = puts.size();
        for (int i = 0; i < s; ++i) {
            Put put = (Put)puts.elementAt(i);
            put.add(id2, value, this.context);
        }
    }

    Mark getMark(Object value) {
        if (value == this.lastValue) {
            return this.lastMark;
        }
        this.lastMark = (Mark)this.valueMap.get(value);
        this.lastValue = value;
        return this.lastMark;
    }

    boolean isKnown(Object value) {
        return this.getMark(value) != null;
    }

    public String getId(Object value) throws QPE {
        if (this.isKnown(value)) {
            Mark m = this.getMark(value);
            return m.id;
        }
        String id2 = "genid_" + this.gen++;
        this.setId(id2, value);
        return id2;
    }

    boolean isMarked(Object value) {
        return this.getMark((Object)value).walkCount == this.walkCounter;
    }

    void mark(Object value) {
        this.getMark((Object)value).walkCount = this.walkCounter;
    }

    void resolve(String id2, QAccess access, Object parent, QTargetFactory parentFactory, QElementFactory.QElement element) throws QPE {
        Object child = this.idMap.get(id2);
        if (child != null) {
            if (element.matchClasses(child) == null) {
                this.context.throwPE("ref type mismatch: " + id2);
            }
            access.add(parent, parentFactory, child, this.context);
            return;
        }
        Put put = new Put(access, parent, parentFactory, element, this.context);
        Vector<Put> puts = (Vector<Put>)this.unresolved.get(id2);
        if (puts == null) {
            puts = new Vector<Put>();
            this.unresolved.put(id2, puts);
        }
        puts.addElement(put);
    }

    void end() throws QPE {
        if (this.unresolved.size() > 0) {
            this.context.throwPE("Unresolved idref: " + this.unresolved.keys().nextElement());
        }
        this.context = null;
        this.unresolved = null;
    }

    public static class Mark {
        String id;
        long walkCount = 0L;

        public Mark(String id2) {
            this.id = id2;
        }
    }

    static final class Put {
        QAccess access;
        Object parent;
        QTargetFactory parentFactory;
        QElementFactory.QElement element;
        int reserved;

        Put(QAccess access, Object parent, QTargetFactory parentFactory, QElementFactory.QElement element, QContext context) throws QPE {
            this.access = access;
            this.parent = parent;
            this.parentFactory = parentFactory;
            this.element = element;
            this.reserved = access.reserve(parent, context);
        }

        void add(String id2, Object child, QContext context) throws QPE {
            if (this.element.matchClasses(child) == null) {
                context.throwPE("ref type mismatch: " + id2);
            }
            this.access.set(this.reserved, this.parent, this.parentFactory, child, context);
        }
    }
}

