/*
 * Decompiled with CFR 0.152.
 */
package com.jxml.quick.tf;

import com.installshield.beans.ISIntrospector;
import com.jxml.quick.QAware;
import com.jxml.quick.QBiModal;
import com.jxml.quick.QContext;
import com.jxml.quick.QName;
import com.jxml.quick.QPE;
import com.jxml.quick.access.QAccess;
import com.jxml.quick.tf.QTargetFactory;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;

public class QClassWrapper
implements QTargetFactory {
    public Class wClass = null;
    public String wClassName = "";
    public PropertyDescriptor[] properties = null;
    public Field[] fields = null;
    public boolean isAware = false;
    public boolean isQName = false;
    public boolean isBiModal = false;
    public static Class aware;
    public static Class qname;
    public static Class bimodal;

    public void makeClass(QContext context) throws QPE {
        if (this.wClass != null) {
            return;
        }
        this.wClass = context.forName(this.wClassName);
        this.isAware = aware.isAssignableFrom(this.wClass);
        this.isQName = qname.isAssignableFrom(this.wClass);
        this.isBiModal = bimodal.isAssignableFrom(this.wClass);
    }

    public Object create(QContext context) throws QPE {
        this.makeClass(context);
        try {
            return this.wClass.newInstance();
        }
        catch (Exception e) {
            context.throwPE(e.toString());
            return null;
        }
    }

    public boolean isInstance(Object object, QContext context) throws QPE {
        this.makeClass(context);
        return this.wClass.isInstance(object);
    }

    public String getName(Object object) {
        if (this.isQName) {
            return ((QName)object).getQName();
        }
        return "";
    }

    public String getText(Object object, QContext context) throws QPE {
        if (this.isBiModal) {
            return ((QBiModal)object).getQText();
        }
        return "";
    }

    public void add(Object object, String name, String text, QAccess access, Object parent, QTargetFactory parentFactory, QContext context) throws QPE {
        Object q;
        if (!this.isInstance(object, context)) {
            context.throwPE("Class mismatch: " + object.getClass().getName());
        }
        if (this.isQName) {
            q = (QName)object;
            q.setQName(name);
        }
        if (this.isBiModal) {
            q = (QBiModal)object;
            q.setQText(text);
        }
        if (parent == null) {
            context.doc.setRoot(object);
        } else {
            access.add(parent, parentFactory, object, context);
        }
        if (this.isAware) {
            ((QAware)object).endElement(name, context);
        }
    }

    public PropertyDescriptor[] getPropertyDescriptors(QContext context) throws QPE {
        if (this.properties != null) {
            return this.properties;
        }
        this.makeClass(context);
        try {
            BeanInfo info = ISIntrospector.getBeanInfo(this.wClass);
            this.properties = info.getPropertyDescriptors();
            return this.properties;
        }
        catch (Exception e) {
            context.throwPE(e.toString());
            return null;
        }
    }

    public Field[] getFields(QContext context) throws QPE {
        if (this.fields != null) {
            return this.fields;
        }
        this.makeClass(context);
        try {
            this.fields = this.wClass.getFields();
            return this.fields;
        }
        catch (Exception e) {
            context.throwPE(e.toString());
            return null;
        }
    }

    static {
        try {
            aware = Class.forName("com.jxml.quick.QAware");
            qname = Class.forName("com.jxml.quick.QName");
            bimodal = Class.forName("com.jxml.quick.QBiModal");
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }
}

