/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Common;

import com.siemens.plm.scl.Common.InstallLogger;
import com.siemens.plm.scl.Common.ScriptRunner;
import com.siemens.plm.scl.Exceptions.OSNotSupportedException;
import com.zerog.ia.api.pub.VariableAccess;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.OS;

public final class GeneralUtil {
    static String installerUI = null;
    private static Pattern pattern = Pattern.compile("\\$([^\\$]+)\\$");
    private static Matcher matcher;

    public static boolean isDefined(String string) {
        return string != null && string.trim().length() != 0;
    }

    private static String getInstallerUI(VariableAccess variableAccess) {
        if (installerUI == null) {
            installerUI = variableAccess.substitute("$INSTALLER_UI$");
        }
        return installerUI;
    }

    public static boolean isSilent(VariableAccess variableAccess) {
        return GeneralUtil.getInstallerUI(variableAccess).equalsIgnoreCase("SILENT");
    }

    public static boolean isConsole(VariableAccess variableAccess) {
        return GeneralUtil.getInstallerUI(variableAccess).equalsIgnoreCase("CONSOLE");
    }

    public static boolean isGUI(VariableAccess variableAccess) {
        return GeneralUtil.getInstallerUI(variableAccess).equalsIgnoreCase("SWING");
    }

    public static String getSelectedLicenseFile(VariableAccess variableAccess) {
        String string;
        boolean bl = GeneralUtil.isConsole(variableAccess);
        boolean bl2 = GeneralUtil.isSilent(variableAccess);
        String string2 = null;
        string2 = bl ? variableAccess.substitute("$CONSOLE_LIC_FILE$") : (bl2 ? (GeneralUtil.isDefined(string = variableAccess.substitute("$USER_SELECTED_LICENSE_FILE$")) ? string : (GeneralUtil.isDefined(variableAccess.substitute("$OLD_LIC_FILE$")) ? variableAccess.substitute("$OLD_LIC_FILE$") : variableAccess.substitute("$DEFAULT_LICENSE_DIR$") + variableAccess.substitute("$/$") + variableAccess.substitute("$DEFAULT_LICENSE_FILE$"))) : variableAccess.substitute("$PATH_OF_SELECTED_FILE$") + variableAccess.substitute("$USER_SELECTED_FILE$"));
        if ((bl || bl2) && string2 != null) {
            string2 = string2.replaceFirst("^\\\"", "").replaceFirst("\\\"$", "");
        }
        return string2;
    }

    public static String processIAVariable(String string, VariableAccess variableAccess, InstallLogger installLogger) {
        String string2 = string;
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        matcher = pattern.matcher(string);
        while (matcher.find(n)) {
            String string3 = matcher.group();
            n = string.indexOf(string3, n) + string3.length();
            arrayList.add(string3.trim());
        }
        for (String string4 : arrayList) {
            if (!string4.matches("^\\$(?:[A-Za-z0-9_]+)*\\$$")) continue;
            String string5 = variableAccess.substitute(string4);
            if (string5.length() > 0) {
                string = string2 = string.replace(string4, string5);
                continue;
            }
            if (null == installLogger) continue;
            installLogger.logWarning("IA variable could not be evaluated", "IA variable " + string4 + " could not be evaluated", null);
        }
        return string2;
    }

    public static String processFileNameSpaces(String string) {
        return string.replaceAll("\\s", "\\ ");
    }

    public static boolean isSet(String string) {
        boolean bl = false;
        bl = string.trim().equals("1") ? true : Boolean.parseBoolean(string);
        return bl;
    }

    public static String removeQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String stackTraceToString(StackTraceElement[] stackTraceElementArray) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            printWriter.println(stackTraceElement);
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAdministrator(VariableAccess variableAccess) throws OSNotSupportedException {
        File file;
        if (!OS.isFamilyWindows()) {
            throw new OSNotSupportedException("Only supported in Windows");
        }
        byte[] byArray = new byte[1024];
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        int n = 0;
        int n2 = 1;
        inputStream = ScriptRunner.class.getResourceAsStream("/images32/isadmin.exe");
        String string = variableAccess.substitute("$INSTALLER_TEMP_DIR$");
        try {
            fileOutputStream = new FileOutputStream(string + "/" + "isadmin.exe");
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        if ((file = new File(string + "/" + "isadmin.exe")).isFile()) {
            CommandLine commandLine = CommandLine.parse(file.getAbsolutePath());
            DefaultExecutor defaultExecutor = new DefaultExecutor();
            try {
                n2 = defaultExecutor.execute(commandLine);
            }
            catch (ExecuteException executeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n2 == 0;
    }

    public static String convertIPtoHostname(String string) {
        String string2 = string;
        Pattern pattern = Pattern.compile("^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$", 2);
        try {
            if (pattern.matcher(string).matches()) {
                string2 = Inet4Address.getByName(string).getHostName();
                string2 = pattern.matcher(string2).matches() ? string : string2.split("\\.")[0];
            } else if (string.contains(":")) {
                string2 = Inet6Address.getByName(string).getHostName();
                string2 = string2.contains(":") ? string : string2.split("\\.")[0];
            }
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

