/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Common;

import com.siemens.plm.scl.Common.Command;
import com.siemens.plm.scl.Common.GeneralUtil;
import com.siemens.plm.scl.Common.InstallLogger;
import com.siemens.plm.scl.Plugin.actions.SystemExecute;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import com.zerog.ia.api.pub.VariableAccess;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ScriptRunner {
    private String script;
    private VariableAccess proxy;
    private InstallLogger logger;

    public boolean executeScript(long l) {
        if (null != this.logger) {
            this.logger.logMessage("Executing script = " + this.script);
        }
        String string = this.processScript();
        Command command = new Command("chmod +x \"" + string + "\"");
        SystemExecute systemExecute = new SystemExecute(command, 90L);
        systemExecute.run(this.proxy);
        Command command2 = new Command(string, string.matches(".*\\s+.*"));
        systemExecute = new SystemExecute(command2, l);
        systemExecute.run(this.proxy);
        return true;
    }

    public String processScript() {
        String string = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        inputStream = ScriptRunner.class.getResourceAsStream("/resources/" + this.script);
        if (inputStream == null) {
            if (null != this.logger) {
                this.logger.logFatalError("Script cannot be found", "Script " + this.script + " cannot be found", null);
            }
            throw new RuntimeException("Script cannot be found");
        }
        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        string = this.getTmpFile(this.proxy.substitute("$INSTALLER_TEMP_DIR$"), this.logger);
        if (null == string) {
            throw new RuntimeException("File cannot be null");
        }
        try {
            String string2;
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            while (null != (string2 = bufferedReader.readLine())) {
                bufferedWriter.write(GeneralUtil.processIAVariable(string2, this.proxy, this.logger) + "\n");
            }
        }
        catch (IOException iOException) {
            if (null != this.logger) {
                this.logger.logNonfatalError("Failed to write to a temporary script", "Failed to write to " + string + " temporary script", null);
                this.proxy.setVariable("$ERT$", "iop");
            }
            throw new RuntimeException(GeneralUtil.stackTraceToString(iOException.getStackTrace()));
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != bufferedWriter) {
                    bufferedWriter.close();
                }
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    private String getTmpFile(String string, InstallLogger installLogger) {
        int n = 1;
        File file = new File(string + File.separator + "ia_script" + ".sh");
        while (file.exists()) {
            file = new File(string + File.separator + "ia_script" + n + ".sh");
            if (++n <= 1000) continue;
            if (null != installLogger) {
                installLogger.logMessage("Temporary script could not be created");
            }
            return null;
        }
        return file.getAbsolutePath();
    }

    private void init() {
        if (this.proxy instanceof InstallerProxy) {
            this.logger = new InstallLogger((InstallerProxy)this.proxy);
        } else if (this.proxy instanceof UninstallerProxy) {
            this.logger = null;
        }
    }

    public ScriptRunner(String string, VariableAccess variableAccess) {
        this.script = string;
        this.proxy = variableAccess;
        this.init();
    }
}

