/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Common;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private int majorVersion = 0;
    private int minorVersion = 0;
    private int maintenanceVersion = 0;
    private int buildNumber = 0;

    public String toString() {
        return this.majorVersion + "." + this.minorVersion + "." + this.maintenanceVersion + "." + this.buildNumber;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.buildNumber;
        n = 31 * n + this.maintenanceVersion;
        n = 31 * n + this.majorVersion;
        n = 31 * n + this.minorVersion;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        if (this.buildNumber != version.buildNumber) {
            return false;
        }
        if (this.maintenanceVersion != version.maintenanceVersion) {
            return false;
        }
        if (this.majorVersion != version.majorVersion) {
            return false;
        }
        return this.minorVersion == version.minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMaintenenaceVersion() {
        return this.maintenanceVersion;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            throw new VersionParseException("Cannot compare with null");
        }
        if (this.majorVersion > version.majorVersion) {
            return 1;
        }
        if (this.majorVersion < version.majorVersion) {
            return -1;
        }
        if (this.minorVersion > version.minorVersion) {
            return 1;
        }
        if (this.minorVersion < version.minorVersion) {
            return -1;
        }
        if (this.maintenanceVersion > version.maintenanceVersion) {
            return 1;
        }
        if (this.maintenanceVersion < version.maintenanceVersion) {
            return -1;
        }
        if (this.buildNumber > version.buildNumber) {
            return 1;
        }
        if (this.buildNumber < version.buildNumber) {
            return -1;
        }
        return 0;
    }

    public Version(String string) throws VersionParseException {
        if (string == null) {
            throw new VersionParseException("Version is null");
        }
        String[] stringArray = string.trim().split("\\.");
        if (stringArray.length != 4) {
            throw new VersionParseException("Wring version format: " + string + ", should be x.x.x.x");
        }
        try {
            this.majorVersion = Integer.parseInt(stringArray[0]);
            this.minorVersion = Integer.parseInt(stringArray[1]);
            this.maintenanceVersion = Integer.parseInt(stringArray[2]);
            this.buildNumber = Integer.parseInt(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionParseException("Error parsing version String: " + string + ", expect integers");
        }
    }

    public class VersionParseException
    extends IllegalArgumentException {
        VersionParseException(String string) {
            super(string);
        }
    }
}

