/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Common.actions;

import com.siemens.plm.scl.Common.Command;
import com.siemens.plm.scl.Common.Constants;
import com.siemens.plm.scl.Common.InstallLogger;
import com.siemens.plm.scl.Plugin.actions.SystemExecute;
import com.siemens.plm.scl.Win.actions.RegistryManager;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.VariableAccess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;

public final class Cleanup {
    public static void doUnixAndMacCleanup(VariableAccess variableAccess) {
        Cleanup.doInstallDirCleanup(variableAccess);
    }

    public static void doWindowsCleanup(VariableAccess variableAccess) {
        RegistryManager registryManager = new RegistryManager((InstallerProxy)variableAccess);
        Integer n = Integer.parseInt(variableAccess.substitute("$OLD_INSTALL_VERSION$"));
        Command command = new Command("taskkill");
        command.addArgument("/F");
        command.addArgument("/IM");
        command.addArgument("ugslmd.exe");
        SystemExecute systemExecute = new SystemExecute(command, 30L);
        systemExecute.run(variableAccess);
        if (n <= Constants.UGS_MAX_VERSION) {
            registryManager.deleteRegistryKey("HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\FLEXlm License Manager\\UGS License Server (ugslmd)");
            registryManager.deleteRegistryKey("HKEY_LOCAL_MACHINE\\SOFTWARE\\FLEXlm License Manager\\UGS License Server (ugslmd)");
            for (int i = 0; i < Constants.UGSProductVersion.values().length; ++i) {
                Constants.UGSProductVersion uGSProductVersion = Constants.UGSProductVersion.resolve(i);
                if (uGSProductVersion == Constants.UGSProductVersion.UNDEFINED) continue;
                registryManager.deleteRegistryKey("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + uGSProductVersion.getGUID());
                registryManager.deleteRegistryKey("HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + uGSProductVersion.getGUID());
            }
        } else {
            Command command2 = new Command("reg");
            command2.addArgument("delete");
            command2.addArgument("HKLM\\SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + variableAccess.substitute("$OLD_INSTALL_DISPLAY_NAME$"), true);
            command2.addArgument("/f");
            systemExecute = new SystemExecute(command2, 30L);
            systemExecute.run(variableAccess);
            command2 = new Command("reg");
            command2.addArgument("delete");
            command2.addArgument("HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + variableAccess.substitute("$OLD_INSTALL_DISPLAY_NAME$"), true);
            command2.addArgument("/f");
            systemExecute = new SystemExecute(command2, 30L);
            systemExecute.run(variableAccess);
        }
        Cleanup.doInstallDirCleanup(variableAccess);
    }

    public static void doInstallDirCleanup(VariableAccess variableAccess) {
        InstallLogger installLogger = null;
        if (variableAccess instanceof InstallerProxy) {
            installLogger = new InstallLogger((InstallerProxy)variableAccess);
        }
        Integer n = null;
        try {
            n = Integer.parseInt(variableAccess.substitute("$OLD_INSTALL_VERSION$"));
        }
        catch (NumberFormatException numberFormatException) {
            installLogger.logFatalError("No Old Install Version", "Unable to decipher old install version during cleanup", null);
            return;
        }
        File file = new File(variableAccess.substitute("$OLD_INSTALL_DIR$"));
        if (file.exists()) {
            List<String> list = Arrays.asList(file.list());
            String[] stringArray = null;
            LinkedList<String> linkedList = null;
            if (OS.isFamilyWindows()) {
                stringArray = n <= Constants.UGS_MAX_VERSION ? Constants.UGS_WIN_FILE_NAMES : Constants.SPLM_WIN_FILE_NAMES;
            } else if (OS.isFamilyMac()) {
                stringArray = n <= Constants.UGS_MAX_VERSION ? Constants.UGS_MAC_FILE_NAMES : Constants.SPLM_MAC_FILE_NAMES;
            } else if (OS.isFamilyUnix()) {
                stringArray = n <= Constants.UGS_MAX_VERSION ? Constants.UGS_UNX_FILE_NAMES : Constants.SPLM_UNX_FILE_NAMES;
            }
            if (stringArray != null) {
                linkedList = new LinkedList<String>(Arrays.asList(stringArray));
                if (!OS.isFamilyWindows()) {
                    String string = variableAccess.substitute("$START_STOP_SCRIPT_NAME$");
                    linkedList.add(string);
                }
                for (String string : list) {
                    if (!linkedList.contains(string)) continue;
                    File file2 = null;
                    try {
                        file2 = new File(file.getAbsolutePath() + "/" + string);
                        FileUtils.forceDelete(file2);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        if (null == installLogger) continue;
                        installLogger.logWarning("Error deleting file", "Unable to delete file/folder = " + file2 + " during cleanup process", null);
                    }
                    catch (NullPointerException nullPointerException) {
                        if (null == installLogger) continue;
                        installLogger.logWarning("File not found", "Unable to find child file = " + file2 + " during cleanup process", null);
                    }
                }
            }
        }
    }
}

