/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Common.actions;

import com.siemens.plm.scl.Common.Constants;
import com.siemens.plm.scl.Common.GeneralUtil;
import com.siemens.plm.scl.Common.InstallLogger;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import com.zerog.ia.api.pub.VariableAccess;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.GregorianCalendar;

public class CopyLicenseFile
extends CustomCodeAction {
    public String getInstallStatusMessage() {
        return "Copying License File";
    }

    public String getUninstallStatusMessage() {
        return null;
    }

    public void install(InstallerProxy installerProxy) throws InstallException {
        String string;
        InstallLogger installLogger = new InstallLogger(installerProxy);
        installLogger.logDebug("Running action CopyLicenseFile:");
        String string2 = installerProxy.substitute("$LIC_FILE$");
        if (!GeneralUtil.isDefined(string2)) {
            new InstallLogger(installerProxy).logFatalError("License file is not defined", null, null);
        }
        if (!GeneralUtil.isDefined(string = installerProxy.substitute("$DEFAULT_LICENSE_FILE$"))) {
            new InstallLogger(installerProxy).logFatalError("License file name is not defined", null, null);
            installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
        }
        String string3 = installerProxy.substitute("$USER_INSTALL_DIR$/" + string);
        installLogger.logDebug("  input license: " + string2 + "  \n  output license: " + string3);
        File file = new File(string2);
        File file2 = new File(string3);
        if (file.getAbsolutePath().equals(file2.getAbsolutePath())) {
            return;
        }
        if (new File(installerProxy.substitute("$USER_INSTALL_DIR$") + "/" + installerProxy.substitute("$DEFAULT_LICENSE_FILE$")).exists()) {
            this.createLicenseFileBackup(installerProxy, installLogger);
        }
        try {
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            while ((string4 = bufferedReader.readLine()) != null) {
                String[] stringArray = string4.replaceFirst("#.*", "").trim().split("\\s+");
                if (stringArray.length > 1 && stringArray[0].equals("SERVER") && (stringArray[1].toLowerCase().startsWith("YourHostname".toLowerCase()) || stringArray[1].equals("this_host"))) {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    stringArray[1] = inetAddress.getHostName();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuilder.append(stringArray[i]).append(" ");
                    }
                    string4 = stringBuilder.toString();
                    installLogger.logDebug("  using server name: " + stringArray[1]);
                }
                bufferedWriter.write(string4);
                bufferedWriter.newLine();
            }
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            new InstallLogger(installerProxy).logFatalError("License file cannot be found", "License file " + string2 + " doesn't exist: " + fileNotFoundException.getMessage(), "Specify correct license file");
            return;
        }
        catch (IOException iOException) {
            new InstallLogger(installerProxy).logFatalError("I/O error while copying a license file", "I/O error while copying license file " + string2 + " to " + string3 + ": " + iOException.getMessage(), null);
            return;
        }
    }

    private boolean createLicenseFileBackup(VariableAccess variableAccess, InstallLogger installLogger) {
        boolean bl = false;
        String string = variableAccess.substitute("$USER_INSTALL_DIR$");
        String string2 = variableAccess.substitute("$DEFAULT_LICENSE_FILE$");
        String string3 = string + "/" + string2;
        File file = new File(string3);
        if (file.exists()) {
            File file2 = new File(string + "/" + "license_backup");
            if (!file2.exists() && !file2.mkdir()) {
                installLogger.logWarning("Folder not created", "Back up folder " + file2.getAbsolutePath() + " could not be created", null);
            }
            String string4 = file2.getAbsolutePath() + "/" + string2.split("\\.")[0] + String.format("%1$tY%1$tm%1$td%1$tH%1$tM", new GregorianCalendar().getTime()) + "." + string2.split("\\.")[1];
            File file3 = new File(string4);
            this.copy(file, file3, installLogger);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File file, File file2, InstallLogger installLogger) {
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            installLogger.logWarning("File not found", "Failed to copy the original license file", null);
        }
        catch (IOException iOException) {
            installLogger.logWarning("License backup failed", "Failed to copy the original license file", null);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void uninstall(UninstallerProxy uninstallerProxy) throws InstallException {
    }
}

