/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Common.actions;

import com.siemens.plm.scl.Common.AdvancedActionParameters;
import com.siemens.plm.scl.Common.Command;
import com.siemens.plm.scl.Common.Constants;
import com.siemens.plm.scl.Common.GeneralUtil;
import com.siemens.plm.scl.Common.InstallLogger;
import com.siemens.plm.scl.Plugin.actions.SystemExecute;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import com.zerog.ia.api.pub.VariableAccess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.exec.OS;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PrepareAdvancedAction
extends CustomCodeAction {
    private InstallLogger logger = null;
    private SystemExecute execute = null;
    private boolean isActionUGSSpecific = false;
    private Constants.AdvancedAction action = null;

    public String getInstallStatusMessage() {
        return null;
    }

    public String getUninstallStatusMessage() {
        return null;
    }

    public void install(InstallerProxy installerProxy) throws InstallException {
        this.logger = new InstallLogger(installerProxy);
        this.isActionUGSSpecific = GeneralUtil.isSet(installerProxy.substitute("$UPGRADE_UGS$"));
        this.logger.logMessage("Preparing Advanced Action");
        if (GeneralUtil.isConsole(installerProxy)) {
            if (installerProxy.substitute("$ALREADY_INSTALLED$").equals("LESSER_VERSION")) {
                this.action = GeneralUtil.isDefined(installerProxy.substitute("$USER_INPUT_CONSOLE_RESULTS_1$")) ? Constants.AdvancedAction.UPGRADE : Constants.AdvancedAction.EXIT;
            } else if (installerProxy.substitute("$ALREADY_INSTALLED$").equals("SAME_VERSION")) {
                this.action = OS.isFamilyWindows() ? this.getActionForWindows(installerProxy) : (GeneralUtil.isDefined(installerProxy.substitute("$USER_INPUT_CONSOLE_RESULTS_1$")) ? Constants.AdvancedAction.REPAIR : Constants.AdvancedAction.REPLACE);
            }
        } else if (GeneralUtil.isGUI(installerProxy)) {
            if (installerProxy.substitute("$ALREADY_INSTALLED$").equals("LESSER_VERSION")) {
                this.action = GeneralUtil.isSet(installerProxy.substitute("$USER_INPUT_RESULT_UPGRADE$")) ? Constants.AdvancedAction.UPGRADE : Constants.AdvancedAction.EXIT;
            } else if (installerProxy.substitute("$ALREADY_INSTALLED$").equals("SAME_VERSION")) {
                this.action = OS.isFamilyWindows() ? this.getActionForWindows(installerProxy) : (GeneralUtil.isSet(installerProxy.substitute("$USER_INPUT_RESULT_REPAIR$")) ? Constants.AdvancedAction.REPAIR : Constants.AdvancedAction.REPLACE);
            }
        } else if (GeneralUtil.isSilent(installerProxy)) {
            if (installerProxy.substitute("$ALREADY_INSTALLED$").equals("LESSER_VERSION")) {
                this.action = Constants.AdvancedAction.UPGRADE;
            } else if (installerProxy.substitute("$ALREADY_INSTALLED$").equals("SAME_VERSION")) {
                this.action = OS.isFamilyWindows() ? this.getActionForWindows(installerProxy) : Constants.AdvancedAction.REPAIR;
            }
        }
        if (null != this.action && Constants.AdvancedAction.EXIT.ordinal() != this.action.ordinal()) {
            installerProxy.setVariable("$ADVANCED_ACTION$", this.action.toString());
            this.logger.logMessage("Advanced action to be taken = " + this.action.toString());
            switch (this.action) {
                case UPGRADE: {
                    installerProxy.setVariable("$ADVANCED_ACTION_TEXT$", installerProxy.getValue("splm.adv.action.upgrade"));
                    break;
                }
                case EXIT: {
                    installerProxy.setVariable("$ADVANCED_ACTION_TEXT$", installerProxy.getValue("splm.adv.action.exit"));
                    break;
                }
                case REPAIR: {
                    installerProxy.setVariable("$ADVANCED_ACTION_TEXT$", installerProxy.getValue("splm.adv.action.repair"));
                    break;
                }
                case REPLACE: {
                    installerProxy.setVariable("$ADVANCED_ACTION_TEXT$", installerProxy.getValue("splm.adv.action.replace"));
                }
            }
        } else {
            if (this.action != null) {
                this.logger.logMessage("Exiting Installer due to advanced action  = " + this.action.toString());
            }
            installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
        }
        String string = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        AdvancedActionParameters advancedActionParameters = null;
        if (OS.isFamilyWindows()) {
            advancedActionParameters = this.getWindowsInfo(installerProxy);
        } else if (OS.isFamilyMac()) {
            advancedActionParameters = this.getMacInfo(installerProxy);
        } else if (OS.isFamilyUnix()) {
            advancedActionParameters = this.getUnixInfo(installerProxy);
        }
        if (null != advancedActionParameters) {
            string = GeneralUtil.removeQuotes(advancedActionParameters.getInstallLocaltion());
            string4 = advancedActionParameters.getLicenseFile();
            string2 = advancedActionParameters.getMajorVersion();
            string3 = advancedActionParameters.getDisplayName();
        }
        this.logger.logDebug(" Install Location = " + string + "\n License File Name = " + string4 + "\n Version = " + string2 + "\n Display Name = " + string3);
        if (null != string && string.trim().length() >= 0) {
            installerProxy.setVariable("$OLD_INSTALL_DIR$", string);
            installerProxy.setVariable("$OLD_LIC_FILE_NAME$", string4);
            installerProxy.setVariable("$OLD_LIC_FILE$", string + "/" + string4);
            installerProxy.setVariable("$OLD_INSTALL_VERSION$", string2);
            installerProxy.setVariable("$OLD_INSTALL_DISPLAY_NAME$", string3);
        } else {
            this.logger.logFatalError("Install Location Not Found", "Unable to find old install location", null);
            installerProxy.setVariable("$ADVANCED_ACTION$", Constants.AdvancedAction.UNDEFINED.toString());
        }
    }

    private Constants.AdvancedAction getActionForWindows(VariableAccess variableAccess) {
        Constants.AdvancedAction advancedAction = Constants.AdvancedAction.EXIT;
        boolean bl = GeneralUtil.isSet(variableAccess.substitute("$INSTALLER_64BIT$"));
        boolean bl2 = GeneralUtil.isSet(variableAccess.substitute("$INSTALLED_64BIT$"));
        boolean bl3 = !bl;
        boolean bl4 = !bl2;
        this.logger.logMessage("Installed architecture :: " + (bl2 ? "64bit" : "32bit"));
        this.logger.logMessage("Installer architecture :: " + (bl ? "64bit" : "32bit"));
        if (bl4 != bl3 || bl2 != bl) {
            if (GeneralUtil.isGUI(variableAccess)) {
                advancedAction = GeneralUtil.isSet(variableAccess.substitute("$USER_INPUT_RESULT_UPGRADE$")) ? Constants.AdvancedAction.UPGRADE : Constants.AdvancedAction.EXIT;
            } else if (GeneralUtil.isConsole(variableAccess)) {
                advancedAction = GeneralUtil.isDefined(variableAccess.substitute("$USER_INPUT_CONSOLE_RESULTS_1$")) ? Constants.AdvancedAction.UPGRADE : Constants.AdvancedAction.EXIT;
            } else if (GeneralUtil.isSilent(variableAccess)) {
                advancedAction = Constants.AdvancedAction.UPGRADE;
            }
        } else if (GeneralUtil.isGUI(variableAccess)) {
            advancedAction = GeneralUtil.isSet(variableAccess.substitute("$USER_INPUT_RESULT_REPAIR$")) ? Constants.AdvancedAction.REPAIR : Constants.AdvancedAction.REPLACE;
        } else if (GeneralUtil.isConsole(variableAccess)) {
            advancedAction = GeneralUtil.isDefined(variableAccess.substitute("$USER_INPUT_CONSOLE_RESULTS_1$")) ? Constants.AdvancedAction.REPAIR : Constants.AdvancedAction.REPLACE;
        } else if (GeneralUtil.isSilent(variableAccess)) {
            String string = variableAccess.substitute("$USER_ADVANCED_ACTION$");
            if (GeneralUtil.isDefined(string)) {
                if (string.trim().equalsIgnoreCase(Constants.AdvancedAction.REPLACE.toString())) {
                    advancedAction = Constants.AdvancedAction.REPLACE;
                } else if (string.trim().equalsIgnoreCase(Constants.AdvancedAction.REPAIR.toString())) {
                    advancedAction = Constants.AdvancedAction.REPAIR;
                } else {
                    advancedAction = Constants.AdvancedAction.EXIT;
                    this.logger.logNonfatalError("Invalid parameter value", "Invalid parameter value for -DUSER_ADVANCED_ACTION=" + string, null);
                }
            } else {
                advancedAction = Constants.AdvancedAction.REPAIR;
            }
            if (advancedAction == Constants.AdvancedAction.REPAIR) {
                this.logger.logMessage("Ignoring default parameter -DUSER_INSTALL_DIR=" + variableAccess.substitute("$USER_INSTALL_DIR$"));
            }
        }
        return advancedAction;
    }

    private AdvancedActionParameters getWindowsInfo(VariableAccess variableAccess) {
        AdvancedActionParameters advancedActionParameters = new AdvancedActionParameters();
        advancedActionParameters.setInstallLocaltion(variableAccess.substitute("$INSTALL_LOC$"));
        advancedActionParameters.setDisplayName(variableAccess.substitute("$DISP_NAME$"));
        if (this.isActionUGSSpecific) {
            advancedActionParameters.setLicenseFile(this.getUGSLicenseFile(advancedActionParameters.getInstallLocaltion()));
            advancedActionParameters.setMajorVersion(variableAccess.substitute("$EARLIER_VERSION$"));
        } else if (this.action == Constants.AdvancedAction.UPGRADE) {
            advancedActionParameters.setMajorVersion(variableAccess.substitute("$EARLIER_VERSION$").split("\\.")[0]);
            advancedActionParameters.setLicenseFile("splm" + advancedActionParameters.getMajorVersion() + ".lic");
        } else {
            advancedActionParameters.setMajorVersion(variableAccess.substitute("$MAJOR_VERSION$"));
            advancedActionParameters.setLicenseFile("splm" + variableAccess.substitute("$MAJOR_VERSION$") + ".lic");
        }
        return advancedActionParameters;
    }

    private String getUGSLicenseFile(String string) {
        File file;
        String string2 = null;
        if (null != string && string.length() > 0 && (file = new File(string)).exists()) {
            String[] stringArray = file.list();
            for (int i = 0; i < Constants.UGS_LICENSE_FILES.length; ++i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    String string3 = stringArray[j].trim();
                    if (!string3.equals(Constants.UGS_LICENSE_FILES[i])) continue;
                    string2 = string3;
                    return string2;
                }
            }
        }
        return string2;
    }

    private AdvancedActionParameters getUnixInfo(VariableAccess variableAccess) {
        AdvancedActionParameters advancedActionParameters = new AdvancedActionParameters();
        String string = null;
        String string2 = null;
        boolean bl = false;
        String[] stringArray = new String[]{"/etc/rc.d", "/etc/rc.d/init.d", "/etc/init.d", variableAccess.substitute("$SERVER_STARTUP_PATH$")};
        if (this.isActionUGSSpecific) {
            string2 = "rc.ugs.licensing";
            advancedActionParameters.setMajorVersion(Integer.toString(Constants.UGS_MAX_VERSION));
        } else {
            string2 = variableAccess.substitute("$DAEMON_NAME$");
            advancedActionParameters.setMajorVersion(Integer.toString(Constants.SPLM_MIN_VERSION));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i] + "/" + string2;
            if (!new File(string).exists()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.logger.logFatalError("RC file not found", "Unable to find any RC file on the system for determining the install location", null);
            return null;
        }
        String[] stringArray2 = this.getMacAndUnixInstallLocationAndVersion(string);
        if (null == stringArray2[1] && this.isActionUGSSpecific) {
            advancedActionParameters.setLicenseFile(this.getUGSLicenseFile(stringArray2[0]));
            if (null != advancedActionParameters.getLicenseFile()) {
                advancedActionParameters.setMajorVersion(Character.toString(advancedActionParameters.getLicenseFile().charAt(3)));
            }
            advancedActionParameters.setDisplayName("UGS Licensing");
        } else {
            if (this.action == Constants.AdvancedAction.UPGRADE) {
                advancedActionParameters.setMajorVersion(variableAccess.substitute("$ALREADY_INSTALLED_VERSION$").split("\\.")[0]);
                advancedActionParameters.setLicenseFile("splm" + advancedActionParameters.getMajorVersion() + ".lic");
            } else {
                advancedActionParameters.setMajorVersion(variableAccess.substitute("$MAJOR_VERSION$"));
                advancedActionParameters.setLicenseFile("splm" + variableAccess.substitute("$MAJOR_VERSION$") + ".lic");
            }
            advancedActionParameters.setDisplayName(variableAccess.substitute("$PRODUCT_NAME$"));
        }
        advancedActionParameters.setInstallLocaltion(stringArray2[0]);
        return advancedActionParameters;
    }

    private AdvancedActionParameters getMacInfo(VariableAccess variableAccess) {
        Object object;
        AdvancedActionParameters advancedActionParameters = new AdvancedActionParameters();
        this.logger.logMessage("     Getting Mac OSX info...");
        boolean bl = GeneralUtil.isSet(variableAccess.substitute("$PRE_LAUNCHD_INSTALLER$"));
        String string = null;
        if (this.isActionUGSSpecific) {
            object = new Command("plutil -convert binary1 /System/Library/LaunchDaemons/com.ugs.ugslicensing.plist");
            this.execute = new SystemExecute((Command)object, 10L);
            this.execute.run(variableAccess);
            object = null;
            object = new Command("plutil -convert xml1 /System/Library/LaunchDaemons/com.ugs.ugslicensing.plist");
            this.execute = new SystemExecute((Command)object, 10L);
            this.execute.run(variableAccess);
            string = "/System/Library/LaunchDaemons/com.ugs.ugslicensing.plist";
        } else {
            string = bl ? "/Library/StartupItems/splmld/splmld" : variableAccess.substitute("$SERVER_STARTUP_PATH$") + "/" + variableAccess.substitute("$MAC_LAUNCHD_PLIST$");
        }
        if (this.isActionUGSSpecific) {
            advancedActionParameters.setInstallLocaltion(this.getInstallLocationFromPlist(string));
            advancedActionParameters.setDisplayName("UGS Licensing");
            advancedActionParameters.setLicenseFile(this.getUGSLicenseFile(advancedActionParameters.getInstallLocaltion()));
            if (null != advancedActionParameters.getLicenseFile()) {
                advancedActionParameters.setMajorVersion(Character.toString(advancedActionParameters.getLicenseFile().charAt(3)));
            }
        } else {
            object = this.getMacAndUnixInstallLocationAndVersion(string);
            advancedActionParameters.setInstallLocaltion(object[0]);
            if (this.action == Constants.AdvancedAction.UPGRADE) {
                advancedActionParameters.setMajorVersion(variableAccess.substitute("$ALREADY_INSTALLED_VERSION$").split("\\.")[0]);
                advancedActionParameters.setLicenseFile("splm" + advancedActionParameters.getMajorVersion() + ".lic");
            } else {
                advancedActionParameters.setMajorVersion(variableAccess.substitute("$MAJOR_VERSION$"));
                advancedActionParameters.setLicenseFile("splm" + variableAccess.substitute("$MAJOR_VERSION$") + ".lic");
            }
            advancedActionParameters.setDisplayName(variableAccess.substitute("$PRODUCT_NAME$"));
        }
        return advancedActionParameters;
    }

    private String getInstallLocationFromPlist(String string) {
        String string2 = null;
        try {
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("string");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string3 = nodeList.item(i).getTextContent();
                if (!string3.contains("start_ugslicensing")) continue;
                string2 = string3.substring(0, string3.indexOf("start_ugslicensing") - 1);
            }
        }
        catch (SAXException sAXException) {
            this.logger.logFatalError("SAXException  - Malformed plist", "Malformed plist = " + string, null);
        }
        catch (IOException iOException) {
            this.logger.logFatalError("IOException", GeneralUtil.stackTraceToString(iOException.getStackTrace()), null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.logger.logFatalError("ParserConfigurationException", GeneralUtil.stackTraceToString(parserConfigurationException.getStackTrace()), null);
        }
        return string2;
    }

    private String[] getMacAndUnixInstallLocationAndVersion(String string) {
        String[] stringArray = new String[2];
        File file = new File(string);
        if (file.exists()) {
            this.logger.logMessage("Scanning File = " + file.getAbsolutePath());
            try {
                Scanner scanner = new Scanner(file);
                while (scanner.hasNextLine()) {
                    String string2 = scanner.nextLine();
                    if (string2.startsWith("LICENSE_DIR=")) {
                        stringArray[0] = string2.substring("LICENSE_DIR".length() + 1, string2.length());
                    }
                    if (!string2.startsWith("LICENSE_VER=")) continue;
                    stringArray[1] = string2.substring("LICENSE_VER".length() + 1, string2.length()).split("\\.")[0];
                }
                scanner.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public void uninstall(UninstallerProxy uninstallerProxy) throws InstallException {
    }
}

