/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Common.actions;

import com.siemens.plm.scl.Common.Constants;
import com.siemens.plm.scl.Common.GeneralUtil;
import com.siemens.plm.scl.Common.InstallLogger;
import com.siemens.plm.scl.Common.Version;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;

public class SameVersionExists
extends CustomCodeAction {
    public String getInstallStatusMessage() {
        return "Checking for installed versions of PLM License Server";
    }

    public String getUninstallStatusMessage() {
        return null;
    }

    public void install(InstallerProxy installerProxy) throws InstallException {
        InstallLogger installLogger = new InstallLogger(installerProxy);
        installLogger.logDebug("Executing SameVersionExists");
        String string = installerProxy.substitute("$PRODUCT_VERSION_NUMBER$");
        if (!GeneralUtil.isDefined(string)) {
            new InstallLogger(installerProxy).logFatalError("Invalid version PRODUCT_VERSION_NUMBER", "Invalid version PRODUCT_VERSION_NUMBER: not defined", null);
            installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
        }
        String string2 = installerProxy.substitute("$ALREADY_INSTALLED_VERSION$");
        String string3 = installerProxy.substitute("$ALREADY_INSTALLED$");
        installerProxy.setVariable("$ALREADY_INSTALLED$", "NONE");
        if (installerProxy.substitute("$IS_LMGRD_DEFINED$").equals("false")) {
            installLogger.logDebug("  installing product version: " + string + "\n  existing product version: " + string2);
            installLogger.logDebug("\n  A prior installation of the product has been detected but without a proper service entry... \n therefore proceeding with installation");
            return;
        }
        if (GeneralUtil.isDefined(string3) && string3.equalsIgnoreCase("true")) {
            Version version = null;
            try {
                version = new Version(string);
            }
            catch (Version.VersionParseException versionParseException) {
                new InstallLogger(installerProxy).logFatalError("Invalid version " + string, "Invalid version " + string + ": cannot parse", null);
            }
            Version version2 = null;
            try {
                version2 = new Version(string2);
            }
            catch (Version.VersionParseException versionParseException) {
                new InstallLogger(installerProxy).logFatalError("Invalid installed version " + string2, "Invalid installed version " + string2 + ": cannot parse", null);
            }
            installLogger.logDebug("  installing product version: " + version + "\n  existing product version: " + version2);
            int n = version.compareTo(version2);
            if (n > 0) {
                installerProxy.setVariable("$ALREADY_INSTALLED$", "LESSER_VERSION");
            } else if (n < 0) {
                installerProxy.setVariable("$ALREADY_INSTALLED$", "GREATER_VERSION");
            } else {
                installerProxy.setVariable("$ALREADY_INSTALLED$", "SAME_VERSION");
            }
            installLogger.logDebug("Same version check result: " + installerProxy.substitute("$ALREADY_INSTALLED$"));
        }
    }

    public void uninstall(UninstallerProxy uninstallerProxy) throws InstallException {
    }
}

