/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Common.actions;

import com.siemens.plm.scl.Common.GeneralUtil;
import com.siemens.plm.scl.Common.InstallLogger;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.FatalInstallException;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.File;

public class SetLicenseFile
extends CustomCodeAction {
    public String getInstallStatusMessage() {
        return "Set License File Name";
    }

    public String getUninstallStatusMessage() {
        return null;
    }

    public void install(InstallerProxy installerProxy) throws InstallException {
        InstallLogger installLogger = new InstallLogger(installerProxy);
        installLogger.logDebug("Running SetLicenseFile action:");
        String string = GeneralUtil.getSelectedLicenseFile(installerProxy);
        if (!GeneralUtil.isDefined(string)) {
            throw new FatalInstallException("License file is not defined");
        }
        if (GeneralUtil.isSilent(installerProxy)) {
            File file = new File(string);
            try {
                if (!file.exists()) {
                    new InstallLogger(installerProxy).logFatalError("License file cannot be found", "License file " + string + " doesn't exist", "Specify correct license file");
                }
            }
            catch (SecurityException securityException) {
                new InstallLogger(installerProxy).logFatalError("License file cannot be found", "License file " + string + " doesn't exist", "Specify correct license file");
            }
        }
        if (GeneralUtil.isDefined(string)) {
            new InstallLogger(installerProxy).logMessage("Using license file: " + string);
            installerProxy.setVariable("$LIC_FILE$", string);
        }
    }

    public void uninstall(UninstallerProxy uninstallerProxy) throws InstallException {
    }
}

