/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Common.actions;

import com.siemens.plm.scl.Common.Command;
import com.siemens.plm.scl.Common.Constants;
import com.siemens.plm.scl.Common.GeneralUtil;
import com.siemens.plm.scl.Common.OSUtils;
import com.siemens.plm.scl.Common.actions.Cleanup;
import com.siemens.plm.scl.Plugin.actions.SystemExecute;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import com.zerog.ia.api.pub.VariableAccess;
import java.io.File;
import java.io.IOException;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;

public class Uninstall
extends CustomCodeAction {
    private SystemExecute execute = null;
    private Integer version = null;

    public String getInstallStatusMessage() {
        return installerProxy.getValue("splm.upgrade.uninstalling") + " " + installerProxy.substitute("$OLD_INSTALL_DISPLAY_NAME$");
    }

    public String getUninstallStatusMessage() {
        return null;
    }

    public void install(InstallerProxy installerProxy) throws InstallException {
        try {
            this.version = Integer.parseInt(installerProxy.substitute("$OLD_INSTALL_VERSION$"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.uninstall(installerProxy);
    }

    private void uninstall(VariableAccess variableAccess) {
        if (OS.isFamilyWindows()) {
            this.uninstallWindows(variableAccess);
        } else if (OS.isFamilyMac()) {
            this.uninstallMacOSX(variableAccess);
        } else if (OS.isFamilyUnix()) {
            this.uninstallUnix(variableAccess);
        }
    }

    private void uninstallMacOSX(VariableAccess variableAccess) {
        try {
            if (GeneralUtil.isSet(variableAccess.substitute("$UPGRADE_UGS$"))) {
                FileUtils.forceDelete(new File("/System/Library/LaunchDaemons/com.ugs.ugslicensing.plist"));
            } else if (GeneralUtil.isSet(variableAccess.substitute("$PRE_LAUNCHD_INSTALLER$"))) {
                FileUtils.forceDelete(new File(variableAccess.substitute("/Library/StartupItems/splmld/")));
            } else {
                FileUtils.forceDelete(new File(variableAccess.substitute("$SERVER_STARTUP_PATH$") + "/" + variableAccess.substitute("$MAC_LAUNCHD_PLIST$")));
            }
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Cleanup.doUnixAndMacCleanup(variableAccess);
    }

    private void uninstallUnix(VariableAccess variableAccess) {
        if (this.version > Constants.UGS_MAX_VERSION) {
            Command command = new Command(variableAccess.substitute("\"$OLD_INSTALL_DIR$") + "/" + "Uninstall\" -i silent");
            this.execute = new SystemExecute(command, 90L);
            this.execute.run(variableAccess);
            if (OSUtils.isOSHP()) {
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Cleanup.doUnixAndMacCleanup(variableAccess);
    }

    private void uninstallWindows(VariableAccess variableAccess) {
        if (this.version <= Constants.UGS_MAX_VERSION) {
            Constants.UGSProductVersion uGSProductVersion = Constants.UGSProductVersion.resolve(this.version);
            if (uGSProductVersion != Constants.UGSProductVersion.UNDEFINED) {
                Command command = new Command("msiexec.exe");
                command.addArgument("/qn");
                command.addArgument("/x");
                command.addArgument(uGSProductVersion.getGUID());
                this.execute = new SystemExecute(command, 60L);
                this.execute.run(variableAccess);
            }
        } else {
            Command command = new Command(variableAccess.substitute("$OLD_INSTALL_DIR$") + "\\UninstallerData\\Uninstall.exe", true);
            command.addArgument("-i");
            command.addArgument("silent");
            this.execute = new SystemExecute(command, 90L);
            this.execute.run(variableAccess);
        }
        Cleanup.doWindowsCleanup(variableAccess);
    }

    public void uninstall(UninstallerProxy uninstallerProxy) throws InstallException {
    }
}

