/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Common.actions;

import com.siemens.plm.scl.Common.Command;
import com.siemens.plm.scl.Common.Constants;
import com.siemens.plm.scl.Common.GeneralUtil;
import com.siemens.plm.scl.Common.InstallLogger;
import com.siemens.plm.scl.Common.LicenseFileParser;
import com.siemens.plm.scl.Common.ScriptRunner;
import com.siemens.plm.scl.Plugin.actions.SystemExecute;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import com.zerog.ia.api.pub.VariableAccess;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.exec.OS;

public class ValidateLicenseFile
extends CustomCodeAction {
    private boolean serverPresent = false;
    private boolean vendorPresent = false;
    private boolean validFile = false;
    private int serverCnt = 0;
    private static final int REDUNDANT_SERVER_COUNT = 3;
    private static final int SINGLE_SERVER_COUNT = 1;
    private static final String INVALID_LICENSE_FILE = "INVALID_LICENSE_FILE";
    private static final String INVALID_SERVER_NAME = "INVALID_SERVER_NAME";
    private static final String SAME_LICENSE_FILE = "SAME_LICENSE_FILE";
    private static final String INVALID_THREE_SERVER_LICENSE_FILE = "INVALID_THREE_SERVER_LICENSE_FILE";
    private static final String INVALID_SERVER_COUNT_LICENSE_FILE = "INVALID_SERVER_COUNT_LICENSE_FILE";
    private static final String UNKNOWN_HOST = "UNKNOWN_HOST";
    private static final String NO_SERVER_ENTRY = "NO_SERVER_ENTRY";
    private static final String NO_VENDOR_ENTRY = "NO_VENDOR_ENTRY";
    private static final String NO_FEATURE_INCREMENT_ENTRY = "NO_FEATURE_INCREMENT_ENTRY";
    private static final String ACCESS_DENIED = "ACCESS_DENIED";

    public String getInstallStatusMessage() {
        return "Validating License File";
    }

    public String getUninstallStatusMessage() {
        return null;
    }

    private boolean isLocalHost(String string) {
        return string.equalsIgnoreCase("this_host") || string.equalsIgnoreCase("localhost") || string.toLowerCase().startsWith("YourHostname".toLowerCase()) || string.equalsIgnoreCase("127.0.0.1");
    }

    private void setInvalidLicenseVars(InstallerProxy installerProxy, String string) {
        installerProxy.setVariable("$CUSTOM_CODE_OUTPUT$", INVALID_LICENSE_FILE);
        installerProxy.setVariable("$CUSTOM_CODE_INVALID_LICENSE_REASON$", string);
    }

    public void install(InstallerProxy installerProxy) throws InstallException {
        Iterator iterator;
        Object object;
        Object object22;
        Object object3;
        InstallLogger installLogger = new InstallLogger(installerProxy);
        installLogger.logDebug("Running action ValidateLicenseFile:");
        installerProxy.setVariable("$CUSTOM_CODE_OUTPUT$", "");
        installerProxy.setVariable("$CUSTOM_CODE_INVALID_LICENSE_REASON$", "");
        String string = installerProxy.substitute("$LIC_FILE$");
        if (!GeneralUtil.isDefined(string)) {
            installLogger.logFatalError("License file is not defined", null, null);
            installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
            return;
        }
        installLogger.logDebug("  license file: " + string);
        File file = new File(string);
        try {
            if (!file.exists()) {
                installLogger.logFatalError("License file cannot be found", "License file " + string + " does not exist!", "Specify a proper license file");
                if (GeneralUtil.isSilent(installerProxy)) {
                    installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
                }
                return;
            }
        }
        catch (SecurityException securityException) {
            installLogger.logFatalError("License file cannot be found", "License file " + string + " does not exist!", "Specify a proper license file");
            if (GeneralUtil.isSilent(installerProxy)) {
                installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
            }
            return;
        }
        String string2 = installerProxy.substitute("$ADVANCED_ACTION$");
        if (GeneralUtil.isDefined(string2) && string2.equals(Constants.AdvancedAction.REPLACE.toString()) && ((File)(object3 = new File(installerProxy.substitute("$OLD_LIC_FILE$")))).getAbsolutePath().equals(new File(string).getAbsolutePath())) {
            installLogger.logNonfatalError("Same License File", "Same License File " + string + " selected for replacement", null);
            installerProxy.setVariable("$CUSTOM_CODE_OUTPUT$", SAME_LICENSE_FILE);
            return;
        }
        object3 = installerProxy.substitute("$VENDOR_DAEMON$");
        if (!GeneralUtil.isDefined((String)object3)) {
            installLogger.logFatalError("Vendor Daemon is not defined", null, null);
            installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
        }
        installLogger.logDebug("  vendor daemon name: " + (String)object3);
        final ArrayList arrayList = new ArrayList();
        boolean bl = false;
        this.serverCnt = 0;
        this.serverPresent = false;
        this.vendorPresent = false;
        this.validFile = false;
        try {
            new LicenseFileParser(string, (String)object3){
                final /* synthetic */ String val$vendorDaemon;
                {
                    this.val$vendorDaemon = string2;
                    super(string);
                }

                public void processLine(String string) {
                    if (string.matches("^SERVER\\s+.*")) {
                        ValidateLicenseFile.this.serverCnt++;
                        ValidateLicenseFile.this.serverPresent = true;
                        arrayList.add(GeneralUtil.convertIPtoHostname(string.split("\\s+")[1]));
                    } else if (string.matches("^VENDOR\\s+" + this.val$vendorDaemon + ".*")) {
                        ValidateLicenseFile.this.vendorPresent = true;
                    } else if (string.matches("^FEATURE\\s+.*") || string.matches("^INCREMENT\\s+.*")) {
                        ValidateLicenseFile.this.validFile = true;
                    }
                }
            }.parse();
        }
        catch (LicenseFileParser.LicenseFileParseException licenseFileParseException) {
            installLogger.logFatalError("Error parsing license file", "Error parsing license file: " + licenseFileParseException.getMessage(), null);
            return;
        }
        catch (LicenseFileParser.LicenseFileAccessException licenseFileAccessException) {
            installerProxy.setVariable("$CUSTOM_CODE_OUTPUT$", ACCESS_DENIED);
            installLogger.logFatalError("Error parsing license file", "Error parsing license file: " + licenseFileAccessException.getMessage(), null);
            return;
        }
        installLogger.logDebug("  license file analysis:\n    server count: " + this.serverCnt + "\n    serverPresent: " + this.serverPresent + "\n    vendorPresent: " + this.vendorPresent + "\n    validFile: " + this.validFile + "\n    server(s): " + ((Object)arrayList).toString());
        if (!this.serverPresent) {
            this.setInvalidLicenseVars(installerProxy, NO_SERVER_ENTRY);
            installLogger.logNonfatalError("Invalid License File", "Invalid License File " + string + ": no server present", null);
            bl = true;
        }
        if (!this.vendorPresent) {
            this.setInvalidLicenseVars(installerProxy, NO_VENDOR_ENTRY);
            installLogger.logNonfatalError("Invalid License File", "Invalid License File " + string + ": no vendor daemon present", null);
            bl = true;
        }
        if (!this.validFile) {
            this.setInvalidLicenseVars(installerProxy, NO_FEATURE_INCREMENT_ENTRY);
            installLogger.logNonfatalError("Invalid License File", "Invalid License File " + string + ": no features/increments present", null);
            bl = true;
        }
        if (this.serverCnt == 3) {
            for (Object object22 : arrayList) {
                if (!this.isLocalHost((String)object22)) continue;
                this.setInvalidLicenseVars(installerProxy, INVALID_THREE_SERVER_LICENSE_FILE);
                installLogger.logNonfatalError("Invalid Three Server License File", "Invalid Three Server License File " + string, null);
                bl = true;
            }
        } else if (this.serverCnt != 1) {
            this.setInvalidLicenseVars(installerProxy, INVALID_SERVER_COUNT_LICENSE_FILE);
            installLogger.logNonfatalError("Invalid Number of servers", "Invalid License File " + string + ": server count is " + this.serverCnt + ", has to be 1 or 3", null);
            bl = true;
        }
        Object object4 = "";
        try {
            object22 = InetAddress.getLocalHost();
            object4 = ((InetAddress)object22).getHostName().split("\\.")[0];
            installerProxy.setVariable("$HOST_NAME$", object4);
        }
        catch (UnknownHostException unknownHostException) {
            installerProxy.setVariable("$HOST_NAME$", installerProxy.getValue("splm.unknown.host"));
            this.setInvalidLicenseVars(installerProxy, UNKNOWN_HOST);
            installLogger.logNonfatalError("Cannot resolve current host name", null, null);
        }
        installLogger.logDebug("  this host name: " + (String)object4);
        object22 = new ArrayList<Object>();
        Object object5 = arrayList.iterator();
        while (object5.hasNext()) {
            object = (String)object5.next();
            if (this.isLocalHost((String)object) || this.isReachable((String)object, installerProxy)) continue;
            object22.add(object);
        }
        if (!(1 != this.serverCnt || arrayList.size() <= 0 || object22.contains(object5 = (String)arrayList.get(0)) || this.isLocalHost((String)object5) || this.isHostSame(installerProxy.substitute("$HOST_NAME$"), (String)object5))) {
            object22.add(object5);
        }
        if (3 == this.serverCnt) {
            boolean bl2 = false;
            object = new ArrayList();
            for (String string3 : arrayList) {
                if (object22.contains(string3) || this.isLocalHost(string3)) continue;
                if (!this.isHostSame(installerProxy.substitute("$HOST_NAME$"), string3)) {
                    object.add((String)string3);
                    continue;
                }
                bl2 = true;
                break;
            }
            if (!bl2) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    string3 = (String)iterator.next();
                    object22.add(string3);
                }
            }
        }
        if (object22.size() > 0) {
            StringBuffer stringBuffer = null;
            object = object22.iterator();
            while (object.hasNext()) {
                iterator = (String)object.next();
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer((String)((Object)iterator));
                    continue;
                }
                stringBuffer.append(", ").append((String)((Object)iterator));
            }
            installerProxy.setVariable("$INVALID_SERVER$", stringBuffer.toString());
            if (!bl) {
                installerProxy.setVariable("$CUSTOM_CODE_OUTPUT$", INVALID_SERVER_NAME);
            }
            installLogger.logNonfatalError("Invalid Server(s)", "Invalid server names: " + stringBuffer.toString(), null);
        }
    }

    private boolean isReachable(String string, VariableAccess variableAccess) {
        Object object;
        boolean bl = false;
        InstallLogger installLogger = new InstallLogger((InstallerProxy)variableAccess);
        if (OS.isFamilyWindows()) {
            object = new Command("ping");
            ((Command)object).addArgument("-n");
            ((Command)object).addArgument("3");
            ((Command)object).addArgument(string);
            SystemExecute systemExecute = new SystemExecute((Command)object, 12L);
            systemExecute.run(variableAccess);
        } else if (OS.isFamilyUnix() || OS.isFamilyMac()) {
            variableAccess.setVariable("$SERVER_NAME$", string);
            object = new ScriptRunner("ping_check.sh", variableAccess);
            ((ScriptRunner)object).executeScript(12L);
        }
        try {
            installLogger.logMessage("Exit Code =" + variableAccess.substitute("$EXECUTE_EXITCODE$"));
            int n = Integer.parseInt(variableAccess.substitute("$EXECUTE_EXITCODE$").trim());
            if (0 == n) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            installLogger.logMessage("Ping check got exit code exception");
        }
        return bl;
    }

    private boolean isHostSame(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        return stringArray[0].equalsIgnoreCase(stringArray2[0]);
    }

    public void uninstall(UninstallerProxy uninstallerProxy) throws InstallException {
    }
}

