/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Plugin.actions;

import com.siemens.plm.scl.Common.Command;
import com.siemens.plm.scl.Common.Constants;
import com.siemens.plm.scl.Common.GeneralUtil;
import com.siemens.plm.scl.Common.InstallLogger;
import com.siemens.plm.scl.Common.ScriptRunner;
import com.siemens.plm.scl.Plugin.actions.SystemExecute;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import com.zerog.ia.api.pub.VariableAccess;

public class ExecuteCommandScript
extends CustomCodeAction {
    private String command;
    private String script;
    private long timeout = 10L;

    public String getInstallStatusMessage() {
        return "Executing command please wait ...";
    }

    public String getUninstallStatusMessage() {
        return "Executing command please wait ...";
    }

    public void install(InstallerProxy installerProxy) throws InstallException {
        InstallLogger installLogger = new InstallLogger(installerProxy);
        installLogger.logDebug("Running Custom Execute Command or Script ...");
        this.command = installerProxy.substitute("$SCL_CUSTOM_COMMAND$");
        this.script = installerProxy.substitute("$SCL_CUSTOM_SCRIPT$");
        String string = installerProxy.substitute("$SCL_EXEC_TIMEOUT$");
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("(optional)")) {
            try {
                this.timeout = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                installLogger.logMessage("Timeout =" + this.timeout + " is not a long number");
                installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
            }
        }
        if (this.command.length() > 0 && !this.command.equalsIgnoreCase("(optional)")) {
            this.command = GeneralUtil.processIAVariable(this.command, installerProxy, installLogger);
            this.run(1, installerProxy, installLogger);
        }
        if (this.script.length() > 0 && !this.script.equalsIgnoreCase("(optional)")) {
            this.run(2, installerProxy, installLogger);
        }
    }

    private void run(int n, VariableAccess variableAccess, InstallLogger installLogger) {
        SystemExecute systemExecute = null;
        switch (n) {
            case 1: {
                Command command = new Command(this.command);
                systemExecute = new SystemExecute(command, this.timeout);
                systemExecute.run(variableAccess);
                break;
            }
            case 2: {
                ScriptRunner scriptRunner = new ScriptRunner(this.script, variableAccess);
                scriptRunner.executeScript(this.timeout);
                break;
            }
        }
        if (null != systemExecute) {
            variableAccess.setVariable("$EXECUTE_STDOUT$", systemExecute.getStdOutput());
            variableAccess.setVariable("$EXECUTE_STDERR$", systemExecute.getStdError());
            variableAccess.setVariable("$EXECUTE_EXITCODE$", systemExecute.getExitCode());
        }
    }

    public void uninstall(UninstallerProxy uninstallerProxy) throws InstallException {
        this.command = uninstallerProxy.substitute("$SCL_CUSTOM_COMMAND$");
        this.script = uninstallerProxy.substitute("$SCL_CUSTOM_SCRIPT$");
        String string = uninstallerProxy.substitute("$SCL_EXEC_TIMEOUT$");
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("(optional)")) {
            try {
                this.timeout = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Uninstallation Aborted");
            }
        }
        if (this.command.length() > 0 && !this.command.equalsIgnoreCase("(optional)")) {
            this.command = GeneralUtil.processIAVariable(this.command, uninstallerProxy, null);
            this.run(1, uninstallerProxy, null);
        }
        if (this.script.length() > 0 && !this.script.equalsIgnoreCase("(optional)")) {
            this.run(2, uninstallerProxy, null);
        }
    }
}

