/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.Plugin.actions;

import com.siemens.plm.scl.Common.Command;
import com.siemens.plm.scl.Common.InstallLogger;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.VariableAccess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;

public class SystemExecute {
    private Command command = null;
    private int exitCode = 0;
    private long timeout;
    private ByteArrayOutputStream stdout = new ByteArrayOutputStream();
    private ByteArrayOutputStream stderr = new ByteArrayOutputStream();
    private static final int SUCCESS_STATUS = 0;
    private static final int ERROR_STATUS = 1;

    public String getStdOutput() {
        return this.stdout.toString();
    }

    public String getStdError() {
        return this.stderr.toString();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void run(VariableAccess variableAccess) {
        CommandLine commandLine;
        InstallLogger installLogger = null;
        if (variableAccess instanceof InstallerProxy) {
            installLogger = new InstallLogger((InstallerProxy)variableAccess);
        }
        if (null != (commandLine = this.command.getCommand())) {
            DefaultExecutor defaultExecutor = new DefaultExecutor();
            defaultExecutor.setExitValue(0);
            ExecuteWatchdog executeWatchdog = new ExecuteWatchdog(this.timeout * 1000L);
            defaultExecutor.setWatchdog(executeWatchdog);
            defaultExecutor.setStreamHandler(new PumpStreamHandler(this.stdout, this.stderr));
            try {
                this.exitCode = defaultExecutor.execute(commandLine);
            }
            catch (ExecuteException executeException) {
                this.exitCode = 1;
            }
            catch (IOException iOException) {
                this.exitCode = 1;
            }
            catch (Exception exception) {
                this.exitCode = 1;
            }
            if (null != installLogger) {
                this.logExecDetails(installLogger, commandLine.toString());
            }
            variableAccess.setVariable("$EXECUTE_STDOUT$", this.getStdOutput());
            variableAccess.setVariable("$EXECUTE_STDERR$", this.getStdError());
            variableAccess.setVariable("$EXECUTE_EXITCODE$", this.getExitCode());
        } else {
            installLogger.logFatalError("No Command specified", "No command has been specified to run.", null);
        }
    }

    private void logExecDetails(InstallLogger installLogger, String string) {
        StringBuilder stringBuilder = new StringBuilder("Execute Command/Script Summary:\n");
        stringBuilder.append("-------------------------------").append('\n');
        stringBuilder.append("  Command/Script Executed : " + string).append('\n');
        stringBuilder.append("  ExitCode                : " + this.getExitCode()).append('\n');
        stringBuilder.append("  Standard Output         : " + this.getStdOutput()).append('\n');
        stringBuilder.append("  Standard Error          : " + this.getStdError()).append('\n');
        installLogger.logMessage(stringBuilder.toString());
    }

    public SystemExecute(Command command, long l) {
        this.command = command;
        this.timeout = l;
    }
}

