/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.unix.actions;

import com.siemens.plm.scl.Common.Constants;
import com.siemens.plm.scl.Common.GeneralUtil;
import com.siemens.plm.scl.Common.InstallLogger;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.exec.OS;

public class CheckInstalledVersion
extends CustomCodeAction {
    public String getInstallStatusMessage() {
        return "Checking for installed version of Siemens PLM License Server";
    }

    public String getUninstallStatusMessage() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(InstallerProxy installerProxy) throws InstallException {
        Object object;
        File file;
        InstallLogger installLogger = new InstallLogger(installerProxy);
        installLogger.logDebug("Executing CheckInstalledVersion");
        String string = installerProxy.substitute("$SERVER_STARTUP_PATH$");
        String string2 = null;
        if (!GeneralUtil.isDefined(string)) {
            new InstallLogger(installerProxy).logFatalError("SERVER_STARTUP_SCRIPT is not defined in SameVersionExists check", null, null);
            installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
        }
        if (!GeneralUtil.isDefined(string2 = OS.isFamilyMac() ? installerProxy.substitute("$MAC_LAUNCHD_PLIST$") : installerProxy.substitute("$DAEMON_NAME$"))) {
            new InstallLogger(installerProxy).logFatalError("DAEMON_NAME is not defined in SameVersionExists check", null, null);
            installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
        }
        String string3 = string + "/" + string2;
        if (OS.isFamilyMac()) {
            file = new File("/Library/StartupItems/splmld/splmld");
            object = new File("/System/Library/LaunchDaemons/com.siemens.splmld.plist");
            if (file.isFile() && ((File)object).isFile()) {
                string3 = ((File)object).getAbsolutePath();
            } else if (file.isFile() && !((File)object).isFile()) {
                installerProxy.setVariable("$PRE_LAUNCHD_INSTALLER$", "1");
                string3 = file.getAbsolutePath();
            }
        }
        installLogger.logDebug("  startup script: " + string3);
        installerProxy.setVariable("$ALREADY_INSTALLED$", "");
        installerProxy.setVariable("$ALREADY_INSTALLED_VERSION$", "");
        file = new File(string3);
        if (file.exists()) {
            installLogger.logDebug("  script exists");
            installerProxy.setVariable("$ALREADY_INSTALLED$", "true");
            object = null;
            IOException iOException = null;
            FilterInputStream filterInputStream = null;
            BufferedReader bufferedReader = null;
            try {
                String string4;
                FileInputStream fileInputStream = new FileInputStream(file.getAbsolutePath());
                filterInputStream = new DataInputStream(fileInputStream);
                bufferedReader = new BufferedReader(new InputStreamReader(filterInputStream));
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (!string4.replaceFirst("#.*", "").trim().startsWith("LICENSE_VER=")) continue;
                    object = string4.replaceFirst("^LICENSE_VER=", "");
                    break;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                iOException = fileNotFoundException;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            finally {
                try {
                    filterInputStream.close();
                    bufferedReader.close();
                }
                catch (IOException iOException3) {}
            }
            if (iOException != null) {
                new InstallLogger(installerProxy).logNonfatalError("Cannot parse installed server script", "Cannot parse installed script (" + string3 + "): " + iOException.getMessage(), null);
                return;
            }
            if (object == null) {
                new InstallLogger(installerProxy).logWarning("Installed server script doesn't contain version information", "Installed script (" + string3 + "): doesn't contain version information", null);
                return;
            }
            installerProxy.setVariable("$ALREADY_INSTALLED_VERSION$", object);
            installLogger.logDebug("  found installed version: " + (String)object);
        } else {
            installLogger.logDebug("  script not found, no Siemens PLM Server installed on this system");
        }
    }

    public void uninstall(UninstallerProxy uninstallerProxy) throws InstallException {
    }
}

