/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.plm.scl.unix.actions;

import com.siemens.plm.scl.Common.Constants;
import com.siemens.plm.scl.Common.GeneralUtil;
import com.siemens.plm.scl.Common.InstallLogger;
import com.siemens.plm.scl.Common.OSUtils;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import com.zerog.ia.api.pub.VariableAccess;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import org.apache.commons.exec.OS;

public class CreateRCFile
extends CustomCodeAction {
    private String installDir;
    private String licenseFile;
    private String licenseLog;
    private String licenseUser;

    public String getInstallStatusMessage() {
        return "Creating RC Scripts";
    }

    public String getUninstallStatusMessage() {
        return null;
    }

    public void install(InstallerProxy installerProxy) throws InstallException {
        InstallLogger installLogger = new InstallLogger(installerProxy);
        installLogger.logDebug("Running action CreateRCFile:");
        if (OSUtils.isOSWindows()) {
            new InstallLogger(installerProxy).logFatalError("CreateRCFile operation is not valid on " + OSUtils.getCurrentOS(), null, null);
            installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
        }
        this.licenseUser = installerProxy.substitute("$USER_INPUT_ACCOUNT_NAME$");
        this.installDir = installerProxy.substitute("$USER_INSTALL_DIR$").replaceFirst("[\\\\\\/]$", "");
        this.licenseFile = installerProxy.substitute("$DEFAULT_LICENSE_FILE$");
        this.licenseLog = installerProxy.substitute("$SERVER_LOG_DIR$").replaceFirst("[\\\\\\/]$", "") + "/" + installerProxy.substitute("$SERVER_LOG$");
        String string = installerProxy.substitute("$DAEMON_NAME$");
        if (!(GeneralUtil.isDefined(this.installDir) && GeneralUtil.isDefined(this.licenseFile) && GeneralUtil.isDefined(this.licenseLog) && GeneralUtil.isDefined(string))) {
            new InstallLogger(installerProxy).logFatalError("Some IA variables are undefined", null, null);
            installerProxy.abortInstallation(Constants.ABORT_EXIT_CODE);
        }
        if (OS.isFamilyMac()) {
            this.createScript(installerProxy.substitute("$MAC_LAUNCHD_PLIST$"), installerProxy);
        } else {
            this.createScript(string, installerProxy);
        }
        string = installerProxy.substitute("$START_STOP_SCRIPT_NAME$");
        this.createScript(string, installerProxy);
    }

    private void createScript(String string, VariableAccess variableAccess) {
        InstallLogger installLogger = new InstallLogger((InstallerProxy)variableAccess);
        String string2 = this.installDir + "/" + string + ".template";
        String string3 = this.installDir + "/" + string;
        installLogger.logDebug("  output script: " + string3);
        try {
            Scanner scanner = new Scanner(new File(string2));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string3));
            while (scanner.hasNextLine()) {
                String string4 = scanner.nextLine();
                if (string4.trim().contains("@LICENSE_DIR@")) {
                    string4 = string4.replace("@LICENSE_DIR@", GeneralUtil.processFileNameSpaces(this.installDir));
                    installLogger.logDebug("    setting LICENSE_DIR to " + this.installDir);
                }
                if (string4.trim().contains("@LICENSE_VER@")) {
                    string4 = string4.replace("@LICENSE_VER@", variableAccess.substitute("$PRODUCT_VERSION_NUMBER$"));
                    installLogger.logDebug("    setting LICENSE_VER to " + variableAccess.substitute("$PRODUCT_VERSION_NUMBER$"));
                }
                if (string4.trim().contains("@LICENSE_FILE@")) {
                    string4 = string4.replace("@LICENSE_FILE@", GeneralUtil.processFileNameSpaces(this.licenseFile));
                    installLogger.logDebug("    setting LICENSE_FILE to " + this.licenseFile);
                }
                if (string4.trim().contains("@LOG_FILE@")) {
                    string4 = string4.replace("@LOG_FILE@", this.licenseLog);
                    installLogger.logDebug("    setting LOG_FILE to " + this.licenseLog);
                }
                if (string4.trim().contains("@LICENSE_USER@")) {
                    string4 = string4.replace("@LICENSE_USER@", this.licenseUser);
                    installLogger.logDebug("    setting LICENSE_USER to " + this.licenseUser);
                }
                bufferedWriter.write(string4);
                bufferedWriter.newLine();
            }
            scanner.close();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            installLogger.logFatalError("Error while building the server startup script", iOException.getMessage(), null);
        }
    }

    public void uninstall(UninstallerProxy uninstallerProxy) throws InstallException {
    }
}

