/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.java.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;

public class FileUtil {
    public static String getPlainName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > -1 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static void deleteRecursively(File file) throws IOException {
        int n;
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                FileUtil.deleteRecursively(new File(file.getCanonicalPath() + File.separator + stringArray[n]));
            }
        }
        n = file.delete();
    }

    public static void emptyOrCreateDirectory(File file) throws IOException {
        if (file.exists()) {
            FileUtil.deleteRecursively(file);
        }
        file.mkdirs();
    }

    public static File[] getAllFilesFromDirTree(File file) {
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException("The specified parameter is NOT a directory: " + file);
        }
        Vector vector = new Vector();
        FileUtil.a(file, vector);
        File[] fileArray = new File[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            fileArray[i] = (File)vector.elementAt(i);
        }
        return fileArray;
    }

    private static void a(File file, Vector vector) {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                FileUtil.a(file2, vector);
                continue;
            }
            vector.addElement(file2);
        }
    }

    public static String appendFileSeparator(String string) {
        if (string != null && !(string = string.trim()).endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separator;
        }
        return string;
    }

    public static String removeTrailingSeparators(String string) {
        if (string != null) {
            string = string.trim();
            int n = 0;
            if (string.endsWith("/") || string.endsWith("\\")) {
                ++n;
            }
            if (n > 0) {
                string = string.substring(0, string.length() - n);
            }
        }
        return string;
    }

    public static String convertToOsAppropriateSeparators(String string) {
        if (string != null) {
            string = string.replace('\\', '/');
            string = string.replace('/', File.separatorChar);
        }
        return string;
    }

    public static File findLastDirectory(String string) {
        return FileUtil.findLastDirectory(new File(string));
    }

    public static File findFirstNonExistingDirectory(String string) {
        return FileUtil.findFirstNonExistingDirectory(new File(string));
    }

    public static File findLastDirectory(File file) {
        return file.isFile() ? new File(file.getParent()) : file;
    }

    public static File findFirstNonExistingDirectory(File file) {
        File file2 = FileUtil.findLastDirectory(file);
        File file3 = null;
        while (!file2.isDirectory()) {
            file3 = file2;
            file2 = new File(file2.getParent());
        }
        return file3;
    }

    public static boolean isValidPath(String string) {
        return string != null && string.trim().length() > 0 && FileUtil.isValidPath(new File(string));
    }

    public static boolean isInvalidPath(String string) {
        return !FileUtil.isValidPath(string);
    }

    public static boolean isValidPath(File file) {
        boolean bl;
        File file2 = FileUtil.findFirstNonExistingDirectory(file);
        boolean bl2 = bl = file.isDirectory() || file.mkdirs();
        if (file2 != null && file2.exists()) {
            try {
                FileUtil.deleteRecursively(file2);
            }
            catch (IOException iOException) {
                ZeroGb.j("Unable to delete directory just created to validate path.");
            }
        }
        return bl;
    }

    public static boolean isInvalidPath(File file) {
        return !FileUtil.isValidPath(file);
    }

    public static boolean isAbsolute(String string) {
        string = FileUtil.normalizeFileName(string);
        File file = new File(string);
        return string.startsWith(File.separator) || file.isAbsolute();
    }

    public static String normalizeFileName(String string) {
        return FileUtil.normalizeFileName(string, File.separatorChar);
    }

    public static String normalizeFileName(String string, char c) {
        if (string == null) {
            throw new NullPointerException("fileName cannot be null");
        }
        return string.replace('/', c).replace('\\', c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canReadAndWrite(File file) {
        boolean bl;
        block5: {
            if (!(!file.exists() || file.canWrite() && file.canRead())) {
                return false;
            }
            boolean bl2 = !file.exists();
            try {
                new FileOutputStream(file.getAbsolutePath(), true).close();
                new FileInputStream(file.getAbsolutePath()).close();
                bl = true;
                Object var5_4 = null;
                if (!bl2) break block5;
                file.delete();
            }
            catch (IOException iOException) {
                boolean bl3;
                block6: {
                    try {
                        bl3 = false;
                        Object var5_5 = null;
                        if (!bl2) break block6;
                        file.delete();
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var5_6 = null;
                            if (!bl2) break block7;
                            file.delete();
                        }
                        throw throwable;
                    }
                }
                return bl3;
            }
        }
        return bl;
    }

    public static String getMD5OfFile(File file) throws IOException {
        ZeroGan zeroGan = new ZeroGan();
        zeroGan.a(new FileInputStream(file));
        return zeroGan.b();
    }

    public static String getMD5OfStream(InputStream inputStream) throws IOException {
        ZeroGan zeroGan = new ZeroGan();
        zeroGan.a(inputStream);
        return zeroGan.b();
    }

    public static String readFileToString(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = System.getProperty("line.separator");
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static String[] readFileContentsToStringArray(File file) throws IOException {
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string.trim());
        }
        arrayList.add(file.getAbsolutePath());
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }
}

