/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.iseries.util.rair;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileReader;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.iseries.service.i5OSService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public abstract class i5OSRAIRCallService {
    public final int CCSID = 37;
    public final String INSTALLER_TYPE = "InstallAnywhere (" + Installer.getVersionNumberString(false) + ")";
    public transient i5OSService service;
    private String productName = "";
    private String componentVersion = "";
    private String componentName = "";
    private String featureName = "";
    private String instance = "";
    private String ccsid = "";
    private String installerType = "";

    public i5OSRAIRCallService(i5OSService i5OSService2) {
        this.service = i5OSService2;
    }

    public abstract String getProgramCallDocumentFullName();

    public abstract String getProgramCallDocumentShortName();

    public abstract IFSFile getAPIInputFile();

    public abstract IFSFile getAPIOutputFile();

    public abstract void initPCMLInput(ProgramCallDocument var1, IFSFile var2, IFSFile var3) throws PcmlException;

    public void setComponentProperties(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.productName = string;
        this.componentVersion = string2;
        this.componentName = string3;
        this.featureName = string4;
        this.instance = string5;
        this.ccsid = string6;
        this.installerType = string7;
    }

    public String invoke() throws Exception {
        IFSFile iFSFile = this.getAPIInputFile();
        if (iFSFile.exists()) {
            iFSFile.delete();
        }
        IFSTextFileOutputStream iFSTextFileOutputStream = new IFSTextFileOutputStream(this.service.geti5(), iFSFile, -4, false);
        this.createInputXML(iFSTextFileOutputStream);
        IFSFile iFSFile2 = this.getAPIOutputFile();
        if (iFSFile2 != null) {
            if (iFSFile2.exists()) {
                iFSFile2.delete();
            }
            iFSTextFileOutputStream = new IFSTextFileOutputStream(this.service.geti5(), iFSFile2, -4, false);
            iFSTextFileOutputStream.close();
        }
        ProgramCallDocument programCallDocument = new ProgramCallDocument(this.service.geti5(), this.getProgramCallDocumentFullName());
        this.initPCMLInput(programCallDocument, iFSFile, iFSFile2);
        boolean bl = programCallDocument.callProgram(this.getProgramCallDocumentShortName());
        String string = "";
        AS400Message[] aS400MessageArray = programCallDocument.getMessageList(this.getProgramCallDocumentShortName());
        if (!bl) {
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                String string2 = aS400MessageArray[i].getID();
                String string3 = aS400MessageArray[i].getText();
                string = string + string2 + " - " + string3 + "\n";
            }
            throw new Exception(string);
        }
        if (iFSFile2 != null) {
            return this.readFile(iFSFile2);
        }
        return null;
    }

    private String readFile(IFSFile iFSFile) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader((Reader)new IFSFileReader(iFSFile));
        String string = bufferedReader.readLine();
        stringBuffer.append("<?xml version='1.0' encoding='UTF-8'?>");
        string = bufferedReader.readLine();
        while (string != null) {
            stringBuffer.append(string);
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuffer.toString().trim();
    }

    private void createInputXML(IFSTextFileOutputStream iFSTextFileOutputStream) throws IOException {
        iFSTextFileOutputStream.write("<?xml version=\"1.0\" encoding=\"UTF-16\"?>\n");
        iFSTextFileOutputStream.write("<!DOCTYPE RegAppInfoRepository SYSTEM \"/QIBM/XML/DTD/QszRegAppInfoRepository.dtd\">\n");
        iFSTextFileOutputStream.write("<RegAppInfoRepository DTDVersion=\"1.0\">\n");
        iFSTextFileOutputStream.write(this.getComponentInputNode());
        iFSTextFileOutputStream.write("</RegAppInfoRepository>\n");
        iFSTextFileOutputStream.flush();
        iFSTextFileOutputStream.close();
    }

    public String getComponentInputNode() {
        if (this.productName == null) {
            this.productName = "";
        }
        if (this.componentName == null) {
            this.componentName = "";
        }
        if (this.componentVersion == null) {
            this.componentVersion = "";
        }
        if (this.featureName == null) {
            this.featureName = "";
        }
        if (this.instance == null) {
            this.instance = "";
        }
        if (this.installerType == null) {
            this.installerType = this.INSTALLER_TYPE;
        }
        if (this.ccsid == null) {
            this.ccsid = new Integer(37).toString();
        }
        String string = "<Component ";
        string = string + "ProductName=\"" + this.productName + "\" ";
        string = string + "ComponentName=\"" + this.componentName + "\" ";
        if (!this.componentVersion.equals("")) {
            string = string + "ComponentVersion=\"" + this.componentVersion + "\" ";
        }
        if (!this.featureName.equals("")) {
            string = string + "FeatureName=\"" + this.featureName + "\" ";
        }
        if (!this.instance.equals("")) {
            string = string + "Instance=\"" + this.instance + "\"";
        }
        string = string + ">\n";
        if (!this.installerType.equals("") || !this.ccsid.equals("")) {
            string = string + "<ExtendedData ";
            if (!this.installerType.equals("")) {
                string = string + "InstallerType=\"" + this.installerType + "\" ";
            }
            if (!this.ccsid.equals("")) {
                string = string + "CCSID=\"" + this.ccsid + "\"";
            }
            string = string + "></ExtendedData>\n";
        }
        string = string + "</Component>\n";
        return string;
    }

    public void initPCMLInputForFile(ProgramCallDocument programCallDocument, IFSFile iFSFile, String string) throws PcmlException {
        String string2 = this.getProgramCallDocumentShortName() + "." + string + ".";
        programCallDocument.setIntValue(string2 + "CCSID", 37);
        programCallDocument.setIntValue(string2 + "countryID", 0);
        programCallDocument.setIntValue(string2 + "languageID", 0);
        programCallDocument.setIntValue(string2 + "unused1", 0);
        programCallDocument.setIntValue(string2 + "unused2", 0);
        programCallDocument.setIntValue(string2 + "pathLength", iFSFile.getAbsolutePath().length());
        programCallDocument.setValue(string2 + "appInfoPathName", (Object)iFSFile.getAbsolutePath());
    }
}

