/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.expanders;

import com.zerog.ia.installer.IAStatus;
import com.zerog.ia.installer.IAStatusLog;
import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.util.MacFileTyper;
import com.zerog.util.expanders.ExpandEvent;
import com.zerog.util.expanders.ExpandListener;
import com.zerog.util.expanders.ExpandToDiskInterface;
import com.zerog.util.expanders.RandomAccessInterface;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ExpandToDiskZip
implements ExpandToDiskInterface,
RandomAccessInterface {
    private static final int BUFFER_SIZE_BYTES = 131072;
    public transient ExpandListener listener;
    public boolean shouldUninstall = true;
    public boolean rollbackEnabledCancel;
    public boolean rollbackEnabledError;
    public static final int FM_DEFAULT = 0;
    public static final int FM_PRESERVE = 1;
    public static final int FM_OVERWRITE = 2;
    private int fileModificationTimestampBehavior = -1;
    private long fileModificationTimestamp = -1L;
    private boolean debug = ZeroGb.d();
    private ZeroGfi check = null;
    private Installer installer;

    public void expand(InputStream inputStream, String string, String string2, String string3) throws IOException {
        String string4 = string2 != null && string2 != "" ? string + string2 + System.getProperty("file.separator") : string;
        this.expand(inputStream, string4, this.shouldUninstall, null, this.rollbackEnabledCancel, this.rollbackEnabledError);
    }

    public InputStream findEntry(ZipFile zipFile, String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) throws IOException {
        this.shouldUninstall = bl;
        this.rollbackEnabledCancel = bl2;
        this.rollbackEnabledError = bl3;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.getName().compareTo(string) != 0) continue;
            return zipFile.getInputStream(zipEntry);
        }
        return null;
    }

    public void expand(InputStream inputStream, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws IOException {
        ZipEntry zipEntry;
        this.shouldUninstall = bl;
        this.rollbackEnabledCancel = bl2;
        this.rollbackEnabledError = this.rollbackEnabledError;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            try {
                this.expandEntry(zipInputStream, zipEntry, string, string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        zipInputStream.close();
    }

    public void setInstaller(Installer installer) {
        this.installer = installer;
    }

    public Installer getInstaller() {
        return this.installer;
    }

    public void expandEntry(InputStream inputStream, ZipEntry zipEntry, String string, String string2) throws IOException {
        String string3 = zipEntry.getName().replace('/', File.separatorChar);
        if (string2 != null && !"".equals(string2) && string3.startsWith(string2)) {
            string3 = string3.substring(string2.length());
        }
        String string4 = string + string3;
        string4 = ZeroGd.g(string4);
        ZeroGe zeroGe = new ZeroGe(ZeroGd.e(string4));
        if (zipEntry.isDirectory()) {
            this.recursivelyCreateDirectoriesIfNeeded(new File(string), string3);
        } else {
            Object object;
            if (zeroGe.getParent() != null && (object = new File(string3).getParent()) != null && !((String)object).equals("")) {
                this.recursivelyCreateDirectoriesIfNeeded(new File(string), (String)object);
            }
            object = new IAStatus("Install File:             " + zeroGe.getAbsolutePath());
            ((IAStatus)object).setDestinationPath(zeroGe.getParent());
            ((IAStatus)object).setDestinationName(zeroGe.getName());
            boolean bl = true;
            if (this.check != null) {
                this.check.a(ZeroGd.g(zeroGe.getAbsolutePath()));
                this.check.b(this.decodeTimeStamp(zipEntry));
                if (!this.check.a()) {
                    bl = false;
                    if (this.debug) {
                        System.err.println("File \"" + zipEntry.getName() + "\" not installed due to file overwrite settings");
                    }
                    ((IAStatus)object).a("File not installed due to file overwrite settings", 99);
                    ((IAStatus)object).a(this.check.b(), 99);
                    return;
                }
                if (this.debug) {
                    System.err.println("File \"" + zipEntry.getName() + "\" will be installed because check was true");
                }
            } else if (this.debug) {
                System.err.println("File \"" + zipEntry.getName() + "\" will be installed because check was null");
            }
            if (this.listener != null) {
                this.listener.writeFilePathToInstallerLog(ZeroGd.g(zeroGe.getAbsolutePath()), false, this.shouldUninstall, this.rollbackEnabledCancel, this.rollbackEnabledError);
            }
            try {
                boolean bl2 = false;
                String string5 = zeroGe.getAbsolutePath();
                ZeroGb6 zeroGb6 = ZeroGb9.b().a(zeroGe.getAbsolutePath());
                zeroGb6.a(true);
                if (this.listener != null) {
                    zeroGb6.a(new ZeroGfp(){

                        public void statusChanged(ZeroGfq zeroGfq) {
                            if (ExpandToDiskZip.this.listener != null) {
                                ExpandToDiskZip.this.listener.bytesWritten(new ExpandEvent(ExpandToDiskZip.this, zeroGfq.g()));
                            }
                        }
                    });
                }
                ZeroGfq zeroGfq = zeroGb6.putStream(inputStream, false);
                string5 = zeroGfq.j();
                if (inputStream instanceof ZipInputStream) {
                    ((ZipInputStream)inputStream).closeEntry();
                }
                ZeroGe.b((File)zeroGe);
                MacFileTyper macFileTyper = MacFileTyper.getInstance();
                if (macFileTyper != null) {
                    macFileTyper.addFile(zeroGe);
                }
                this.timestamp(zipEntry, new File(string5));
                if (this.getInstaller() != null && this.getInstaller().getUnixPermissions() != null && !"".equals(this.getInstaller().getUnixPermissions()) && !ZeroGd.ab && ZeroGd.at) {
                    ZeroGd6.k().a(string4, this.getInstaller().getUnixPermissions(), false, true);
                } else if (this.getInstaller() != null && this.getInstaller().getMacOSXPermissions() != null && !"".equals(this.getInstaller().getMacOSXPermissions()) && ZeroGd.ab) {
                    if (ZeroGd.h()) {
                        ZeroGd6.k().a(string4, new int[]{0, 1}, new String[]{this.getInstaller().getMacOSXPermissions(), ZeroGd.f()});
                    } else {
                        ZeroGd6.k().a(string4, this.getInstaller().getMacOSXPermissions());
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ((IAStatus)object).a(exception.toString(), 97);
            }
            IAStatusLog.e().a((IAStatus)object);
        }
    }

    public long decodeTimeStamp(ZipEntry zipEntry) throws IOException {
        return ZeroGff.a(zipEntry);
    }

    private void recursivelyCreateDirectoriesIfNeeded(File file, String string) throws IOException {
        File file2 = new File(string);
        File file3 = new File(file, file2.getPath());
        if (file3.exists()) {
            return;
        }
        if (file2.getParent() != null && !"".equals(file2.getParent())) {
            this.recursivelyCreateDirectoriesIfNeeded(file, file2.getParent());
        }
        if (!file3.mkdir() && !file3.exists() || !file3.isDirectory()) {
            IAStatus iAStatus = new IAStatus("Install Directory:        " + file3.getAbsolutePath());
            iAStatus.setDestinationPath(file3.getParent());
            iAStatus.setDestinationName(file3.getName());
            iAStatus.a(97);
            IAStatusLog.e().a(iAStatus);
            throw new IOException(file3 + ": could not create directory");
        }
        if (this.listener != null) {
            this.listener.writeFilePathToInstallerLog(ZeroGd.g(file3.getAbsolutePath()), true, this.shouldUninstall, this.rollbackEnabledCancel, this.rollbackEnabledError);
        }
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.listener = expandListener;
    }

    public boolean isSupported(ZeroGtl zeroGtl) {
        return zeroGtl.toString().equals("zip") || zeroGtl.toString().equals("jar");
    }

    public boolean wantsToKnowAboutInstallerEnding() {
        return false;
    }

    public void setFileModificationTimestampBehavior(int n) {
        this.fileModificationTimestampBehavior = n;
    }

    public int getFileModificationTimestampBehavior() {
        return this.fileModificationTimestampBehavior;
    }

    public void setFileModificationTimestamp(long l) {
        this.fileModificationTimestamp = l;
    }

    public long getFileModificationTimestamp() {
        return this.fileModificationTimestamp;
    }

    public void cleanUp() {
    }

    private void timestamp(ZipEntry zipEntry, File file) {
        switch (this.fileModificationTimestampBehavior) {
            case 1: {
                long l = -1L;
                try {
                    l = this.decodeTimeStamp(zipEntry);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (l == -1L) {
                    l = zipEntry.getTime();
                }
                if (this.debug) {
                    System.err.println("Setting preserved timestamp: " + l);
                }
                ZeroGff.a(file, l);
                break;
            }
            case 2: {
                if (this.debug) {
                    System.err.println("Setting overridden timestamp: " + this.fileModificationTimestamp);
                }
                ZeroGff.a(file, this.fileModificationTimestamp);
                break;
            }
            case 0: {
                if (!this.debug) break;
                System.err.println("Setting install time timestamp");
            }
        }
    }

    public void setTargetCheck(ZeroGfi zeroGfi) {
        this.check = zeroGfi;
    }
}

