/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.jvm;

import com.zerog.util.jvm.ValidatorUtils;
import com.zerog.util.jvm.Version;
import java.util.StringTokenizer;

public class Filter {
    public static final String JRE_JVM_TYPE = "JRE";
    public static final String JDK_JVM_TYPE = "JDK";
    public static final String ALL_JVM_TYPE = "ALL";
    public static final String UNKNOW_JVM_TYPE = "UNKNOW";
    private String vendor;
    private String type;
    private Version version;

    public Filter() {
    }

    public Filter(String string, String string2, String string3) {
        this.setVendor(string);
        this.setType(string2);
        if (string3 != null && string3.trim().length() > 0) {
            this.setVersion(Version.parse(string3));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String toString() {
        String string = "";
        if (!ValidatorUtils.isEmpty(this.vendor)) {
            string = this.vendor;
        }
        if (!ValidatorUtils.isEmpty(this.type)) {
            string = ValidatorUtils.isEmpty(string) ? string + this.type : string + "_" + this.type;
        }
        if (this.version != null) {
            string = ValidatorUtils.isEmpty(string) ? string + this.version.toString() : string + "_" + this.version.toString();
        }
        return string;
    }

    public static Filter parse(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        Filter filter = new Filter();
        String string2 = "";
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase(JRE_JVM_TYPE) || string3.equalsIgnoreCase(JDK_JVM_TYPE) || string3.equalsIgnoreCase(ALL_JVM_TYPE)) {
                filter.setType(string3);
                continue;
            }
            if (ValidatorUtils.containsOnlyDigitAndChars(string3, new char[]{'.', '_', '+', '*'})) {
                if (ValidatorUtils.isEmpty(string2)) {
                    if (Version.isValid(string3)) {
                        string2 = string3;
                        bl = true;
                        continue;
                    }
                    return null;
                }
                if (bl) {
                    if (ValidatorUtils.contains(string3, '.') || ValidatorUtils.contains(string3, '*') || ValidatorUtils.contains(string3, '+')) {
                        if (ValidatorUtils.containsOnlyDigitAndChars(string3, new char[]{'*', '+'})) {
                            string2 = string2 + "_" + string3;
                            continue;
                        }
                        if (!Character.isDigit(string3.charAt(0)) || !ValidatorUtils.contains(string3, '*')) continue;
                        string2 = string2 + "_" + string3;
                        continue;
                    }
                    string2 = string2 + "_" + string3;
                    continue;
                }
                string2 = string2 + "_" + string3;
                continue;
            }
            filter.setVendor(string3);
        }
        if (!ValidatorUtils.isEmpty(string2)) {
            filter.setVersion(Version.parse(string2));
        }
        if (!Filter.isValid(filter, string)) {
            return null;
        }
        return filter;
    }

    private static boolean isValid(Filter filter, String string) {
        if (filter != null) {
            int n = 0;
            if (!ValidatorUtils.isEmpty(filter.getVendor())) {
                ++n;
            }
            if (!ValidatorUtils.isEmpty(filter.getType())) {
                ++n;
            }
            if (filter.getVersion() != null) {
                ++n;
                if (filter.getVersion().toString().indexOf(95) > -1) {
                    ++n;
                }
            }
            return n > 0 && ValidatorUtils.getCharCount(string, '_') == n - 1;
        }
        return false;
    }

    public static boolean isValid(String string) {
        return Filter.isValid(Filter.parse(string), string);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
        n2 = 31 * n2 + (this.vendor == null ? 0 : this.vendor.hashCode());
        n2 = 31 * n2 + (this.version == null ? 0 : this.version.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Filter filter = (Filter)object;
        if (this.type == null ? filter.type != null : !this.type.equals(filter.type)) {
            return false;
        }
        if (this.vendor == null ? filter.vendor != null : !this.vendor.equals(filter.vendor)) {
            return false;
        }
        return !(this.version == null ? filter.version != null : !this.version.equals(filter.version));
    }
}

