/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.ejalbert;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class LaunchUnixBrowser
implements Runnable {
    public static final int RETURN_SUCCESS = 0;
    public static final int RETURN_FAILED = 1;
    public static final int RETURN_NOEXEC = 2;
    public static final int RETURN_BADPLATFORM = 3;
    public static final int RETURN_INVALID = -1;
    private String browser;
    private String url;
    private int returnCode;
    private static String NL = "\n";
    private static StringBuffer text = null;

    public LaunchUnixBrowser(String string, String string2) {
        this.setBrowser(string);
        string2 = string2.replaceAll("\\s", "%20");
        this.setUrl(string2);
        this.returnCode = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (!ZeroGd.at) {
            LaunchUnixBrowser.debug("can't run a shell script on non unix platform.");
            this.returnCode = 3;
            return;
        }
        String string = "LaunchUnixBrowser::run()- ";
        LaunchUnixBrowser.debug(string + "launching '" + this.getBrowser() + "' @ '" + this.getUrl() + "'");
        File file = null;
        try {
            try {
                file = LaunchUnixBrowser.getScriptFile();
                LaunchUnixBrowser.debug(string + "scriptfile is '" + file.getAbsolutePath() + "'");
                LaunchUnixBrowser.writeScript(file);
                LaunchUnixBrowser.debug(string + "script script, executing Runtime.exec()");
                this.returnCode = Runtime.getRuntime().exec(new String[]{"/bin/sh", file.getAbsolutePath(), this.getBrowser(), this.getUrl()}).waitFor();
                LaunchUnixBrowser.debug(string + "Runtime.exec() finished, return code: " + this.returnCode);
            }
            catch (IOException iOException) {
                this.returnCode = 2;
                LaunchUnixBrowser.error(iOException.getClass().getName() + ": " + iOException.getMessage());
                Object var5_4 = null;
                if (file == null) return;
                file.delete();
                return;
            }
            catch (InterruptedException interruptedException) {
                this.returnCode = 2;
                LaunchUnixBrowser.error(interruptedException.getClass().getName() + ": " + interruptedException.getMessage());
                Object var5_5 = null;
                if (file == null) return;
                file.delete();
                return;
            }
            Object var5_3 = null;
            if (file == null) return;
            file.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (file == null) throw throwable;
            file.delete();
            throw throwable;
        }
    }

    private static void writeScript(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(LaunchUnixBrowser.getText().toCharArray());
        fileWriter.close();
    }

    private static File getScriptFile() {
        return ZeroGc.a().a("launchBrowser", ".sh");
    }

    private static void debug(String string) {
        System.out.println(string);
    }

    private static void error(String string) {
        System.err.println(string);
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String string) {
        this.browser = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    private static String getText() {
        if (text == null) {
            text = new StringBuffer();
            text.append("#!/bin/sh").append(NL);
            text.append("BROWSER=$1").append(NL);
            text.append("URL=$2").append(NL);
            text.append("EXPR=`echo $PATH | sed 's/:/ /g'`").append(NL);
            text.append("FOUND=0").append(NL);
            text.append("for ITEM in `echo $EXPR`; do").append(NL);
            text.append(" if [ -x \"$ITEM/$BROWSER\" ]; then").append(NL);
            text.append("\t\tFOUND=1").append(NL);
            text.append("       cd $ITEM").append(NL);
            text.append("\t\tBROWSER=`echo \"$ITEM/$BROWSER\"`").append(NL);
            text.append("\t\tbreak").append(NL);
            text.append(" fi").append(NL);
            text.append("done").append(NL);
            text.append("if [ $FOUND = \"0\" ]; then").append(NL);
            text.append(" exit 1").append(NL);
            text.append("fi").append(NL);
            text.append("if [ `uname` = \"SunOS\" -o -d /etc/SuSEconfig ]; then").append(NL);
            text.append("\t$BROWSER $URL &").append(NL);
            text.append(" exit 0").append(NL);
            text.append("fi").append(NL);
            text.append("$BROWSER -remote \"openURL($URL,new-window)\"").append(NL);
            text.append("if [ $? != \"0\" ]; then").append(NL);
            text.append("\t$BROWSER -remote \"openURL($URL)\"").append(NL);
            text.append("\tif [ $? != \"0\" ]; then").append(NL);
            text.append("\t\t$BROWSER $URL &").append(NL);
            text.append("\t\texit 0").append(NL);
            text.append(" fi").append(NL);
            text.append(" exit 0").append(NL);
            text.append("fi").append(NL);
            text.append("exit 0").append(NL);
        }
        return text.toString();
    }
}

